/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.ToolUtil;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPrincipalsCommand
extends KadminCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AddPrincipalsCommand.class);
    private static final String USAGE = "Usage: add_principals [options]\n\toptions are:\n[-pwexpire pwexpdate] [-maxlife maxtixlife]\n\t\t[-kvno kvno] [-policy policy] [-clearpolicy]\n\t\t[-size principal's numbers,must be greater than zero]\n\t\t[-e keysaltlist]\n\t\t[{+|-}attribute]\n\tattributes are:\n\t\tallow_postdated allow_forwardable allow_tgs_req allow_renewable\n\t\tallow_proxiable allow_dup_skey allow_tix requires_preauth\n\t\trequires_hwauth needchange allow_svr password_changing_service\n\t\tok_as_delegate ok_to_auth_as_delegate no_auth_data_required\n\n\twhere,\n\t[-x db_princ_args]* - any number of database specific arguments.\n\t\t\tLook at each database documentation for supported arguments.\n\tExample:\n\t\tbatch_anks -expire 23/04/15:01:01:01 -kvno 1 -size 6";
    private KOptions kOptions;

    public AddPrincipalsCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String sizeTemp;
        String[] commands = input.split("\\s+");
        if (commands.length < 2) {
            System.err.println(USAGE);
            return;
        }
        this.kOptions = ToolUtil.parseOptions(commands, 1, commands.length - 1);
        if (this.kOptions.contains((KOption)KadminOption.SIZE)) {
            String isNum;
            sizeTemp = this.kOptions.getStringOption((KOption)KadminOption.SIZE);
            if (!sizeTemp.matches(isNum = "^[1-9][0-9]+")) {
                System.err.println(USAGE);
                return;
            }
        } else {
            System.err.println(USAGE);
            return;
        }
        int size = Integer.parseInt(sizeTemp);
        if (size <= 0) {
            System.err.println(USAGE);
            return;
        }
        int existNumbers = 0;
        try {
            existNumbers = this.getKadmin().size();
        }
        catch (KrbException e) {
            LOG.info("Fail to get the principal size. " + (Object)((Object)e));
            System.out.println("Fail to get the principal size.");
            return;
        }
        this.addPrincipalForSize(size, existNumbers);
    }

    private void addPrincipalForSize(int size, int existNumbers) {
        for (int i = 0; i < size; ++i) {
            try {
                int temp = i + existNumbers;
                String principalName = "E" + temp + "@EXAMPLE.COM";
                String password = "12";
                this.getKadmin().addPrincipal(principalName, password, this.kOptions);
                continue;
            }
            catch (KrbException e) {
                LOG.error("Fail to add principal. " + (Object)((Object)e));
            }
        }
        System.out.println("Principals created");
    }
}

