/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.kerby.kerberos.kerb.server.KdcConfig;
import org.apache.kerby.util.IOUtil;

public class Krb5Conf {
    public static final String KRB5_CONF = "java.security.krb5.conf";
    private static final String KRB5_CONF_FILE = "krb5.conf";
    private File confDir;
    private KdcConfig kdcConfig;

    public Krb5Conf(File confDir, KdcConfig kdcConfig) {
        this.confDir = confDir;
        this.kdcConfig = kdcConfig;
    }

    public void initKrb5conf() throws IOException {
        File confFile = this.generateConfFile();
        System.setProperty(KRB5_CONF, confFile.getAbsolutePath());
    }

    private File generateConfFile() throws IOException {
        boolean delete;
        String templateContent;
        String resourcePath = this.kdcConfig.allowUdp() != false ? "/krb5_udp.conf" : "/krb5.conf";
        try (InputStream templateResource = this.getClass().getResourceAsStream(resourcePath);){
            templateContent = IOUtil.readInput((InputStream)templateResource);
        }
        String content = templateContent;
        content = content.replaceAll("_REALM_", "" + this.kdcConfig.getKdcRealm());
        content = content.replaceAll("_KDC_HOST_", "" + this.kdcConfig.getKdcHost());
        int kdcPort = this.kdcConfig.allowUdp() != false ? this.kdcConfig.getKdcUdpPort() : this.kdcConfig.getKdcTcpPort();
        content = content.replaceAll("_KDC_PORT_", String.valueOf(kdcPort));
        if (this.kdcConfig.allowTcp().booleanValue()) {
            content = content.replaceAll("#_KDC_TCP_PORT_", "kdc_tcp_port = " + this.kdcConfig.getKdcTcpPort());
        }
        if (this.kdcConfig.allowUdp().booleanValue()) {
            content = content.replaceAll("#_KDC_UDP_PORT_", "kdc_udp_port = " + this.kdcConfig.getKdcUdpPort());
        }
        int udpLimit = this.kdcConfig.allowUdp() != false ? 4096 : 1;
        content = content.replaceAll("_UDP_LIMIT_", String.valueOf(udpLimit));
        File confFile = new File(this.confDir, KRB5_CONF_FILE);
        if (confFile.exists() && !(delete = confFile.delete())) {
            throw new RuntimeException("File delete error!");
        }
        IOUtil.writeFile((String)content, (File)confFile);
        return confFile;
    }
}

