/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadminImpl;
import org.apache.kerby.kerberos.tool.kadmin.AuthUtil;
import org.apache.kerby.kerberos.tool.kadmin.Krb5Conf;
import org.apache.kerby.kerberos.tool.kadmin.ToolUtil;
import org.apache.kerby.kerberos.tool.kadmin.command.AddPrincipalCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.AddPrincipalsCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.ChangePasswordCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.DeletePrincipalCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.GetPrincipalCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.KeytabAddCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.KeytabRemoveCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.ListPrincipalCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.ModifyPrincipalCommand;
import org.apache.kerby.kerberos.tool.kadmin.command.RenamePrincipalCommand;
import org.apache.kerby.util.OSUtil;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KadminTool {
    private static final Logger LOG = LoggerFactory.getLogger(KadminTool.class);
    private static File confDir;
    private static final String PROMPT;
    private static final String REQUEST_LIST;
    private static final String USAGE;

    private static void printUsage(String error) {
        System.err.println(error + "\n");
        System.err.println(USAGE);
        System.exit(-1);
    }

    private static void execute(LocalKadmin kadmin, String command) {
        if ((command = command.trim()).equals("list_requests") || command.equals("lr") || command.equals("?")) {
            System.out.println(REQUEST_LIST);
            return;
        }
        KadminCommand executor = null;
        if (command.startsWith("add_principal") || command.startsWith("addprinc") || command.startsWith("ank")) {
            executor = new AddPrincipalCommand(kadmin);
        } else if (command.startsWith("batch_anks") || command.startsWith("batch")) {
            executor = new AddPrincipalsCommand(kadmin);
        } else if (command.startsWith("ktadd") || command.startsWith("xst")) {
            executor = new KeytabAddCommand(kadmin);
        } else if (command.startsWith("ktremove") || command.startsWith("ktrem")) {
            executor = new KeytabRemoveCommand(kadmin);
        } else if (command.startsWith("delete_principal") || command.startsWith("delprinc")) {
            executor = new DeletePrincipalCommand(kadmin);
        } else if (command.startsWith("modify_principal") || command.startsWith("modprinc")) {
            executor = new ModifyPrincipalCommand(kadmin);
        } else if (command.startsWith("rename_principal") || command.startsWith("renprinc")) {
            executor = new RenamePrincipalCommand(kadmin);
        } else if (command.startsWith("change_password") || command.startsWith("cpw")) {
            executor = new ChangePasswordCommand(kadmin);
        } else if (command.startsWith("list_principals") || command.startsWith("listprincs") || command.startsWith("get_principals") || command.startsWith("getprincs") || command.startsWith("List principals")) {
            executor = new ListPrincipalCommand(kadmin);
        } else if (command.startsWith("get_principal") || command.startsWith("getprinc") || command.startsWith("Get principal")) {
            executor = new GetPrincipalCommand(kadmin);
        }
        if (executor == null) {
            System.out.println("Unknown request \"" + command + "\". Type \"?\" for a request list.");
            return;
        }
        ((KadminCommand)executor).execute(command);
    }

    private static File getConfDir(String[] args) {
        confDir = new File(args[0]);
        if (!confDir.exists()) {
            String envDir;
            try {
                Map<String, String> mapEnv = System.getenv();
                envDir = mapEnv.get("KRB5_KDC_DIR");
            }
            catch (SecurityException e) {
                envDir = null;
            }
            confDir = envDir != null ? new File(envDir) : new File("/etc/kerby/");
            if (!confDir.exists()) {
                throw new RuntimeException("Can not locate KDC backend directory " + confDir.getAbsolutePath());
            }
        }
        LOG.info("Conf dir:" + confDir.getAbsolutePath());
        return confDir;
    }

    public static void main(String[] args) throws KrbException, IOException {
        LocalKadminImpl kadmin;
        if (args.length < 2) {
            System.err.println(USAGE);
            return;
        }
        try {
            kadmin = new LocalKadminImpl(KadminTool.getConfDir(args));
        }
        catch (KrbException e) {
            System.err.println("Failed to init Kadmin due to " + e.getMessage());
            return;
        }
        try {
            Krb5Conf krb5Conf = new Krb5Conf(confDir, kadmin.getKdcConfig());
            krb5Conf.initKrb5conf();
        }
        catch (IOException e) {
            throw new KrbException("Failed to make krb5.conf", (Throwable)e);
        }
        KOptions kOptions = ToolUtil.parseOptions(args, 1, args.length - 1);
        if (kOptions == null) {
            System.err.println(USAGE);
            return;
        }
        String kadminPrincipal = kadmin.getKadminPrincipal();
        if (kOptions.contains((KOption)KadminOption.CCACHE)) {
            File ccFile = kOptions.getFileOption((KOption)KadminOption.CCACHE);
            if (ccFile == null || !ccFile.exists()) {
                KadminTool.printUsage("Need the valid credentials cache file.");
                return;
            }
            try {
                AuthUtil.loginUsingTicketCache(kadminPrincipal, ccFile);
            }
            catch (LoginException e) {
                System.err.println("Could not login with: " + kadminPrincipal + " " + e.getMessage());
                return;
            }
        } else if (kOptions.contains((KOption)KadminOption.K)) {
            File keyTabFile = new File(kOptions.getStringOption((KOption)KadminOption.K));
            if (!keyTabFile.exists()) {
                KadminTool.printUsage("Need the valid keytab file.");
                return;
            }
            try {
                AuthUtil.loginUsingKeytab(kadminPrincipal, keyTabFile);
            }
            catch (LoginException e) {
                System.err.println("Could not login with: " + kadminPrincipal + " " + e.getMessage());
                return;
            }
        } else {
            KadminTool.printUsage("No credentials cache file or keytab file for authentication.");
        }
        if (kOptions.contains((KOption)KadminOption.QUERY)) {
            String query = kOptions.getStringOption((KOption)KadminOption.QUERY);
            KadminTool.execute((LocalKadmin)kadmin, query);
        } else {
            StringsCompleter completer = new StringsCompleter(new String[]{"add_principal", "batch_anks", "ktadd", "ktremove", "delete_principal", "modify_principal", "rename_principal", "change_password", "list_principals", "get_principal"});
            Terminal terminal = TerminalBuilder.terminal();
            LineReader lineReader = LineReaderBuilder.builder().completer((Completer)completer).terminal(terminal).build();
            try {
                String line;
                while (!("quit".equals(line = lineReader.readLine(PROMPT + ": ")) || "exit".equals(line) || "q".equals(line))) {
                    KadminTool.execute((LocalKadmin)kadmin, line);
                }
            }
            catch (EndOfFileException | UserInterruptException ex) {
            }
        }
    }

    static {
        PROMPT = KadminTool.class.getSimpleName() + ".local";
        REQUEST_LIST = "Available " + PROMPT + " requests:\n\nadd_principal, addprinc, ank\n                         Add principal\nbatch_anks, batch\n                         Add principals\ndelete_principal, delprinc\n                         Delete principal\nmodify_principal, modprinc\n                         Modify principal\nrename_principal, renprinc\n                         Rename principal\nchange_password, cpw     Change password\nget_principal, getprinc  Get principal\nlist_principals, listprincs, get_principals, getprincs\n                         List principals\nadd_policy, addpol       Add policy, not implemented, and will be implemented in next version\nmodify_policy, modpol    Modify policy, not implemented, and will be implemented in next version\ndelete_policy, delpol    Delete policy, not implemented, and will be implemented in next version\nget_policy, getpol       Get policy, not implemented, and will be implemented in next version\nlist_policies, listpols, get_policies, getpols, not implemented, and will be implemented in next version                         List policies\nget_privs, getprivs      Get privileges, not implemented, and will be implemented in next version\nktadd, xst               Add entry(s) to a keytab\nktremove, ktrem          Remove entry(s) from a keytab\nlock                     Lock database exclusively (use with extreme caution!), not implemented, and will be implemented in next version\nunlock                   Release exclusive database lock, not implemented, and will be implemented in next version\npurgekeys                Purge previously retained old keys from a principal, not implemented, and will be implemented in next version\nget_strings, getstrs     Show string attributes on a principal, not implemented, and will be implemented in next version\nset_string, setstr       Set a string attribute on a principal, not implemented, and will be implemented in next version\ndel_string, delstr       Delete a string attribute on a principal, not implemented, and will be implemented in next version\nlist_requests, lr, ?     List available requests.\nquit, exit, q            Exit program.";
        USAGE = (OSUtil.isWindows() ? "Usage: bin\\kadmin.cmd" : "Usage: sh bin/kadmin.sh") + " <conf-dir> <-c cache_name>|<-k keytab>\n\tExample:\n\t\t" + (OSUtil.isWindows() ? "bin\\kadmin.cmd" : "sh bin/kadmin.sh") + " conf -k admin.keytab\n";
    }
}

