/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend.typeAdapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.util.HexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionKeyAdapter
implements JsonSerializer<EncryptionKey>,
JsonDeserializer<EncryptionKey> {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionKeyAdapter.class);

    public EncryptionKey deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = (JsonObject)jsonElement;
        EncryptionKey encryptionKey = new EncryptionKey();
        try {
            encryptionKey.decode(HexUtil.hex2bytes((String)jsonObject.get("key").getAsString()));
        }
        catch (IOException e) {
            LOG.error("Fail to decode encryption key. " + e);
        }
        encryptionKey.setKvno(jsonObject.get("kvno").getAsInt());
        return encryptionKey;
    }

    public JsonElement serialize(EncryptionKey encryptionKey, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("kvno", (Number)encryptionKey.getKvno());
        try {
            jsonObject.addProperty("key", HexUtil.bytesToHex((byte[])KrbCodec.encode((Asn1Type)encryptionKey)));
        }
        catch (KrbException e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }
}

