/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kerby.config.Config;
import org.apache.kerby.kerberos.kdc.identitybackend.typeAdapter.EncryptionKeyAdapter;
import org.apache.kerby.kerberos.kdc.identitybackend.typeAdapter.KerberosTimeAdapter;
import org.apache.kerby.kerberos.kdc.identitybackend.typeAdapter.PrincipalNameAdapter;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.BatchTrans;
import org.apache.kerby.kerberos.kerb.identity.backend.AbstractIdentityBackend;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonIdentityBackend
extends AbstractIdentityBackend {
    private static final Logger LOG = LoggerFactory.getLogger(JsonIdentityBackend.class);
    public static final String JSON_IDENTITY_BACKEND_DIR = "backend.json.dir";
    private File jsonKdbFile;
    private Gson gson;
    private final Map<String, KrbIdentity> identities = new ConcurrentHashMap<String, KrbIdentity>(new TreeMap());
    private long kdbFileUpdateTime = -1L;
    private Lock lock = new ReentrantLock();

    public JsonIdentityBackend() {
    }

    public JsonIdentityBackend(Config config) {
        this.setConfig(config);
    }

    public boolean supportBatchTrans() {
        return true;
    }

    public BatchTrans startBatchTrans() throws KrbException {
        if (this.lock.tryLock()) {
            this.checkAndReload();
            return new JsonBatchTrans();
        }
        return null;
    }

    protected void doInitialize() throws KrbException {
        File jsonFileDir;
        LOG.info("Initializing the Json identity backend.");
        this.initGsonBuilder();
        String dirPath = this.getConfig().getString(JSON_IDENTITY_BACKEND_DIR);
        if (dirPath == null || dirPath.isEmpty()) {
            jsonFileDir = this.getBackendConfig().getConfDir();
        } else {
            jsonFileDir = new File(dirPath);
            if (!jsonFileDir.exists() && !jsonFileDir.mkdirs()) {
                throw new KrbException("Failed to create json file dir " + jsonFileDir);
            }
        }
        this.jsonKdbFile = new File(jsonFileDir, "json-backend.json");
        if (!this.jsonKdbFile.exists()) {
            try {
                this.jsonKdbFile.createNewFile();
            }
            catch (IOException e) {
                throw new KrbException("Failed to create " + this.jsonKdbFile.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws KrbException {
        LOG.info("Loading the identities from json file.");
        long nowTimeStamp = this.jsonKdbFile.lastModified();
        if (this.lock.tryLock()) {
            try {
                String reloadedJsonContent;
                try {
                    reloadedJsonContent = IOUtil.readFile((File)this.jsonKdbFile);
                }
                catch (IOException e) {
                    throw new KrbException("Failed to read file", (Throwable)e);
                }
                Map reloadedEntries = (Map)this.gson.fromJson(reloadedJsonContent, new TypeToken<HashMap<String, KrbIdentity>>(){}.getType());
                if (reloadedEntries != null) {
                    this.identities.clear();
                    this.identities.putAll(reloadedEntries);
                }
                this.kdbFileUpdateTime = nowTimeStamp;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void checkAndReload() throws KrbException {
        long nowTimeStamp = this.jsonKdbFile.lastModified();
        if (nowTimeStamp != this.kdbFileUpdateTime) {
            this.load();
        }
    }

    protected KrbIdentity doGetIdentity(String principalName) throws KrbException {
        this.checkAndReload();
        return this.identities.get(principalName);
    }

    protected KrbIdentity doAddIdentity(KrbIdentity identity) throws KrbException {
        this.checkAndReload();
        if (this.lock.tryLock()) {
            try {
                this.identities.put(identity.getPrincipalName(), identity);
                this.persistToFile();
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.doGetIdentity(identity.getPrincipalName());
    }

    protected KrbIdentity doUpdateIdentity(KrbIdentity identity) throws KrbException {
        this.checkAndReload();
        if (this.lock.tryLock()) {
            try {
                this.identities.put(identity.getPrincipalName(), identity);
                this.persistToFile();
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.doGetIdentity(identity.getPrincipalName());
    }

    protected void doDeleteIdentity(String principalName) throws KrbException {
        this.checkAndReload();
        if (!this.identities.containsKey(principalName)) {
            return;
        }
        if (this.lock.tryLock()) {
            try {
                this.identities.remove(principalName);
                this.persistToFile();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected Iterable<String> doGetIdentities() throws KrbException {
        this.load();
        ArrayList<String> principals = new ArrayList<String>(this.identities.keySet());
        Collections.sort(principals);
        return principals;
    }

    private void initGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(EncryptionKey.class, (Object)new EncryptionKeyAdapter());
        gsonBuilder.registerTypeAdapter(PrincipalName.class, (Object)new PrincipalNameAdapter());
        gsonBuilder.registerTypeAdapter(KerberosTime.class, (Object)new KerberosTimeAdapter());
        gsonBuilder.enableComplexMapKeySerialization();
        gsonBuilder.setPrettyPrinting();
        this.gson = gsonBuilder.create();
    }

    private void persistToFile() throws KrbException {
        String newJsonContent = this.gson.toJson(this.identities);
        try {
            File newJsonKdbFile = Files.createTempFile(this.jsonKdbFile.getParentFile().toPath(), "kerby-kdb", ".json", new FileAttribute[0]).toFile();
            IOUtil.writeFile((String)newJsonContent, (File)newJsonKdbFile);
            boolean delete = this.jsonKdbFile.delete();
            if (!delete) {
                throw new RuntimeException("File delete error!");
            }
            boolean rename = newJsonKdbFile.renameTo(this.jsonKdbFile);
            if (!rename) {
                throw new RuntimeException("File rename error!");
            }
            this.kdbFileUpdateTime = this.jsonKdbFile.lastModified();
        }
        catch (IOException e) {
            LOG.error("Error occurred while writing identities to file: " + this.jsonKdbFile);
            throw new KrbException("Failed to write file", (Throwable)e);
        }
    }

    class JsonBatchTrans
    implements BatchTrans {
        JsonBatchTrans() {
        }

        public void commit() throws KrbException {
            try {
                JsonIdentityBackend.this.persistToFile();
            }
            finally {
                JsonIdentityBackend.this.lock.unlock();
            }
        }

        public void rollback() throws KrbException {
            try {
                JsonIdentityBackend.this.load();
            }
            finally {
                JsonIdentityBackend.this.lock.unlock();
            }
        }

        public BatchTrans addIdentity(KrbIdentity identity) throws KrbException {
            if (identity != null && JsonIdentityBackend.this.identities.containsKey(identity.getPrincipalName())) {
                JsonIdentityBackend.this.identities.put(identity.getPrincipalName(), identity);
            }
            return this;
        }

        public BatchTrans updateIdentity(KrbIdentity identity) throws KrbException {
            if (identity != null && JsonIdentityBackend.this.identities.containsKey(identity.getPrincipalName())) {
                JsonIdentityBackend.this.identities.put(identity.getPrincipalName(), identity);
            }
            return this;
        }

        public BatchTrans deleteIdentity(String principalName) throws KrbException {
            if (principalName != null && JsonIdentityBackend.this.identities.containsKey(principalName)) {
                JsonIdentityBackend.this.identities.remove(principalName);
            }
            return this;
        }
    }
}

