/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kinit;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptionGroup;
import org.apache.kerby.KOptionInfo;
import org.apache.kerby.KOptionType;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbKdcOption;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.KrbOptionGroup;
import org.apache.kerby.kerberos.kerb.client.PkinitOption;
import org.apache.kerby.kerberos.kerb.client.TokenOption;
import org.apache.kerby.kerberos.tool.kinit.KinitOption;
import org.apache.kerby.util.OSUtil;

public class KinitToolWithConcurrence {
    private static int[] reList = new int[100000];
    private static String[] prList = new String[10000];
    private static KOptions ktOptions = new KOptions();
    private static int thFlag = 0;
    private static Long startTime = 0L;
    private static Lock lock = new ReentrantLock();
    private static int tmpTotals = 0;
    private static final int INTERVAL = 16;
    private static final String USAGE = (OSUtil.isWindows() ? "Usage: bin\\kinit.cmd" : "Usage: sh bin/kinit.sh") + " <-conf conf_dir> [-V] [-l lifetime] [-s start_time]\n\t\t[-r renewable_life] [-f | -F] [-p | -P] -n [-a | -A] [-C] [-E]\n\t\t[-v] [-R] [-k [-i|-t keytab_file]] [-c cachename]\n\t\t[-S service_name] [-T ticket_armor_cache]\n\t\t[-X <attribute>[=<value>]] <principal>\n\n\tDESCRIPTION:\n\t\tkinit obtains and caches an initial ticket-granting ticket for principal.\n\n\tOPTIONS:\n\t\t-V verbose\n\t\t-l lifetime\n\t\t--s start time\n\t\t-r renewable lifetime\n\t\t-f forwardable\n\t\t-F not forwardable\n\t\t-p proxiable\n\t\t-P not proxiable\n\t\t-n anonymous\n\t\t-a include addresses\n\t\t-A do not include addresses\n\t\t-v validate\n\t\t-R renew\n\t\t-C canonicalize\n\t\t-E client is enterprise principal name\n\t\t-k use keytab\n\t\t-i use default client keytab (with -k)\n\t\t-t filename of keytab to use\n\t\t-c Kerberos 5 cache name\n\t\t-S service\n\t\t-T armor credential cache\n\t\t-X <attribute>[=<value>]\n\n";

    private static void printUsage(String error) {
        System.err.println(error + "\n");
        System.err.println(USAGE);
        System.exit(-1);
    }

    private static void requestTicket(String principal, KOptions ktOptions, int flag) {
        ktOptions.add((KOption)KinitOption.CLIENT_PRINCIPAL, (Object)principal);
        File confDir = null;
        if (ktOptions.contains((KOption)KinitOption.CONF_DIR)) {
            confDir = ktOptions.getDirOption((KOption)KinitOption.CONF_DIR);
        }
        if (ktOptions.contains((KOption)KinitOption.ANONYMOUS)) {
            ktOptions.add((KOption)PkinitOption.USE_ANONYMOUS);
            ktOptions.add((KOption)PkinitOption.X509_ANCHORS);
        } else if (!ktOptions.contains((KOption)KinitOption.USE_KEYTAB)) {
            ktOptions.add((KOption)KinitOption.USE_PASSWD);
            String password = "12";
            ktOptions.add((KOption)KinitOption.USER_PASSWD, (Object)password);
        }
        KrbClient krbClient = null;
        try {
            krbClient = KinitToolWithConcurrence.getClient(confDir);
        }
        catch (KrbException e) {
            System.err.println("Create krbClient failed: " + e.getMessage());
            System.exit(1);
        }
        KOptions results = KinitToolWithConcurrence.convertOptions(ktOptions);
        try {
            flag *= 16;
            while (true) {
                krbClient.requestTgt(results);
                int n = flag;
                reList[n] = reList[n] + 1;
            }
        }
        catch (KrbException e) {
            System.err.println("Authentication failed: " + e.getMessage());
            System.exit(1);
            return;
        }
    }

    private static KrbClient getClient(File confDir) throws KrbException {
        KrbClient krbClient = confDir != null ? new KrbClient(confDir) : new KrbClient();
        krbClient.init();
        return krbClient;
    }

    public static void main(String[] args) throws Exception {
        int j;
        String principalNumbers = null;
        String startIndex = null;
        int i = 0;
        while (i < args.length) {
            KinitOption kto;
            String opt;
            String error = null;
            if ((opt = args[i++]).startsWith("-")) {
                kto = KinitOption.fromName(opt);
                if (kto == KinitOption.NONE) {
                    error = "Invalid option:" + opt;
                    System.err.println(error);
                    break;
                }
            } else {
                principalNumbers = opt;
                kto = KinitOption.NONE;
                startIndex = args[i++];
            }
            if (kto != KinitOption.NONE && kto.getOptionInfo().getType() != KOptionType.NOV) {
                String param = null;
                if (i < args.length) {
                    param = args[i++];
                }
                if (param != null) {
                    KOptions.parseSetValue((KOptionInfo)kto.getOptionInfo(), (String)param);
                } else {
                    error = "Option " + opt + " require a parameter";
                }
            }
            if (error != null) {
                KinitToolWithConcurrence.printUsage(error);
            }
            if (kto == KinitOption.NONE) continue;
            ktOptions.add((KOption)kto);
        }
        int threadNumbers = Integer.parseInt(principalNumbers);
        int stIndex = Integer.parseInt(startIndex);
        if (threadNumbers <= 0) {
            KinitToolWithConcurrence.printUsage("principal must be greater than zero");
            System.exit(-1);
        }
        for (j = 0; j < threadNumbers; ++j) {
            String tempName;
            int tmpIndex = j + stIndex;
            KinitToolWithConcurrence.prList[j] = tempName = "E" + tmpIndex + "@EXAMPLE.COM";
        }
        for (j = 0; j < threadNumbers; ++j) {
            Thread th = new Thread(new PreThread());
            th.start();
        }
        int[] tempDelayNumbers = new int[threadNumbers];
        int[] delayNumbers = new int[threadNumbers];
        startTime = System.currentTimeMillis();
        long timeStamp = System.currentTimeMillis();
        int max = 0;
        int min = 0;
        System.out.println("Time stamp (sec),Throughput (sec),avgDelay (ms),maxDelay (ms),minDelay (ms)");
        while (true) {
            int j2;
            Thread.sleep(2000L);
            int temp = 0;
            long now = System.currentTimeMillis();
            for (j2 = 0; j2 < threadNumbers; ++j2) {
                delayNumbers[j2] = reList[j2 * 16] - tempDelayNumbers[j2];
                tempDelayNumbers[j2] = reList[j2 * 16];
            }
            for (j2 = 0; j2 < threadNumbers; ++j2) {
                temp += reList[j2 * 16];
            }
            float res = (float)(now - startTime) / 1000.0f;
            double totalDelay = 0.0;
            int cutThreads = 0;
            for (int j3 = 0; j3 < threadNumbers; ++j3) {
                if (delayNumbers[j3] != 0) {
                    if (delayNumbers[max] < delayNumbers[j3]) {
                        max = j3;
                    }
                    if (delayNumbers[min] == 0 || delayNumbers[min] > delayNumbers[j3]) {
                        min = j3;
                    }
                    totalDelay += (double)(now - startTime) * 1.0 / (double)delayNumbers[j3];
                    continue;
                }
                ++cutThreads;
            }
            if (delayNumbers[min] != 0 && delayNumbers[max] != 0) {
                System.out.println((now - timeStamp) / 1000L + "," + (float)(temp - tmpTotals) / res + "," + (int)(totalDelay / (double)(threadNumbers - cutThreads)) + "," + (now - startTime) / (long)delayNumbers[min] + "," + (now - startTime) / (long)delayNumbers[max]);
            }
            tmpTotals = temp;
            startTime = now;
        }
    }

    public static void request() {
        int tempFlag = 0;
        lock.lock();
        tempFlag = thFlag++;
        lock.unlock();
        KinitToolWithConcurrence.requestTicket(prList[tempFlag], ktOptions, tempFlag);
    }

    static KOptions convertOptions(KOptions toolOptions) {
        KOptions results = new KOptions();
        for (KOption toolOpt : toolOptions.getOptions()) {
            KOptionInfo kOptionInfo = toolOpt.getOptionInfo();
            KOptionGroup group = kOptionInfo.getGroup();
            KrbOption kOpt = null;
            if (group == KrbOptionGroup.KRB) {
                kOpt = KrbOption.fromOptionName((String)kOptionInfo.getName());
            } else if (group == KrbOptionGroup.PKINIT) {
                kOpt = PkinitOption.fromOptionName((String)kOptionInfo.getName());
            } else if (group == KrbOptionGroup.TOKEN) {
                kOpt = TokenOption.fromOptionName((String)kOptionInfo.getName());
            } else if (group == KrbOptionGroup.KDC_FLAGS) {
                kOpt = KrbKdcOption.fromOptionName((String)kOptionInfo.getName());
            }
            if (kOpt == null || kOpt.getOptionInfo() == KrbOption.NONE.getOptionInfo()) continue;
            kOpt.getOptionInfo().setValue(toolOpt.getOptionInfo().getValue());
            results.add((KOption)kOpt);
        }
        return results;
    }

    public static class PreThread
    implements Runnable {
        @Override
        public void run() {
            KinitToolWithConcurrence.request();
        }
    }
}

