/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kinit;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptionGroup;
import org.apache.kerby.KOptionInfo;
import org.apache.kerby.KOptionType;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbKdcOption;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.KrbOptionGroup;
import org.apache.kerby.kerberos.kerb.client.PkinitOption;
import org.apache.kerby.kerberos.kerb.client.TokenOption;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.apache.kerby.kerberos.tool.kinit.KinitOption;
import org.apache.kerby.util.OSUtil;
import org.apache.kerby.util.SysUtil;

public class KinitTool {
    private static final String USAGE = (OSUtil.isWindows() ? "Usage: bin\\kinit.cmd" : "Usage: sh bin/kinit.sh") + " <-conf conf_dir> [-V] [-l lifetime] [-s start_time]\n\t\t[-r renewable_life] [-f | -F] [-p | -P] -n [-a | -A] [-C] [-E]\n\t\t[-v] [-R] [-k [-i|-t keytab_file]] [-c cachename]\n\t\t[-S service_name] [-T ticket_armor_cache]\n\t\t[-X <attribute>[=<value>]] <principal>\n\n\tDESCRIPTION:\n\t\tkinit obtains and caches an initial ticket-granting ticket for principal.\n\n\tOPTIONS:\n\t\t-V verbose\n\t\t-l lifetime\n\t\t-s start time\n\t\t-r renewable lifetime\n\t\t-f forwardable\n\t\t-F not forwardable\n\t\t-p proxiable\n\t\t-P not proxiable\n\t\t-n anonymous\n\t\t-a include addresses\n\t\t-A do not include addresses\n\t\t-v validate\n\t\t-R renew\n\t\t-C canonicalize\n\t\t-E client is enterprise principal name\n\t\t-k use keytab\n\t\t-i use default client keytab (with -k)\n\t\t-t filename of keytab to use\n\t\t-c Kerberos 5 cache name\n\t\t-S service\n\t\t-T armor credential cache\n\t\t-X <attribute>[=<value>]\n\n";
    private static final String KVNO_USAGE = (OSUtil.isWindows() ? "Usage: bin\\kinit.cmd" : "Usage: sh bin/kinit.sh") + " <-conf conf_dir> <-c cachename> <-S service_name>\n\n\tDESCRIPTION:\n\t\tkinit obtains a service ticket for the specified principal and prints out the key version number.\n\n";

    private static void printUsage(String error) {
        System.err.println(error + "\n");
        System.err.println(USAGE);
        System.exit(-1);
    }

    private static void printKvnoUsage(String error) {
        System.err.println(error + "\n");
        System.err.println(KVNO_USAGE);
        System.exit(-1);
    }

    private static String getPassword(String principal) {
        Console console = System.console();
        if (console == null) {
            System.out.println("Couldn't get Console instance, maybe you're running this from within an IDE. Use scanner to read password.");
            System.out.println("Password for " + principal + ":");
            try (Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8.name());){
                String string = scanner.nextLine().trim();
                return string;
            }
        }
        console.printf("Password for " + principal + ":", new Object[0]);
        char[] passwordChars = console.readPassword();
        String password = new String(passwordChars).trim();
        Arrays.fill(passwordChars, ' ');
        return password;
    }

    private static void requestTicket(String principal, KOptions ktOptions) {
        File ccacheFile;
        String ccacheName;
        String ccName;
        File ccFile;
        ktOptions.add((KOption)KinitOption.CLIENT_PRINCIPAL, (Object)principal);
        File confDir = null;
        if (ktOptions.contains((KOption)KinitOption.CONF_DIR)) {
            confDir = ktOptions.getDirOption((KOption)KinitOption.CONF_DIR);
        }
        KrbClient krbClient = null;
        try {
            krbClient = KinitTool.getClient(confDir);
        }
        catch (KrbException e) {
            System.err.println("Create krbClient failed: " + e.getMessage());
            System.exit(1);
        }
        if (ktOptions.contains((KOption)KinitOption.RENEW)) {
            if (ktOptions.contains((KOption)KinitOption.KRB5_CACHE)) {
                String ccName2 = ktOptions.getStringOption((KOption)KinitOption.KRB5_CACHE);
                File ccFile2 = new File(ccName2);
                SgtTicket sgtTicket = null;
                try {
                    sgtTicket = krbClient.requestSgt(ccFile2, null);
                }
                catch (KrbException e) {
                    System.err.println("kinit: " + e.getKrbErrorCode().getMessage());
                }
                try {
                    krbClient.renewTicket(sgtTicket, ccFile2);
                }
                catch (KrbException e) {
                    System.err.println("kinit: " + e.getKrbErrorCode().getMessage());
                }
                System.out.println("Successfully renewed.");
            }
            return;
        }
        if (ktOptions.contains((KOption)KinitOption.SERVICE) && ktOptions.contains((KOption)KinitOption.KRB5_CACHE) && (ccFile = new File(ccName = ktOptions.getStringOption((KOption)KinitOption.KRB5_CACHE))).exists()) {
            System.out.println("Use credential cache to request a service ticket.");
            String servicePrincipal = ktOptions.getStringOption((KOption)KinitOption.SERVICE);
            SgtTicket sgtTicket = null;
            try {
                sgtTicket = krbClient.requestSgt(ccFile, servicePrincipal);
            }
            catch (KrbException e) {
                System.err.println("Kinit: get service ticket failed: " + e.getMessage());
                System.exit(1);
            }
            try {
                krbClient.storeTicket(sgtTicket, ccFile);
            }
            catch (KrbException e) {
                System.err.println("Kinit: store ticket failed: " + e.getMessage());
                System.exit(1);
            }
            System.out.println(sgtTicket.getEncKdcRepPart().getSname().getName() + ": knvo = " + sgtTicket.getTicket().getEncryptedEncPart().getKvno());
            return;
        }
        if (ktOptions.contains((KOption)KinitOption.ANONYMOUS)) {
            ktOptions.add((KOption)PkinitOption.USE_ANONYMOUS);
            ktOptions.add((KOption)PkinitOption.X509_ANCHORS);
        } else if (!ktOptions.contains((KOption)KinitOption.USE_KEYTAB)) {
            ktOptions.add((KOption)KinitOption.USE_PASSWD);
            String password = KinitTool.getPassword(principal);
            ktOptions.add((KOption)KinitOption.USER_PASSWD, (Object)password);
        }
        TgtTicket tgt = null;
        try {
            tgt = krbClient.requestTgt(KinitTool.convertOptions(ktOptions));
        }
        catch (KrbException e) {
            System.err.println("Authentication failed: " + e.getMessage());
            System.exit(1);
        }
        if (ktOptions.contains((KOption)KinitOption.KRB5_CACHE)) {
            ccacheName = ktOptions.getStringOption((KOption)KinitOption.KRB5_CACHE);
            ccacheFile = new File(ccacheName);
        } else {
            ccacheName = KinitTool.getCcacheName(krbClient);
            ccacheFile = new File(ccacheName);
        }
        try {
            krbClient.storeTicket(tgt, ccacheFile);
        }
        catch (KrbException e) {
            System.err.println("Store ticket failed: " + e.getMessage());
            System.exit(1);
        }
        System.out.println("Successfully requested and stored ticket in " + ccacheFile.getAbsolutePath());
        if (ktOptions.contains((KOption)KinitOption.SERVICE)) {
            SgtTicket sgtTicket;
            System.out.println("Use tgt to request a service ticket.");
            String servicePrincipal = ktOptions.getStringOption((KOption)KinitOption.SERVICE);
            try {
                sgtTicket = krbClient.requestSgt(tgt, servicePrincipal);
            }
            catch (KrbException e) {
                System.err.println("kinit: " + e.getKrbErrorCode().getMessage());
                return;
            }
            System.out.println(sgtTicket.getEncKdcRepPart().getSname().getName() + ": knvo = " + sgtTicket.getTicket().getEncryptedEncPart().getKvno());
        }
    }

    private static KrbClient getClient(File confDir) throws KrbException {
        KrbClient krbClient = confDir != null ? new KrbClient(confDir) : new KrbClient();
        krbClient.init();
        return krbClient;
    }

    private static String getCcacheName(KrbClient krbClient) {
        String ccacheName;
        String ccacheNameEnv = System.getenv("KRB5CCNAME");
        String ccacheNameConf = krbClient.getSetting().getKrbConfig().getString("default_ccache_name");
        if (ccacheNameEnv != null) {
            ccacheName = ccacheNameEnv;
        } else if (ccacheNameConf != null) {
            ccacheName = ccacheNameConf;
        } else {
            StringBuilder uid = new StringBuilder();
            try {
                int c;
                String command = "id -u";
                Process child = Runtime.getRuntime().exec(command);
                InputStream in = child.getInputStream();
                while ((c = in.read()) != -1) {
                    uid.append((char)c);
                }
                in.close();
            }
            catch (IOException e) {
                System.err.println("Failed to get UID.");
                System.exit(1);
            }
            ccacheName = "krb5cc_" + uid.toString().trim();
            ccacheName = SysUtil.getTempDir().toString() + "/" + ccacheName;
        }
        return ccacheName;
    }

    public static void main(String[] args) {
        KOptions ktOptions = new KOptions();
        String principal = null;
        int i = 0;
        while (i < args.length) {
            KinitOption kto;
            String opt;
            String error = null;
            if ((opt = args[i++]).startsWith("-")) {
                kto = KinitOption.fromName(opt);
                if (kto == KinitOption.NONE) {
                    error = "Invalid option:" + opt;
                    System.err.println(error);
                    break;
                }
            } else {
                principal = opt;
                kto = KinitOption.NONE;
            }
            if (kto != KinitOption.NONE && kto.getOptionInfo().getType() != KOptionType.NOV) {
                String param = null;
                if (i < args.length) {
                    param = args[i++];
                }
                if (param != null) {
                    KOptions.parseSetValue((KOptionInfo)kto.getOptionInfo(), (String)param);
                } else {
                    error = "Option " + opt + " require a parameter";
                }
            }
            if (error != null) {
                KinitTool.printUsage(error);
            }
            if (kto == KinitOption.NONE) continue;
            ktOptions.add((KOption)kto);
        }
        if (!ktOptions.contains((KOption)KinitOption.CONF_DIR)) {
            KinitTool.printUsage("No conf dir given.");
        }
        if (principal == null) {
            if (ktOptions.contains((KOption)KinitOption.ANONYMOUS)) {
                principal = "WELLKNOWN/ANONYMOUS";
            } else if (!ktOptions.contains((KOption)KinitOption.SERVICE) && !ktOptions.contains((KOption)KinitOption.KRB5_CACHE)) {
                KinitTool.printUsage("No principal is specified");
            } else if (ktOptions.contains((KOption)KinitOption.SERVICE) && !ktOptions.contains((KOption)KinitOption.KRB5_CACHE)) {
                KinitTool.printKvnoUsage("No credential cache file given.");
            }
        }
        KinitTool.requestTicket(principal, ktOptions);
        System.exit(0);
    }

    static KOptions convertOptions(KOptions toolOptions) {
        KOptions results = new KOptions();
        for (KOption toolOpt : toolOptions.getOptions()) {
            KOptionInfo kOptionInfo = toolOpt.getOptionInfo();
            KOptionGroup group = kOptionInfo.getGroup();
            KrbOption kOpt = null;
            if (group == KrbOptionGroup.KRB) {
                kOpt = KrbOption.fromOptionName((String)kOptionInfo.getName());
            } else if (group == KrbOptionGroup.PKINIT) {
                kOpt = PkinitOption.fromOptionName((String)kOptionInfo.getName());
            } else if (group == KrbOptionGroup.TOKEN) {
                kOpt = TokenOption.fromOptionName((String)kOptionInfo.getName());
            } else if (group == KrbOptionGroup.KDC_FLAGS) {
                kOpt = KrbKdcOption.fromOptionName((String)kOptionInfo.getName());
            }
            if (kOpt == null || kOpt.getOptionInfo() == KrbOption.NONE.getOptionInfo()) continue;
            kOpt.getOptionInfo().setValue(toolOpt.getOptionInfo().getValue());
            results.add((KOption)kOpt);
        }
        return results;
    }
}

