/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;

public class MavenUtil {
    static final DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
    private static final Pattern aetherPattern = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    private static final Pattern mvnPattern = Pattern.compile("(?:(?:wrap:)|(?:blueprint:))?mvn:([^/ ]+)/([^/ ]+)/([^/$ ]*)(/([^/$ ]+)(/([^/$ ]+))?)?(/\\$.+)?");

    public static String mvnToAether(String name) {
        Matcher m = mvnPattern.matcher(name);
        if (!m.matches()) {
            return name;
        }
        StringBuilder b = new StringBuilder();
        b.append(m.group(1)).append(":");
        b.append(m.group(2)).append(":");
        String extension = m.group(5);
        String classifier = m.group(7);
        if (MavenUtil.present(classifier)) {
            if (MavenUtil.present(extension)) {
                b.append(extension).append(":");
            } else {
                b.append("jar:");
            }
            b.append(classifier).append(":");
        } else if (MavenUtil.present(extension) && !"jar".equals(extension)) {
            b.append(extension).append(":");
        }
        b.append(m.group(3));
        return b.toString();
    }

    public static DefaultArtifact mvnToArtifact(String name) {
        String classifier;
        Matcher m = mvnPattern.matcher(name);
        if (!m.matches()) {
            return new DefaultArtifact(name);
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String version = m.group(3);
        String extension = m.group(5);
        if (!MavenUtil.present(extension)) {
            extension = "jar";
        }
        return new DefaultArtifact(groupId, artifactId, MavenUtil.present(classifier = m.group(7)) ? classifier : "", extension, version);
    }

    public static DefaultArtifact aetherToArtifact(String name) {
        String classifier;
        Matcher m = aetherPattern.matcher(name);
        if (!m.matches()) {
            return new DefaultArtifact(name);
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String version = m.group(7);
        String extension = m.group(4);
        if (!MavenUtil.present(extension)) {
            extension = "jar";
        }
        return new DefaultArtifact(groupId, artifactId, MavenUtil.present(classifier = m.group(6)) ? classifier : "", extension, version);
    }

    private static boolean present(String part) {
        return part != null && !part.isEmpty();
    }

    public static String aetherToMvn(String name) {
        Matcher m = aetherPattern.matcher(name);
        if (!m.matches()) {
            return name;
        }
        StringBuilder b = new StringBuilder("mvn:");
        b.append(m.group(1)).append("/");
        b.append(m.group(2)).append("/");
        b.append(m.group(7));
        String extension = m.group(4);
        String classifier = m.group(6);
        if (MavenUtil.present(classifier)) {
            if (MavenUtil.present(extension)) {
                b.append("/").append(extension);
            } else {
                b.append("/jar");
            }
            b.append("/").append(classifier);
        } else if (MavenUtil.present(extension)) {
            b.append("/").append(extension);
        }
        return b.toString();
    }

    public static boolean isEmpty(String classifier) {
        return classifier == null || classifier.length() == 0;
    }

    public static void generateMavenMetadata(Artifact artifact, File target) throws IOException {
        target.getParentFile().mkdirs();
        Metadata metadata = new Metadata();
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setVersion(artifact.getVersion());
        metadata.setModelVersion("1.1.0");
        Versioning versioning = new Versioning();
        versioning.setLastUpdatedTimestamp(new Date(System.currentTimeMillis()));
        Snapshot snapshot = new Snapshot();
        snapshot.setLocalCopy(true);
        versioning.setSnapshot(snapshot);
        SnapshotVersion snapshotVersion = new SnapshotVersion();
        snapshotVersion.setClassifier(artifact.getClassifier());
        snapshotVersion.setVersion(artifact.getVersion());
        snapshotVersion.setExtension(artifact.getType());
        snapshotVersion.setUpdated(versioning.getLastUpdated());
        versioning.addSnapshotVersion(snapshotVersion);
        metadata.setVersioning(versioning);
        MetadataXpp3Writer metadataWriter = new MetadataXpp3Writer();
        FileWriter writer = new FileWriter(target);
        metadataWriter.write((Writer)writer, metadata);
    }

    public static String getFileName(Artifact artifact, boolean timestampedSnapshot) {
        if (timestampedSnapshot) {
            return artifact.getArtifactId() + "-" + artifact.getVersion() + (String)(artifact.getClassifier() != null ? "-" + artifact.getClassifier() : "") + "." + artifact.getType();
        }
        return artifact.getArtifactId() + "-" + artifact.getBaseVersion() + (String)(artifact.getClassifier() != null ? "-" + artifact.getClassifier() : "") + "." + artifact.getType();
    }

    public static String getDir(Artifact artifact) {
        return artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId() + "/" + artifact.getBaseVersion() + "/";
    }

    public static String remoteRepositoryList(List<RemoteRepository> remoteRepositories) {
        StringBuilder remotes = new StringBuilder();
        for (RemoteRepository rr : remoteRepositories) {
            if (remotes.length() > 0) {
                remotes.append(",");
            }
            remotes.append(rr.getUrl());
            remotes.append("@id=").append(rr.getId());
            if (!rr.getPolicy(false).isEnabled()) {
                remotes.append("@noreleases");
            }
            if (!rr.getPolicy(true).isEnabled()) continue;
            remotes.append("@snapshots");
        }
        return remotes.toString();
    }
}

