/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class IoUtils {
    private static final long FILE_COPY_BUFFER_SIZE = 30720L;

    public static void deleteRecursive(File file) {
        if (file != null) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                for (File child : children) {
                    IoUtils.deleteRecursive(child);
                }
            }
            file.delete();
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        File[] srcFiles;
        if (srcDir == null || !srcDir.exists()) {
            return;
        }
        if (destDir == null || !destDir.exists()) {
            destDir.mkdirs();
        }
        if ((srcFiles = srcDir.listFiles()) == null) {
            throw new IOException("Failed to list contents of " + String.valueOf(srcDir));
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + String.valueOf(destDir) + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + String.valueOf(destDir) + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + String.valueOf(destDir) + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (srcFile.isDirectory()) {
                IoUtils.copyDirectory(srcFile, dstFile);
                continue;
            }
            IoUtils.copyFile(srcFile, dstFile);
        }
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + String.valueOf(destFile) + "' exists but is a directory");
        }
        try (FileInputStream fis = new FileInputStream(srcFile);
             FileOutputStream fos = new FileOutputStream(destFile);
             FileChannel input = fis.getChannel();
             FileChannel output = fos.getChannel();){
            long bytesCopied;
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += bytesCopied) {
                long remain = size - pos;
                count = remain > 30720L ? 30720L : remain;
                bytesCopied = output.transferFrom(input, pos, count);
                if (bytesCopied != 0L) continue;
                break;
            }
        }
        long srcLen = srcFile.length();
        long dstLen = destFile.length();
        if (srcLen != dstLen) {
            throw new IOException("Failed to copy full contents from '" + String.valueOf(srcFile) + "' to '" + String.valueOf(destFile) + "' Expected length: " + srcLen + " Actual: " + dstLen);
        }
    }
}

