/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolverImpl;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.internal.download.DownloadCallback;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.features.internal.resolver.ResourceBuilder;
import org.apache.karaf.features.internal.resolver.ResourceImpl;
import org.apache.karaf.features.internal.service.Deployer;
import org.apache.karaf.features.internal.service.State;
import org.apache.karaf.features.internal.util.MapUtils;
import org.apache.karaf.features.internal.util.MultiException;
import org.apache.karaf.profile.assembly.CustomDownloadManager;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.karaf.util.config.PropertiesLoader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.MavenResolvers;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.Resolver;

@Mojo(name="verify", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class VerifyMojo
extends MojoSupport {
    @Parameter(property="descriptors")
    protected Set<String> descriptors;
    @Parameter(property="features")
    protected Set<String> features;
    @Parameter(property="framework")
    protected Set<String> framework;
    @Parameter(property="configuration")
    protected String configuration;
    @Parameter(property="distribution", defaultValue="org.apache.karaf:apache-karaf")
    protected String distribution;
    @Parameter(property="javase")
    protected String javase;
    @Parameter(property="dist-dir")
    protected String distDir;
    @Parameter(property="karaf-version")
    protected String karafVersion;
    @Parameter(property="additional-metadata")
    protected File additionalMetadata;
    @Parameter(property="ignore-missing-conditions")
    protected boolean ignoreMissingConditions;
    @Parameter(property="fail")
    protected String fail = "end";
    @Parameter(property="verify-transitive")
    protected boolean verifyTransitive = false;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="skip", defaultValue="${features.verify.skip}")
    protected boolean skip;
    protected MavenResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (this.karafVersion == null) {
            Properties versions = new Properties();
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("versions.properties");
                Object object = null;
                try {
                    versions.load(is);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.karafVersion = versions.getProperty("karaf-version");
        }
        Hashtable<String, String> config = new Hashtable<String, String>();
        StringBuilder remote = new StringBuilder();
        for (Object obj : this.project.getRemoteProjectRepositories()) {
            if (remote.length() > 0) {
                remote.append(",");
            }
            remote.append(this.invoke(obj, "getUrl"));
            remote.append("@id=").append(this.invoke(obj, "getId"));
            if (!((Boolean)this.invoke(this.getPolicy(obj, false), "isEnabled")).booleanValue()) {
                remote.append("@noreleases");
            }
            if (!((Boolean)this.invoke(this.getPolicy(obj, true), "isEnabled")).booleanValue()) continue;
            remote.append("@snapshots");
        }
        this.getLog().info((CharSequence)("Using repositories: " + remote.toString()));
        config.put("maven.repositories", remote.toString());
        config.put("maven.localRepository", this.localRepo.getBasedir());
        config.put("maven.settings", this.mavenSession.getRequest().getUserSettingsFile().toString());
        this.resolver = MavenResolvers.createMavenResolver(config, (String)"maven");
        this.doExecute();
    }

    private String getVersion(String id, String def) {
        String v = this.getVersion(id);
        return v != null ? v : def;
    }

    private String getVersion(String id) {
        Artifact artifact = (Artifact)this.project.getArtifactMap().get(id);
        if (artifact != null) {
            return artifact.getBaseVersion();
        }
        if (id.startsWith("org.apache.karaf")) {
            return this.karafVersion;
        }
        return null;
    }

    private Object invoke(Object object, String getter) throws MojoExecutionException {
        try {
            return object.getClass().getMethod(getter, new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build remote repository from " + object.toString(), e);
        }
    }

    private Object getPolicy(Object object, boolean snapshots) throws MojoExecutionException {
        return this.invoke(object, "getPolicy", new Class[]{Boolean.TYPE}, new Object[]{snapshots});
    }

    private Object invoke(Object object, String getter, Class[] types, Object[] params) throws MojoExecutionException {
        try {
            return object.getClass().getMethod(getter, types).invoke(object, params);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build remote repository from " + object.toString(), e);
        }
    }

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Map<String, Features> repositories;
        System.setProperty("karaf.home", "target/karaf");
        System.setProperty("karaf.data", "target/karaf/data");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (this.additionalMetadata != null) {
            try (FileReader reader = new FileReader(this.additionalMetadata);){
                Properties metadata = new Properties();
                metadata.load(reader);
                Enumeration<?> e = metadata.propertyNames();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Iterator<String> val = metadata.get(key);
                    properties.put(key.toString(), val.toString());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load additional metadata from " + this.additionalMetadata, (Exception)e);
            }
        }
        LinkedHashSet<String> allDescriptors = new LinkedHashSet<String>();
        if (this.descriptors == null) {
            if (this.framework == null) {
                this.framework = Collections.singleton("framework");
            }
            this.descriptors = new LinkedHashSet<String>();
            if (this.framework.contains("framework")) {
                allDescriptors.add("mvn:org.apache.karaf.features/framework/" + this.getVersion("org.apache.karaf.features:framework") + "/xml/features");
            }
            allDescriptors.add("file:" + this.project.getBuild().getDirectory() + "/feature/feature.xml");
        } else {
            allDescriptors.addAll(this.descriptors);
            if (this.framework != null && this.framework.contains("framework")) {
                allDescriptors.add("mvn:org.apache.karaf.features/framework/" + this.getVersion("org.apache.karaf.features:framework") + "/xml/features");
            }
        }
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(8);
        CustomDownloadManager manager = new CustomDownloadManager(this.resolver, executor);
        HashMap<String, List> allFeatures = new HashMap<String, List>();
        try {
            repositories = VerifyMojo.loadRepositories((DownloadManager)manager, allDescriptors);
            for (String string : repositories.keySet()) {
                List list = repositories.get(string).getFeature();
                for (org.apache.karaf.features.internal.model.Feature feature : list) {
                    for (org.apache.karaf.features.internal.model.Bundle bi : feature.getBundle()) {
                        String loc = bi.getLocation();
                        String nloc = null;
                        if (loc.contains("file:")) {
                            for (ConfigFile cfi : feature.getConfigfile()) {
                                if (!cfi.getFinalname().substring(1).equals(loc.substring(loc.indexOf("file:") + "file:".length()))) continue;
                                nloc = cfi.getLocation();
                            }
                        }
                        if (nloc == null) continue;
                        Field field = bi.getClass().getDeclaredField("location");
                        field.setAccessible(true);
                        field.set(bi, loc.substring(0, loc.indexOf("file:")) + nloc);
                    }
                }
                allFeatures.put(string, list);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load features descriptors", e);
        }
        ArrayList featuresToTest = new ArrayList();
        if (this.verifyTransitive) {
            for (List list : allFeatures.values()) {
                featuresToTest.addAll(list);
            }
        } else {
            for (String string : this.descriptors) {
                featuresToTest.addAll((Collection)allFeatures.get(string));
            }
        }
        if (this.features != null && !this.features.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String feature : this.features) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                String p = feature.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
                stringBuilder.append(p);
                if (feature.contains("/")) continue;
                stringBuilder.append("/.*");
            }
            Pattern pattern = Pattern.compile(stringBuilder.toString());
            Iterator iterator = featuresToTest.iterator();
            while (iterator.hasNext()) {
                org.apache.karaf.features.internal.model.Feature feature;
                feature = (org.apache.karaf.features.internal.model.Feature)iterator.next();
                String id = feature.getName() + "/" + feature.getVersion();
                if (pattern.matcher(id).matches()) continue;
                iterator.remove();
            }
        }
        for (String string : this.framework) {
            properties.put("feature.framework." + string, string);
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (String feature : featuresToTest) {
            block52: {
                try {
                    String id = feature.getName() + "/" + feature.getVersion();
                    this.verifyResolution((DownloadManager)new CustomDownloadManager(this.resolver, executor), repositories, Collections.singleton(id), properties);
                    this.getLog().info((CharSequence)("Verification of feature " + id + " succeeded"));
                }
                catch (Exception e) {
                    if (e.getCause() instanceof ResolutionException) {
                        this.getLog().warn((CharSequence)e.getMessage());
                    } else {
                        this.getLog().warn((Throwable)e);
                    }
                    arrayList.add(e);
                    if (!"first".equals(this.fail)) break block52;
                    throw e;
                }
            }
            for (Conditional cond : feature.getConditional()) {
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                ids.add(feature.getId());
                ids.addAll(cond.getCondition());
                try {
                    this.verifyResolution((DownloadManager)manager, repositories, ids, properties);
                    this.getLog().info((CharSequence)("Verification of feature " + ids + " succeeded"));
                }
                catch (Exception e) {
                    if (this.ignoreMissingConditions && e.getCause() instanceof ResolutionException) {
                        boolean ignore = true;
                        Collection requirements = ((ResolutionException)e.getCause()).getUnresolvedRequirements();
                        for (Requirement req : requirements) {
                            ignore &= "osgi.identity".equals(req.getNamespace()) && "karaf.feature".equals(req.getAttributes().get("type")) && cond.getCondition().contains(req.getAttributes().get("osgi.identity").toString());
                        }
                        if (ignore) {
                            this.getLog().warn((CharSequence)("Feature resolution failed for " + ids + "\nMessage: " + e.getCause().getMessage()));
                            continue;
                        }
                    }
                    if (e.getCause() instanceof ResolutionException) {
                        this.getLog().warn((CharSequence)e.getMessage());
                    } else {
                        this.getLog().warn((Throwable)e);
                    }
                    arrayList.add(e);
                    if (!"first".equals(this.fail)) continue;
                    throw e;
                }
            }
        }
        if ("end".equals(this.fail) && !arrayList.isEmpty()) {
            throw new MojoExecutionException("Verification failures", (Exception)new MultiException("Verification failures", arrayList));
        }
    }

    private void verifyResolution(DownloadManager manager, Map<String, Features> repositories, Set<String> features, Hashtable<String, String> properties) throws MojoExecutionException {
        try {
            Bundle systemBundle = this.getSystemBundle(VerifyMojo.getMetadata(properties, "metadata#"));
            DummyDeployCallback callback = new DummyDeployCallback(systemBundle, repositories.values());
            Deployer deployer = new Deployer(manager, (Resolver)new ResolverImpl((Logger)new MavenResolverLog()), (Deployer.DeployCallback)callback);
            Deployer.DeploymentRequest request = this.createDeploymentRequest();
            for (String fmwk : this.framework) {
                MapUtils.addToMapSet((Map)request.requirements, (Object)"root", (Object)fmwk);
            }
            try {
                deployer.deploy(callback.getDeploymentState(), request);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to resolve framework features", e);
            }
            for (String feature : features) {
                MapUtils.addToMapSet((Map)request.requirements, (Object)"root", (Object)feature);
            }
            try {
                HashSet prereqs = new HashSet();
                while (true) {
                    try {
                        deployer.deploy(callback.getDeploymentState(), request);
                    }
                    catch (Deployer.PartialDeploymentException e) {
                        if (!prereqs.containsAll(e.getMissing())) {
                            prereqs.addAll(e.getMissing());
                            continue;
                        }
                        throw new Exception("Deployment aborted due to loop in missing prerequisites: " + e.getMissing());
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Feature resolution failed for " + features + "\nMessage: " + e.getMessage() + "\nRepositories: " + this.toString(new TreeSet<String>(repositories.keySet())) + "\nResources: " + this.toString(new TreeSet<String>(manager.getProviders().keySet())), e);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error verifying feature " + features + "\nMessage: " + e.getMessage(), e);
        }
    }

    private Deployer.DeploymentRequest createDeploymentRequest() {
        Deployer.DeploymentRequest request = new Deployer.DeploymentRequest();
        request.bundleUpdateRange = "${range;[==,=+)}";
        request.featureResolutionRange = "${range;[====,====]}";
        request.serviceRequirements = "default";
        request.overrides = new HashSet();
        request.requirements = new HashMap();
        request.stateChanges = new HashMap();
        request.options = EnumSet.noneOf(FeaturesService.Option.class);
        return request;
    }

    private String toString(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (String s : collection) {
            sb.append("\t").append(s).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private Bundle getSystemBundle(Map<String, Map<VersionRange, Map<String, String>>> metadata) throws Exception {
        URL configPropURL;
        if (this.configuration != null) {
            configPropURL = new URL(this.configuration);
        } else {
            Artifact karafDistro = (Artifact)this.project.getArtifactMap().get(this.distribution);
            if (karafDistro != null) {
                String dir = this.distDir;
                if ("kar".equals(karafDistro.getType()) && dir == null) {
                    dir = "resources";
                }
                if (dir == null) {
                    dir = karafDistro.getArtifactId() + "-" + karafDistro.getBaseVersion();
                }
                configPropURL = new URL("jar:file:" + karafDistro.getFile() + "!/" + dir + "/etc/config.properties");
            } else {
                String version = this.getVersion(this.distribution, "RELEASE");
                String[] dist = this.distribution.split(":");
                File distFile = this.resolver.resolve(dist[0], dist[1], null, "zip", version);
                String resolvedVersion = distFile.getName().substring(dist[1].length() + 1, distFile.getName().length() - 4);
                Object dir = this.distDir;
                if (dir == null) {
                    dir = dist[1] + "-" + resolvedVersion;
                }
                configPropURL = new URL("jar:file:" + distFile + "!/" + (String)dir + "/etc/config.properties");
            }
        }
        org.apache.felix.utils.properties.Properties configProps = PropertiesLoader.loadPropertiesFile((URL)configPropURL, (boolean)true);
        if (this.javase == null) {
            configProps.put("java.specification.version", System.getProperty("java.specification.version"));
        } else {
            configProps.put("java.specification.version", this.javase);
        }
        configProps.substitute();
        Attributes attributes = new Attributes();
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", "system.bundle");
        attributes.putValue("Bundle-Version", "0.0.0");
        String exportPackages = configProps.getProperty("org.osgi.framework.system.packages");
        if (configProps.containsKey((Object)"org.osgi.framework.system.packages.extra")) {
            exportPackages = exportPackages + "," + configProps.getProperty("org.osgi.framework.system.packages.extra");
        }
        exportPackages = exportPackages.replaceAll(",\\s*,", ",");
        attributes.putValue("Export-Package", exportPackages);
        String systemCaps = configProps.getProperty("org.osgi.framework.system.capabilities");
        attributes.putValue("Provide-Capability", systemCaps);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        for (Map.Entry entry : attributes.entrySet()) {
            headers.put(entry.getKey().toString(), entry.getValue().toString());
        }
        FakeBundleRevision resource = new FakeBundleRevision(headers, "system-bundle", 0L);
        return resource.getBundle();
    }

    public static Map<String, Features> loadRepositories(DownloadManager manager, Set<String> uris) throws Exception {
        final HashMap<String, Features> loaded = new HashMap<String, Features>();
        final Downloader downloader = manager.createDownloader();
        for (String repository : uris) {
            downloader.download(repository, new DownloadCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloaded(StreamProvider provider) throws Exception {
                    try (InputStream is = provider.open();){
                        Features featuresModel = JaxbUtil.unmarshal((String)provider.getUrl(), (InputStream)is, (boolean)false);
                        Map map = loaded;
                        synchronized (map) {
                            loaded.put(provider.getUrl(), featuresModel);
                            for (String innerRepository : featuresModel.getRepository()) {
                                downloader.download(innerRepository, (DownloadCallback)this);
                            }
                        }
                    }
                }
            });
        }
        downloader.await();
        return loaded;
    }

    public static Set<String> getPrefixedProperties(Map<String, String> properties, String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String url = properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring(prefix.length());
            }
            if (url.isEmpty()) continue;
            result.add(url);
        }
        return result;
    }

    public static Map<String, Map<VersionRange, Map<String, String>>> getMetadata(Map<String, String> properties, String prefix) {
        HashMap<String, Map<VersionRange, Map<String, String>>> result = new HashMap<String, Map<VersionRange, Map<String, String>>>();
        for (String key : properties.keySet()) {
            VersionRange range;
            HashMap<String, String> hdrs;
            String version;
            if (!key.startsWith(prefix)) continue;
            String val = properties.get(key);
            String[] parts = (key = key.substring(prefix.length())).split("#");
            if (parts.length != 3) continue;
            HashMap<VersionRange, HashMap<String, String>> ranges = (HashMap<VersionRange, HashMap<String, String>>)result.get(parts[0]);
            if (ranges == null) {
                ranges = new HashMap<VersionRange, HashMap<String, String>>();
                result.put(parts[0], ranges);
            }
            if (!(version = parts[1]).startsWith("[") && !version.startsWith("(")) {
                Processor processor = new Processor();
                processor.setProperty("@", VersionTable.getVersion((String)version).toString());
                Macro macro = new Macro(processor, new Object[0]);
                version = macro.process("${range;[==,=+)}");
            }
            if ((hdrs = (HashMap<String, String>)ranges.get(range = new VersionRange(version))) == null) {
                hdrs = new HashMap<String, String>();
                ranges.put(range, hdrs);
            }
            hdrs.put(parts[2], val);
        }
        return result;
    }

    public class MavenResolverLog
    extends Logger {
        public MavenResolverLog() {
            super(4);
        }

        protected void doLog(int level, String msg, Throwable throwable) {
            switch (level) {
                case 4: {
                    VerifyMojo.this.getLog().debug((CharSequence)msg, throwable);
                    break;
                }
                case 3: {
                    VerifyMojo.this.getLog().info((CharSequence)msg, throwable);
                    break;
                }
                case 2: {
                    VerifyMojo.this.getLog().warn((CharSequence)msg, throwable);
                    break;
                }
                case 1: {
                    VerifyMojo.this.getLog().error((CharSequence)msg, throwable);
                }
            }
        }
    }

    public static class DummyDeployCallback
    implements Deployer.DeployCallback {
        private final Bundle systemBundle;
        private final Deployer.DeploymentState dstate;
        private final AtomicLong nextBundleId = new AtomicLong(0L);

        public DummyDeployCallback(Bundle sysBundle, Collection<Features> repositories) throws Exception {
            this.systemBundle = sysBundle;
            this.dstate = new Deployer.DeploymentState();
            this.dstate.bundles = new HashMap();
            this.dstate.features = new HashMap();
            this.dstate.bundlesPerRegion = new HashMap();
            this.dstate.filtersPerRegion = new HashMap();
            this.dstate.state = new State();
            MapUtils.addToMapSet((Map)this.dstate.bundlesPerRegion, (Object)"root", (Object)0L);
            this.dstate.bundles.put(0L, this.systemBundle);
            for (Features repo : repositories) {
                for (org.apache.karaf.features.internal.model.Feature f : repo.getFeature()) {
                    this.dstate.features.put(f.getId(), f);
                }
            }
        }

        public Deployer.DeploymentState getDeploymentState() {
            return this.dstate;
        }

        public void print(String message, boolean verbose) {
        }

        public void saveState(State state) {
            this.dstate.state.replace(state);
        }

        public void persistResolveRequest(Deployer.DeploymentRequest request) throws IOException {
        }

        public void installFeature(Feature feature) throws IOException, InvalidSyntaxException {
        }

        public void callListeners(FeatureEvent featureEvent) {
        }

        public Bundle installBundle(String region, String uri, InputStream is) throws BundleException {
            try {
                ZipEntry entry;
                Hashtable<String, String> headers = new Hashtable<String, String>();
                ZipInputStream zis = new ZipInputStream(is);
                while ((entry = zis.getNextEntry()) != null) {
                    if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                    Attributes attributes = new Manifest(zis).getMainAttributes();
                    for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                        headers.put(attr.getKey().toString(), attr.getValue().toString());
                    }
                }
                FakeBundleRevision revision = new FakeBundleRevision(headers, uri, this.nextBundleId.incrementAndGet());
                Bundle bundle = revision.getBundle();
                MapUtils.addToMapSet((Map)this.dstate.bundlesPerRegion, (Object)region, (Object)bundle.getBundleId());
                this.dstate.bundles.put(bundle.getBundleId(), bundle);
                return bundle;
            }
            catch (IOException e) {
                throw new BundleException("Unable to install bundle", (Throwable)e);
            }
        }

        public void updateBundle(Bundle bundle, String uri, InputStream is) throws BundleException {
            throw new UnsupportedOperationException();
        }

        public void uninstall(Bundle bundle) throws BundleException {
            throw new UnsupportedOperationException();
        }

        public void startBundle(Bundle bundle) throws BundleException {
        }

        public void stopBundle(Bundle bundle, int options) throws BundleException {
        }

        public void setBundleStartLevel(Bundle bundle, int startLevel) {
        }

        public void refreshPackages(Collection<Bundle> bundles) throws InterruptedException {
        }

        public void resolveBundles(Set<Bundle> bundles, Map<Resource, List<Wire>> wiring, Map<Resource, Bundle> resToBnd) {
        }

        public void replaceDigraph(Map<String, Map<String, Map<String, Set<String>>>> policies, Map<String, Set<Long>> bundles) throws BundleException, InvalidSyntaxException {
        }
    }

    public static class FakeBundleRevision
    extends ResourceImpl
    implements BundleRevision,
    BundleStartLevel {
        private final Bundle bundle;
        private int startLevel;

        public FakeBundleRevision(final Hashtable<String, String> headers, final String location, final long bundleId) throws BundleException {
            ResourceBuilder.build((ResourceImpl)this, (String)location, headers);
            this.bundle = (Bundle)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{Bundle.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("hashCode")) {
                        return ((Object)((Object)this)).hashCode();
                    }
                    if (method.getName().equals("equals")) {
                        return proxy == args[0];
                    }
                    if (method.getName().equals("toString")) {
                        return bundle.getSymbolicName() + "/" + bundle.getVersion();
                    }
                    if (method.getName().equals("adapt")) {
                        if (args.length == 1 && args[0] == BundleRevision.class) {
                            return this;
                        }
                        if (args.length == 1 && args[0] == BundleStartLevel.class) {
                            return this;
                        }
                    } else {
                        if (method.getName().equals("getHeaders")) {
                            return headers;
                        }
                        if (method.getName().equals("getBundleId")) {
                            return bundleId;
                        }
                        if (method.getName().equals("getLocation")) {
                            return location;
                        }
                        if (method.getName().equals("getSymbolicName")) {
                            String name = (String)headers.get("Bundle-SymbolicName");
                            int idx = name.indexOf(59);
                            if (idx > 0) {
                                name = name.substring(0, idx).trim();
                            }
                            return name;
                        }
                        if (method.getName().equals("getVersion")) {
                            return new Version((String)headers.get("Bundle-Version"));
                        }
                        if (method.getName().equals("getState")) {
                            return 32;
                        }
                        if (method.getName().equals("getLastModified")) {
                            return 0L;
                        }
                    }
                    return null;
                }
            });
        }

        public int getStartLevel() {
            return this.startLevel;
        }

        public void setStartLevel(int startLevel) {
            this.startLevel = startLevel;
        }

        public boolean isPersistentlyStarted() {
            return true;
        }

        public boolean isActivationPolicyUsed() {
            return false;
        }

        public String getSymbolicName() {
            return this.bundle.getSymbolicName();
        }

        public Version getVersion() {
            return this.bundle.getVersion();
        }

        public List<BundleCapability> getDeclaredCapabilities(String namespace) {
            throw new UnsupportedOperationException();
        }

        public List<BundleRequirement> getDeclaredRequirements(String namespace) {
            throw new UnsupportedOperationException();
        }

        public int getTypes() {
            throw new UnsupportedOperationException();
        }

        public BundleWiring getWiring() {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

