/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="archive", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ArchiveMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.build.directory}")
    private File destDir;
    @Parameter(defaultValue="${project.build.directory}/assembly")
    private File targetServerDirectory;
    @Parameter(defaultValue="${project.artifactId}-${project.version}")
    private String pathPrefix;
    @Parameter
    private boolean usePathPrefix = true;
    @Parameter(defaultValue="${project.artifactId}-${project.version}")
    private File targetFile;
    @Parameter
    private boolean archiveTarGz = true;
    @Parameter
    private boolean archiveZip = true;
    @Parameter
    private boolean useSymLinks = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Setting artifact file: " + this.targetFile));
        Artifact artifact = this.project.getArtifact();
        artifact.setFile(this.targetFile);
        try {
            if (this.archiveTarGz) {
                this.archive("tar.gz");
            }
            if (this.archiveZip) {
                this.archive("zip");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not archive plugin", e);
        }
    }

    private void archive(String type) throws IOException {
        Artifact artifact1 = this.factory.createArtifactWithClassifier(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getVersion(), type, "bin");
        File target1 = this.archive(this.targetServerDirectory, this.destDir, artifact1);
        this.projectHelper.attachArtifact(this.project, artifact1.getType(), null, target1);
    }

    public File archive(File source, File dest, Artifact artifact) throws IOException {
        block113: {
            String serverName = null;
            serverName = this.targetFile != null && this.project.getPackaging().equals("karaf-assembly") ? this.targetFile.getName() : artifact.getArtifactId() + "-" + artifact.getVersion();
            dest = new File(dest, serverName + "." + artifact.getType());
            String prefix = "";
            if (this.usePathPrefix && (prefix = this.pathPrefix.trim()).length() > 0 && !prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            if ("tar.gz".equals(artifact.getType())) {
                try (OutputStream fOut = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
                     BufferedOutputStream bOut = new BufferedOutputStream(fOut);
                     GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream((OutputStream)bOut);
                     TarArchiveOutputStream tOut = new TarArchiveOutputStream((OutputStream)gzOut);
                     DirectoryStream<Path> children = Files.newDirectoryStream(source.toPath());){
                    tOut.setLongFileMode(3);
                    tOut.setBigNumberMode(2);
                    for (Path child : children) {
                        this.addFileToTarGz(tOut, child, prefix);
                    }
                    break block113;
                }
            }
            if ("zip".equals(artifact.getType())) {
                try (OutputStream fOut = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
                     BufferedOutputStream bOut = new BufferedOutputStream(fOut);
                     ZipArchiveOutputStream tOut = new ZipArchiveOutputStream((OutputStream)bOut);
                     DirectoryStream<Path> children = Files.newDirectoryStream(source.toPath());){
                    for (Path child : children) {
                        this.addFileToZip(tOut, child, prefix);
                    }
                    break block113;
                }
            }
            throw new IllegalArgumentException("Unknown target type: " + artifact.getType());
        }
        return dest;
    }

    private void addFileToTarGz(TarArchiveOutputStream tOut, Path f, String base) throws IOException {
        if (Files.isDirectory(f, new LinkOption[0])) {
            String entryName = base + f.getFileName().toString() + "/";
            TarArchiveEntry tarEntry = new TarArchiveEntry(entryName);
            tOut.putArchiveEntry((ArchiveEntry)tarEntry);
            tOut.closeArchiveEntry();
            try (DirectoryStream<Path> children = Files.newDirectoryStream(f);){
                for (Path child : children) {
                    this.addFileToTarGz(tOut, child, entryName);
                }
            }
        } else if (this.useSymLinks && Files.isSymbolicLink(f)) {
            String entryName = base + f.getFileName().toString();
            TarArchiveEntry tarEntry = new TarArchiveEntry(entryName, 50);
            tarEntry.setLinkName(Files.readSymbolicLink(f).toString());
            tOut.putArchiveEntry((ArchiveEntry)tarEntry);
            tOut.closeArchiveEntry();
        } else {
            String entryName = base + f.getFileName().toString();
            TarArchiveEntry tarEntry = new TarArchiveEntry(entryName);
            tarEntry.setSize(Files.size(f));
            if (entryName.contains("/bin/")) {
                if (entryName.endsWith(".bat")) {
                    tarEntry.setMode(420);
                } else {
                    tarEntry.setMode(493);
                }
            }
            tOut.putArchiveEntry((ArchiveEntry)tarEntry);
            Files.copy(f, (OutputStream)tOut);
            tOut.closeArchiveEntry();
        }
    }

    private void addFileToZip(ZipArchiveOutputStream tOut, Path f, String base) throws IOException {
        if (Files.isDirectory(f, new LinkOption[0])) {
            String entryName = base + f.getFileName().toString() + "/";
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(entryName);
            tOut.putArchiveEntry((ArchiveEntry)zipEntry);
            tOut.closeArchiveEntry();
            try (DirectoryStream<Path> children = Files.newDirectoryStream(f);){
                for (Path child : children) {
                    this.addFileToZip(tOut, child, entryName);
                }
            }
        } else if (this.useSymLinks && Files.isSymbolicLink(f)) {
            String entryName = base + f.getFileName().toString();
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(entryName);
            zipEntry.setUnixMode(41380);
            tOut.putArchiveEntry((ArchiveEntry)zipEntry);
            tOut.write(Files.readSymbolicLink(f).toString().getBytes());
            tOut.closeArchiveEntry();
        } else {
            String entryName = base + f.getFileName().toString();
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(entryName);
            zipEntry.setSize(Files.size(f));
            if (entryName.contains("/bin/")) {
                if (!entryName.endsWith(".bat")) {
                    zipEntry.setUnixMode(493);
                } else {
                    zipEntry.setUnixMode(420);
                }
            }
            tOut.putArchiveEntry((ArchiveEntry)zipEntry);
            Files.copy(f, (OutputStream)tOut);
            tOut.closeArchiveEntry();
        }
    }
}

