/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.AggregateCompleter;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsCompleter
implements Completer {
    public static final String COMMANDS = ".commands";
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandsCompleter.class);
    private CommandSession session;
    private final List<Completer> completers = new ArrayList<Completer>();
    private final Set<String> commands = new HashSet<String>();

    public CommandsCompleter() {
        this(CommandSessionHolder.getSession());
    }

    public CommandsCompleter(CommandSession session) {
        this.session = session;
        try {
            new CommandTracker();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        int res;
        if (this.session == null) {
            this.session = CommandSessionHolder.getSession();
        }
        this.checkData();
        CommandsCompleter commandsCompleter = this;
        synchronized (commandsCompleter) {
            res = new AggregateCompleter(this.completers).complete(buffer, cursor, (List)candidates);
        }
        Collections.sort(candidates);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkData() {
        boolean update;
        HashSet names;
        CommandsCompleter commandsCompleter = this;
        synchronized (commandsCompleter) {
            names = new HashSet((Set)this.session.get(COMMANDS));
            update = !names.equals(this.commands);
        }
        if (update) {
            Set<String> aliases = this.getAliases();
            HashSet<String> commands = new HashSet<String>();
            ArrayList<Completer> completers = new ArrayList<Completer>();
            completers.add(new StringsCompleter(aliases));
            for (String command : names) {
                Function function = (Function)this.session.get(command);
                if ((function = this.unProxy(function)) instanceof AbstractCommand) {
                    try {
                        completers.add(new ArgumentCompleter(this.session, (AbstractCommand)function, command));
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unable to create completers for command '" + command + "'", t);
                    }
                }
                commands.add(command);
            }
            CommandsCompleter commandsCompleter2 = this;
            synchronized (commandsCompleter2) {
                this.commands.clear();
                this.completers.clear();
                this.commands.addAll(commands);
                this.completers.addAll(completers);
            }
        }
    }

    private Set<String> getAliases() {
        Set vars = (Set)this.session.get(null);
        HashSet<String> aliases = new HashSet<String>();
        for (String var : vars) {
            Object content = this.session.get(var);
            if (content == null || !"org.apache.felix.gogo.runtime.Closure".equals(content.getClass().getName())) continue;
            aliases.add(var);
        }
        return aliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Function unProxy(Function function) {
        block7: {
            try {
                if (!"org.apache.felix.gogo.runtime.CommandProxy".equals(function.getClass().getName())) break block7;
                Field contextField = function.getClass().getDeclaredField("context");
                Field referenceField = function.getClass().getDeclaredField("reference");
                contextField.setAccessible(true);
                referenceField.setAccessible(true);
                BundleContext context = (BundleContext)contextField.get(function);
                ServiceReference reference = (ServiceReference)referenceField.get(function);
                Object target = context != null ? context.getService(reference) : null;
                try {
                    if (target instanceof Function) {
                        function = (Function)target;
                    }
                }
                finally {
                    if (context != null) {
                        context.ungetService(reference);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return function;
    }

    private class CommandTracker {
        public CommandTracker() throws Exception {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            if (context == null) {
                throw new IllegalStateException("Bundle is stopped");
            }
            ServiceListener listener = new ServiceListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void serviceChanged(ServiceEvent event) {
                    CommandsCompleter commandsCompleter = CommandsCompleter.this;
                    synchronized (commandsCompleter) {
                        CommandsCompleter.this.commands.clear();
                    }
                }
            };
            context.addServiceListener(listener, String.format("(&(%s=*)(%s=*))", "osgi.command.scope", "osgi.command.function"));
        }
    }
}

