/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.properties;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoEncryptionSupport {
    public static final String PERIOD = "encryption.check.period";
    private final Logger LOGGER = LoggerFactory.getLogger(AutoEncryptionSupport.class);
    private final String usersFileName;
    private final EncryptionSupport encryptionSupport;
    private final File usersFile;
    private final long period;
    private final Timer timer = new Timer();

    public AutoEncryptionSupport(Map options) {
        this.encryptionSupport = new EncryptionSupport(options);
        this.usersFileName = (String)options.get("users");
        this.usersFile = new File(this.usersFileName).getAbsoluteFile();
        Object period = options.get(PERIOD);
        this.period = period != null ? Long.parseLong(period.toString()) : 60000L;
    }

    public void init() {
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    Properties userProperties = new Properties(AutoEncryptionSupport.this.usersFile);
                    AutoEncryptionSupport.this.encryptedPassword(userProperties);
                }
                catch (IOException ioe) {
                    AutoEncryptionSupport.this.LOGGER.warn("Unable to encrypt user properties file ", (Throwable)ioe);
                }
            }
        };
        this.timer.schedule(task, 0L, this.period);
    }

    public void destroy() {
        this.timer.cancel();
    }

    void encryptedPassword(Properties users) throws IOException {
        boolean changed = false;
        Iterator i$ = users.keySet().iterator();
        while (i$.hasNext()) {
            String encryptedPassword;
            String[] infos;
            String storedPassword;
            String userName;
            String user = userName = (String)i$.next();
            String userInfos = (String)users.get(user);
            if (user.startsWith("_g_:") || (storedPassword = (infos = userInfos.split(","))[0]).equals(encryptedPassword = this.getEncryptedPassword(storedPassword))) continue;
            this.LOGGER.debug("The password isn't flagged as encrypted, encrypt it.");
            userInfos = encryptedPassword + ",";
            for (int i = 1; i < infos.length; ++i) {
                userInfos = i == infos.length - 1 ? userInfos + infos[i] : userInfos + infos[i] + ",";
            }
            if (user.contains("\\")) {
                users.remove(user);
                user = user.replace("\\", "\\\\");
            }
            users.put(user, userInfos);
            changed = true;
        }
        if (changed) {
            users.save();
        }
    }

    String getEncryptedPassword(String password) {
        boolean suffix;
        Encryption encryption = this.encryptionSupport.getEncryption();
        String encryptionPrefix = this.encryptionSupport.getEncryptionPrefix();
        String encryptionSuffix = this.encryptionSupport.getEncryptionSuffix();
        if (encryption == null) {
            return password;
        }
        boolean prefix = encryptionPrefix == null || password.startsWith(encryptionPrefix);
        boolean bl = suffix = encryptionSuffix == null || password.endsWith(encryptionSuffix);
        if (prefix && suffix) {
            return password;
        }
        String p = encryption.encryptPassword(password);
        if (encryptionPrefix != null) {
            p = encryptionPrefix + p;
        }
        if (encryptionSuffix != null) {
            p = p + encryptionSuffix;
        }
        return p;
    }
}

