/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.rest.whiteboard;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.karaf.examples.rest.api.Booking;
import org.apache.karaf.examples.rest.api.BookingService;
import org.osgi.service.component.annotations.Component;

@Path(value="/booking")
@Component(service={BookingServiceRest.class}, property={"osgi.jaxrs.resource=true"})
public class BookingServiceRest
implements BookingService {
    private final Map<Long, Booking> bookings = new HashMap<Long, Booking>();

    @Path(value="/")
    @Produces(value={"application/json"})
    @GET
    public Collection<Booking> list() {
        return this.bookings.values();
    }

    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @GET
    public Booking get(@PathParam(value="id") Long id) {
        return this.bookings.get(id);
    }

    @Path(value="/")
    @Consumes(value={"application/json"})
    @POST
    public void add(Booking booking) {
        this.bookings.put(booking.getId(), booking);
    }

    @Path(value="/")
    @Consumes(value={"application/json"})
    @PUT
    public void update(Booking booking) {
        this.bookings.remove(booking.getId());
        this.bookings.put(booking.getId(), booking);
    }

    @Path(value="/{id}")
    @DELETE
    public void remove(@PathParam(value="id") Long id) {
        this.bookings.remove(id);
    }
}

