/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.rest.scr;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.karaf.examples.rest.api.Booking;
import org.apache.karaf.examples.rest.api.BookingService;

@Path(value="/")
public class BookingServiceRest
implements BookingService {
    private final Map<Long, Booking> bookings = new HashMap<Long, Booking>();

    @Path(value="/")
    @Produces(value={"application/json"})
    @GET
    public Collection<Booking> list() {
        return this.bookings.values();
    }

    @Path(value="/all")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed"})
    @POST
    public MultipartBody traceMultipart(List<Attachment> atts) {
        ArrayList<Attachment> results = new ArrayList<Attachment>();
        Attachment att1 = new Attachment("text", "text/html", (Object)"Hello World!");
        results.add(att1);
        Booking b1 = new Booking();
        b1.setCustomer("me");
        b1.setFlight("far far away");
        b1.setId(Long.valueOf(42L));
        Attachment att2 = new Attachment("json", "application/json", (Object)b1);
        results.add(att2);
        Attachment att3 = new Attachment("stream", "application/octet-stream", (Object)new ByteArrayInputStream("important information".getBytes()));
        results.add(att3);
        results.addAll(atts);
        return new MultipartBody(results, true);
    }

    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @GET
    public Booking get(@PathParam(value="id") Long id) {
        return this.bookings.get(id);
    }

    @Path(value="/")
    @Consumes(value={"application/json"})
    @POST
    public void add(Booking booking) {
        this.bookings.put(booking.getId(), booking);
    }

    @Path(value="/")
    @Consumes(value={"application/json"})
    @PUT
    public void update(Booking booking) {
        this.bookings.remove(booking.getId());
        this.bookings.put(booking.getId(), booking);
    }

    @Path(value="/{id}")
    @DELETE
    public void remove(@PathParam(value="id") Long id) {
        this.bookings.remove(id);
    }
}

