/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.rest.client.cxf;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.karaf.examples.rest.api.Booking;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Service
@Command(scope="booking", name="list-all", description="List booking with attachments")
public class ListAllBookingCommand
implements Action {
    @Option(name="--url", description="Location of the REST service", required=false, multiValued=false)
    String restLocation = "http://localhost:8181/cxf/booking/all";

    public Object execute() throws Exception {
        ArrayList<JacksonJsonProvider> providers = new ArrayList<JacksonJsonProvider>();
        providers.add(new JacksonJsonProvider());
        WebClient webClient = WebClient.create((String)this.restLocation, providers);
        LinkedList<Attachment> atts = new LinkedList<Attachment>();
        Booking b1 = new Booking();
        b1.setCustomer("the one who must not be named");
        b1.setFlight("101");
        b1.setId(Long.valueOf(43L));
        atts.add(new Attachment("root", "application/json", (Object)b1));
        atts.add(new Attachment("image", "application/octet-stream", (Object)new ByteArrayInputStream("UGhvdG8=".getBytes(StandardCharsets.UTF_8))));
        Collection results = webClient.type("multipart/mixed").accept(new String[]{"multipart/mixed"}).postAndGetCollection(atts, Attachment.class);
        for (Attachment a : results) {
            System.out.println(a.getContentId() + ": " + a.getContentType() + ": " + a.getDataHandler().getContent());
        }
        return null;
    }
}

