/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.bundle.client;

import org.apache.karaf.examples.bundle.client.ClientService;
import org.apache.karaf.examples.bundle.client.ClientServiceImpl;
import org.apache.karaf.examples.bundle.client.Display;
import org.apache.karaf.examples.bundle.common.BookingService;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    private ServiceTracker<BookingService, BookingService> bookingServiceTracker;
    private ServiceRegistration clientServiceRegistration;
    private Display display;

    public void start(final BundleContext bundleContext) throws Exception {
        this.bookingServiceTracker = new ServiceTracker<BookingService, BookingService>(bundleContext, BookingService.class, null){

            public BookingService addingService(ServiceReference<BookingService> reference) {
                BookingService bookingService = (BookingService)bundleContext.getService(reference);
                ClientServiceImpl clientService = new ClientServiceImpl();
                clientService.setBookingService(bookingService);
                Activator.this.clientServiceRegistration = bundleContext.registerService(ClientService.class, (Object)clientService, null);
                Activator.this.display = new Display();
                Activator.this.display.setClientService(clientService);
                Activator.this.display.init();
                return bookingService;
            }

            public void removedService(ServiceReference<BookingService> reference, BookingService service) {
                Activator.this.display.destroy();
                Activator.this.clientServiceRegistration.unregister();
            }
        };
        this.bookingServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.bookingServiceTracker.close();
    }
}

