/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.kar;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.karaf.features.FeaturesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class KarArtifactInstaller
implements ArtifactInstaller {
    private final Logger logger = LoggerFactory.getLogger(KarArtifactInstaller.class);
    private static final String KAR_SUFFIX = ".kar";
    private static final String ZIP_SUFFIX = ".zip";
    private String base = "./";
    private String localRepoPath = "./target/local-repo";
    private String timestampPath;
    private DocumentBuilderFactory dbf;
    private FeaturesService featuresService;

    public void init() {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setNamespaceAware(true);
        this.timestampPath = this.localRepoPath + File.separator + ".timestamps";
        if (new File(this.timestampPath).mkdirs()) {
            this.logger.warn("Unable to create directory for Karaf Archive timestamps. Results may vary...");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Karaf archives will be extracted to " + this.localRepoPath);
            this.logger.info("Timestamps for Karaf archives will be extracted to " + this.timestampPath);
        }
    }

    public void destroy() {
        this.logger.info("Karaf archive installer destroyed.");
    }

    public void install(File file) throws Exception {
        if (this.alreadyExtracted(file)) {
            this.logger.info("Ignoring '" + file + "'; timestamp indicates it's already been deployed.");
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Installing " + file);
        }
        ZipFile zipFile = new ZipFile(file);
        byte[] buffer = new byte[5120];
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            File extract;
            ZipEntry entry = entries.nextElement();
            String repoEntryName = this.getRepoEntryName(entry);
            if (repoEntryName != null && this.isFeaturesRepository(extract = this.extract(zipFile, buffer, entry, repoEntryName, this.localRepoPath))) {
                this.addToFeaturesRepositories(repoEntryName);
            }
            if (!entry.getName().startsWith("resource")) continue;
            String resourceEntryName = entry.getName().substring("resource/".length());
            this.extract(zipFile, buffer, entry, resourceEntryName, this.base);
        }
        zipFile.close();
        this.updateTimestamp(file);
    }

    private File extract(ZipFile zipFile, byte[] buffer, ZipEntry entry, String repoEntryName, String base) throws IOException {
        File extract;
        if (entry.isDirectory()) {
            extract = new File(base + File.separator + repoEntryName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating directory '" + extract.getName());
            }
            extract.mkdirs();
        } else {
            extract = new File(base + File.separator + repoEntryName);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(extract));
            int count = 0;
            int totalBytes = 0;
            InputStream inputStream = zipFile.getInputStream(entry);
            while ((count = inputStream.read(buffer)) > 0) {
                bos.write(buffer, 0, count);
                totalBytes += count;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Extracted " + totalBytes + " bytes to " + extract);
            }
            bos.close();
            inputStream.close();
        }
        return extract;
    }

    private String getRepoEntryName(ZipEntry entry) {
        String entryName = entry.getName();
        if (entryName.startsWith("repository")) {
            return entryName.substring("repository/".length());
        }
        if (entryName.startsWith("META-INF") || entryName.startsWith("resources")) {
            return null;
        }
        return entryName;
    }

    public void uninstall(File file) throws Exception {
        this.logger.warn("Karaf archive '" + file + "' has been removed; however, it's feature URLs have not been deregistered, and it's bundles are still available in '" + this.localRepoPath + "'.");
    }

    public void update(File file) throws Exception {
        this.logger.warn("Karaf archive " + file + " has been updated; redeploying.");
        this.install(file);
    }

    protected void updateTimestamp(File karafArchive) throws Exception {
        File timestamp = this.getArchiveTimestampFile(karafArchive);
        if (timestamp.exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Deleting old timestamp file '" + timestamp + "");
            }
            if (!timestamp.delete()) {
                throw new Exception("Unable to delete archive timestamp '" + timestamp + "'");
            }
        }
        this.logger.debug("Creating timestamp file '" + timestamp + "'");
        timestamp.createNewFile();
    }

    protected boolean alreadyExtracted(File karafArchive) {
        File timestamp = this.getArchiveTimestampFile(karafArchive);
        if (timestamp.exists()) {
            return timestamp.lastModified() >= karafArchive.lastModified();
        }
        return false;
    }

    protected File getArchiveTimestampFile(File karafArchive) {
        File timestampDir = new File(new File(this.localRepoPath), ".timestamps");
        if (!timestampDir.exists()) {
            timestampDir.mkdirs();
        }
        return new File(timestampDir, karafArchive.getName());
    }

    protected boolean isFeaturesRepository(File artifact) {
        block4: {
            try {
                if (artifact.isFile() && artifact.getName().endsWith(".xml")) {
                    Document doc = this.parse(artifact);
                    String name = doc.getDocumentElement().getLocalName();
                    String uri = doc.getDocumentElement().getNamespaceURI();
                    if ("features".equals(name) && (uri == null || "".equals(uri) || uri.startsWith("http://karaf.apache.org/xmlns/features/v"))) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug("File " + artifact.getName() + " is not a features file.", (Throwable)e);
            }
        }
        return false;
    }

    protected Document parse(File artifact) throws Exception {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return db.parse(artifact);
    }

    private void addToFeaturesRepositories(String path) {
        URI mvnUri = KarArtifactInstaller.pathToMvnUri(path);
        try {
            this.featuresService.addRepository(mvnUri);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Added feature repository '" + mvnUri + "'.");
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to add repository '" + mvnUri + "'", (Throwable)e);
        }
    }

    static URI pathToMvnUri(String path) {
        String[] bits = path.split("/");
        String classifier = "feature";
        String artifactType = "xml";
        String version = bits[bits.length - 2];
        String artifactId = bits[bits.length - 3];
        StringBuilder buf = new StringBuilder("mvn:");
        for (int i = 0; i < bits.length - 3; ++i) {
            buf.append(bits[i]);
            if (i >= bits.length - 4) continue;
            buf.append(".");
        }
        buf.append("/").append(artifactId).append("/").append(version).append("/").append(artifactType).append("/").append(classifier);
        URI mvnUri = URI.create(buf.toString());
        return mvnUri;
    }

    public boolean canHandle(File file) {
        if (file.isFile() && file.getName().endsWith(KAR_SUFFIX)) {
            this.logger.info("Found a .kar file to deploy.");
            return true;
        }
        if (file.isFile() && file.getName().endsWith(ZIP_SUFFIX)) {
            this.logger.debug("Found a .zip file to deploy; checking contents to see if it's a Karaf archive.");
            try {
                if (new ZipFile(file).getEntry("META-INF/KARAF.MF") != null) {
                    this.logger.info("Found a Karaf archive with .zip prefix; will deploy.");
                    return true;
                }
            }
            catch (Exception e) {
                this.logger.warn("Problem extracting zip file '" + file.getName() + "'; ignoring.", (Throwable)e);
            }
        }
        return false;
    }

    public boolean deleteLocalRepository() {
        return this.deleteDirectory(new File(this.localRepoPath));
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public void setBasePath(String base) {
        this.base = base;
    }

    public void setLocalRepoPath(String localRepoPath) {
        this.localRepoPath = localRepoPath;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }
}

