/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.metrics.KafkaMetricsReporter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.KafkaServerStartable$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005q!B\u0001\u0003\u0011\u00039\u0011\u0001F&bM.\f7+\u001a:wKJ\u001cF/\u0019:uC\ndWM\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u0005QY\u0015MZ6b'\u0016\u0014h/\u001a:Ti\u0006\u0014H/\u00192mKN\u0011\u0011\u0002\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bMIA\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u00059\u0001\"\u0002\f\n\t\u00039\u0012!\u00034s_6\u0004&o\u001c9t)\tAR\r\u0005\u0002\t3\u0019!!B\u0001\u0001\u001b'\rIBb\u0007\t\u00039}i\u0011!\b\u0006\u0003=\u0011\tQ!\u001e;jYNL!\u0001I\u000f\u0003\u000f1{wmZ5oO\"A!%\u0007BC\u0002\u0013\u00051%\u0001\nti\u0006$\u0018nY*feZ,'oQ8oM&<W#\u0001\u0013\u0011\u0005!)\u0013B\u0001\u0014\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0011!J\"\u0011!Q\u0001\n\u0011\n1c\u001d;bi&\u001c7+\u001a:wKJ\u001cuN\u001c4jO\u0002B\u0001BK\r\u0003\u0002\u0003\u0006IaK\u0001\ne\u0016\u0004xN\u001d;feN\u00042\u0001L\u00182\u001b\u0005i#B\u0001\u0018\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003a5\u00121aU3r!\t\u0011T'D\u00014\u0015\t!D!A\u0004nKR\u0014\u0018nY:\n\u0005Y\u001a$\u0001F&bM.\fW*\u001a;sS\u000e\u001c(+\u001a9peR,'\u000f\u0003\u000593\t\u0005\t\u0015!\u0003:\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u0002\u000euqJ!a\u000f\b\u0003\r=\u0003H/[8o!\ti\u0004I\u0004\u0002\u000e}%\u0011qHD\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@\u001d!)1#\u0007C\u0001\tR!\u0001$\u0012$H\u0011\u0015\u00113\t1\u0001%\u0011\u0015Q3\t1\u0001,\u0011\u001dA4\t%AA\u0002eBqaA\rC\u0002\u0013%\u0011*F\u0001K!\tA1*\u0003\u0002M\u0005\tY1*\u00194lCN+'O^3s\u0011\u0019q\u0015\u0004)A\u0005\u0015\u000691/\u001a:wKJ\u0004\u0003\"B\n\u001a\t\u0003\u0001FC\u0001\rR\u0011\u0015\u0011v\n1\u0001%\u00031\u0019XM\u001d<fe\u000e{gNZ5h\u0011\u0015!\u0016\u0004\"\u0001V\u0003\u001d\u0019H/\u0019:ukB$\u0012A\u0016\t\u0003\u001b]K!\u0001\u0017\b\u0003\tUs\u0017\u000e\u001e\u0005\u00065f!\t!V\u0001\tg\",H\u000fZ8x]\")A,\u0007C\u0001;\u0006q1/\u001a;TKJ4XM]*uCR,GC\u0001,_\u0011\u0015y6\f1\u0001a\u0003!qWm^*uCR,\u0007CA\u0007b\u0013\t\u0011gB\u0001\u0003CsR,\u0007\"\u00023\u001a\t\u0003)\u0016!D1xC&$8\u000b[;uI><h\u000eC\u0003g+\u0001\u0007q-A\u0006tKJ4XM\u001d)s_B\u001c\bC\u00015n\u001b\u0005I'B\u00016l\u0003\u0011)H/\u001b7\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u0002\f\n\t\u0003\u0001Hc\u0001\rre\")am\u001ca\u0001O\")\u0001h\u001ca\u0001s!9A/CI\u0001\n\u0003)\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001wU\tItoK\u0001y!\tIh0D\u0001{\u0015\tYH0A\u0005v]\u000eDWmY6fI*\u0011QPD\u0001\u000bC:tw\u000e^1uS>t\u0017BA@{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class KafkaServerStartable
implements Logging {
    private final KafkaConfig staticServerConfig;
    private final KafkaServer server;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return KafkaServerStartable$.MODULE$.$lessinit$greater$default$3();
    }

    public static KafkaServerStartable fromProps(Properties properties, Option<String> option) {
        return KafkaServerStartable$.MODULE$.fromProps(properties, option);
    }

    public static KafkaServerStartable fromProps(Properties properties) {
        return KafkaServerStartable$.MODULE$.fromProps(properties);
    }

    private Logger logger$lzycompute() {
        KafkaServerStartable kafkaServerStartable = this;
        synchronized (kafkaServerStartable) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig staticServerConfig() {
        return this.staticServerConfig;
    }

    private KafkaServer server() {
        return this.server;
    }

    public void startup() {
        try {
            this.server().startup();
            return;
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exiting Kafka.";
                }
            });
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void shutdown() {
        try {
            this.server().shutdown();
            return;
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Halting Kafka.";
                }
            });
            throw Exit$.MODULE$.halt(1, Exit$.MODULE$.halt$default$2());
        }
    }

    public void setServerState(byte newState) {
        this.server().brokerState().newState(newState);
    }

    public void awaitShutdown() {
        this.server().awaitShutdown();
    }

    public KafkaServerStartable(KafkaConfig staticServerConfig, Seq<KafkaMetricsReporter> reporters, Option<String> threadNamePrefix) {
        this.staticServerConfig = staticServerConfig;
        Logging$class.$init$(this);
        KafkaConfig x$1 = staticServerConfig;
        Seq<KafkaMetricsReporter> x$2 = reporters;
        Option<String> x$3 = threadNamePrefix;
        Time x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        this.server = new KafkaServer(x$1, x$4, x$3, x$2);
    }

    public KafkaServerStartable(KafkaConfig serverConfig) {
        this(serverConfig, (Seq<KafkaMetricsReporter>)((Seq)Seq$.MODULE$.empty()), KafkaServerStartable$.MODULE$.$lessinit$greater$default$3());
    }
}

