/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001B\u0004\u000b\u001b!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u00059Q.\u001a;sS\u000e\u001c\u0018BA\r\u0017\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0011\taa]3sm\u0016\u0014\u0018BA\u0010\u001d\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\"A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0007j]&$\u0018.\u00197D_:4\u0017n\u001a\t\u0003G\u0011j\u0011AA\u0005\u0003K\t\u0011Qb\u00117fC:,'oQ8oM&<\u0007\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0015\u0002\u000f1|w\rR5sgV\t\u0011\u0006E\u0002+[=j\u0011a\u000b\u0006\u0003Y)\t!bY8mY\u0016\u001cG/[8o\u0013\tq3FA\u0002TKF\u0004\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u0005%|'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u0012AAR5mK\"A\u0001\b\u0001B\u0001B\u0003%\u0011&\u0001\u0005m_\u001e$\u0015N]:!\u0011!Q\u0004A!b\u0001\n\u0003Y\u0014\u0001\u00027pON,\u0012\u0001\u0010\t\u0005\u001fuz$*\u0003\u0002?!\t!\u0001k\\8m!\t\u0001\u0005*D\u0001B\u0015\t\u00115)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0011S!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO&\u0011\u0011*\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\t\u00193*\u0003\u0002M\u0005\t\u0019Aj\\4\t\u00119\u0003!\u0011!Q\u0001\nq\nQ\u0001\\8hg\u0002B\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!U\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0003I\u0003\"aG*\n\u0005Qc\"\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003S\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002B\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!W\u0001\u0005i&lW\r\u0005\u0002[96\t1L\u0003\u0002\u0012\u0003&\u0011Ql\u0017\u0002\u0005)&lW\rC\u0003`\u0001\u0011\u0005\u0001-\u0001\u0004=S:LGO\u0010\u000b\u0007C\n\u001cG-\u001a4\u0011\u0005\r\u0002\u0001\"B\u0011_\u0001\u0004\u0011\u0003\"B\u0014_\u0001\u0004I\u0003\"\u0002\u001e_\u0001\u0004a\u0004\"\u0002)_\u0001\u0004\u0011\u0006b\u0002-_!\u0003\u0005\r!\u0017\u0005\bQ\u0002\u0001\r\u0011\"\u0003j\u0003\u0019\u0019wN\u001c4jOV\t!\u0005C\u0004l\u0001\u0001\u0007I\u0011\u00027\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0002naB\u0011\u0011B\\\u0005\u0003_*\u0011A!\u00168ji\"9\u0011O[A\u0001\u0002\u0004\u0011\u0013a\u0001=%c!11\u000f\u0001Q!\n\t\nqaY8oM&<\u0007\u0005\u000b\u0002skB\u0011\u0011B^\u0005\u0003o*\u0011\u0001B^8mCRLG.\u001a\u0005\ts\u0002\u0011\r\u0011\"\u0001\u0003u\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014X#A>\u0011\u0005\rb\u0018BA?\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\u0007\u007f\u0002\u0001\u000b\u0011B>\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002B\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\u0002\u0013QD'o\u001c;uY\u0016\u0014XCAA\u0004!\ry\u0011\u0011B\u0005\u0004\u0003\u0017\u0001\"!\u0003+ie>$H\u000f\\3s\u0011!\ty\u0001\u0001Q\u0001\n\u0005\u001d\u0011A\u0003;ie>$H\u000f\\3sA!Q\u00111\u0003\u0001C\u0002\u0013\u0005!!!\u0006\u0002\u0011\rdW-\u00198feN,\"!a\u0006\u0011\r\u0005e\u0011qDA\u0012\u001b\t\tYBC\u0002\u0002\u001e-\nq!\\;uC\ndW-\u0003\u0003\u0002\"\u0005m!aC!se\u0006L()\u001e4gKJ\u0004B!!\n\u0002(5\t\u0001AB\u0004\u0002*\u0001\u0001!!a\u000b\u0003\u001b\rcW-\u00198feRC'/Z1e'\u0011\t9#!\f\u0011\u0007=\ty#C\u0002\u00022A\u0011!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"Y\u0011QGA\u0014\u0005\u0003\u0005\u000b\u0011BA\u001c\u0003!!\bN]3bI&#\u0007cA\u0005\u0002:%\u0019\u00111\b\u0006\u0003\u0007%sG\u000fC\u0004`\u0003O!\t!a\u0010\u0015\t\u0005\r\u0012\u0011\t\u0005\t\u0003k\ti\u00041\u0001\u00028!A\u0011QIA\u0014\t#\n9%\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u00144\u0003\u0011a\u0017M\\4\n\t\u0005M\u0013Q\n\u0002\u0007'R\u0014\u0018N\\4\t\u0015\u0005]\u0013q\u0005b\u0001\n\u0003\tI&A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005m\u0003cA\u0012\u0002^%\u0019\u0011q\f\u0002\u0003\u000f\rcW-\u00198fe\"I\u00111MA\u0014A\u0003%\u00111L\u0001\tG2,\u0017M\\3sA!Q\u0011qMA\u0014\u0001\u0004%\t!!\u001b\u0002\u00131\f7\u000f^*uCR\u001cXCAA6!\r\u0019\u0013QN\u0005\u0004\u0003_\u0012!\u0001D\"mK\u0006tWM]*uCR\u001c\bBCA:\u0003O\u0001\r\u0011\"\u0001\u0002v\u0005iA.Y:u'R\fGo]0%KF$2!\\A<\u0011%\t\u0018\u0011OA\u0001\u0002\u0004\tY\u0007C\u0005\u0002|\u0005\u001d\u0002\u0015)\u0003\u0002l\u0005QA.Y:u'R\fGo\u001d\u0011)\u0007\u0005eT\u000f\u0003\u0006\u0002\u0002\u0006\u001d\u0002\u0019!C\u0001\u0003\u0007\u000b\u0011\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;t+\t\t)\tE\u0002$\u0003\u000fK1!!#\u0003\u00055\u0001&/Z\"mK\u0006t7\u000b^1ug\"Q\u0011QRA\u0014\u0001\u0004%\t!a$\u0002+1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8o\u0018\u0013fcR\u0019Q.!%\t\u0013E\fY)!AA\u0002\u0005\u0015\u0005\"CAK\u0003O\u0001\u000b\u0015BAC\u0003Ia\u0017m\u001d;Qe\u0016\u001cE.Z1o'R\fGo\u001d\u0011)\u0007\u0005MU\u000f\u0003\u0005\u0002\u001c\u0006\u001dB\u0011BAO\u0003%\u0019\u0007.Z2l\t>tW\rF\u0002n\u0003?Cq!!)\u0002\u001a\u0002\u0007q(\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005\u0015\u0016q\u0005C!\u0003O\u000ba\u0001Z8X_J\\G#A7\t\u0011\u0005-\u0016q\u0005C\u0005\u0003[\u000bA\u0003\u001e:z\u00072,\u0017M\u001c$jYRD\u0017.Z:u\u0019><GCAAX!\rI\u0011\u0011W\u0005\u0004\u0003gS!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003o\u000b9\u0003\"\u0003\u0002.\u0006\t2\r\\3b]\u001aKG\u000e\u001e5jKN$Hj\\4)\r\u0005U\u00161XAd!\u0015I\u0011QXAa\u0013\r\tyL\u0003\u0002\u0007i\"\u0014xn^:\u0011\u0007\r\n\u0019-C\u0002\u0002F\n\u0011A\u0003T8h\u00072,\u0017M\\5oO\u0016C8-\u001a9uS>t7EAAa\u0011!\tY-a\n\u0005\n\u00055\u0017\u0001C2mK\u0006tGj\\4\u0015\u00075\fy\r\u0003\u0005\u0002R\u0006%\u0007\u0019AAj\u0003%\u0019G.Z1oC\ndW\rE\u0002$\u0003+L1!a6\u0003\u0005)aun\u001a+p\u00072,\u0017M\u001c\u0005\t\u00037\f9\u0003\"\u0001\u0002^\u0006Y!/Z2pe\u0012\u001cF/\u0019;t)-i\u0017q\\Ar\u0003g\fiP!\u0001\t\u0011\u0005\u0005\u0018\u0011\u001ca\u0001\u0003o\t!!\u001b3\t\u0011\u0005\u0015\u0018\u0011\u001ca\u0001\u0003O\fAA\\1nKB!\u0011\u0011^Ax\u001d\rI\u00111^\u0005\u0004\u0003[T\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002T\u0005E(bAAw\u0015!A\u0011Q_Am\u0001\u0004\t90\u0001\u0003ge>l\u0007cA\u0005\u0002z&\u0019\u00111 \u0006\u0003\t1{gn\u001a\u0005\t\u0003\u007f\fI\u000e1\u0001\u0002x\u0006\u0011Ao\u001c\u0005\t\u0005\u0007\tI\u000e1\u0001\u0002l\u0005)1\u000f^1ug\"A!q\u0001\u0001!\u0002\u0013\t9\"A\u0005dY\u0016\fg.\u001a:tA!A!1\u0002\u0001\u0005\u0002\t\u0011i!A\beK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u+\t\t9\u0004C\u0004\u0003\u0012\u0001!\t!a*\u0002\u000fM$\u0018M\u001d;va\"9!Q\u0003\u0001\u0005\u0002\u0005\u001d\u0016\u0001C:ikR$wn\u001e8\t\u000f\te\u0001\u0001\"\u0011\u0003\u001c\u0005)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXC\u0001B\u000f!\u0015Q#qDAt\u0013\r\u0011\tc\u000b\u0002\u0004'\u0016$\bb\u0002B\u0013\u0001\u0011\u0005#qE\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$2!\u001cB\u0015\u0011!\u0011YCa\tA\u0002\t5\u0012!\u00038fo\u000e{gNZ5h!\rY\"qF\u0005\u0004\u0005ca\"aC&bM.\f7i\u001c8gS\u001eDqA!\u000e\u0001\t\u0003\u00129$A\u0006sK\u000e|gNZ5hkJ,G#B7\u0003:\tu\u0002\u0002\u0003B\u001e\u0005g\u0001\rA!\f\u0002\u0013=dGmQ8oM&<\u0007\u0002\u0003B\u0016\u0005g\u0001\rA!\f\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D\u0005i\u0011MY8si\u000ecW-\u00198j]\u001e$2!\u001cB#\u0011\u001d\t\tKa\u0010A\u0002}BqA!\u0013\u0001\t\u0003\u0011Y%A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$2!\u001cB'\u0011\u001d\u0011yEa\u0012A\u0002=\nq\u0001Z1uC\u0012K'\u000fC\u0004\u0003T\u0001!\tA!\u0016\u0002%\u0005dG/\u001a:DQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u000b\b[\n]#\u0011\fB/\u0011\u001d\t\tK!\u0015A\u0002}BqAa\u0017\u0003R\u0001\u0007q&\u0001\u0007t_V\u00148-\u001a'pO\u0012K'\u000fC\u0004\u0003`\tE\u0003\u0019A\u0018\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'\u000fC\u0004\u0003d\u0001!\tA!\u001a\u0002'!\fg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3\u0015\u00075\u00149\u0007\u0003\u0005\u0003j\t\u0005\u0004\u0019AAt\u0003\r!\u0017N\u001d\u0005\b\u0005[\u0002A\u0011\u0001B8\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000fF\u0004n\u0005c\u0012\u0019H!\u001e\t\u000f\t=#1\u000ea\u0001_!9\u0011\u0011\u0015B6\u0001\u0004y\u0004\u0002\u0003B<\u0005W\u0002\r!a>\u0002\r=4gm]3u\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{\nQ#\u00192peR\fe\u000e\u001a)bkN,7\t\\3b]&tw\rF\u0002n\u0005\u007fBq!!)\u0003z\u0001\u0007q\bC\u0004\u0003\u0004\u0002!\tA!\"\u0002\u001dI,7/^7f\u00072,\u0017M\\5oOR\u0019QNa\"\t\u0011\t%%\u0011\u0011a\u0001\u0005\u0017\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0005U\t5u(C\u0002\u0003\u0010.\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0005'\u0003A\u0011\u0001BK\u00031\tw/Y5u\u00072,\u0017M\\3e)!\tyKa&\u0003\u001a\nm\u0005bBAQ\u0005#\u0003\ra\u0010\u0005\t\u0005o\u0012\t\n1\u0001\u0002x\"Q!Q\u0014BI!\u0003\u0005\r!a>\u0002\u00135\f\u0007pV1ji6\u001b\bb\u0002BQ\u0001\u0011\u0005!1U\u0001'a\u0006,8/Z\"mK\u0006t\u0017N\\4G_JtuN\\\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001cHC\u0001BS!\u0015Q#Q\u0012BT!\u0015I!\u0011V K\u0013\r\u0011YK\u0003\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t=\u0006\u0001\"\u0001\u0005S\u0006i1-\u001e:sK:$8i\u001c8gS\u001eD\u0001Ba-\u0001\t\u0003\u0011!QB\u0001\rG2,\u0017M\\3s\u0007>,h\u000e\u001e\u0005\n\u0005o\u0003\u0011\u0013!C\u0001\u0005s\u000ba#Y<bSR\u001cE.Z1oK\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0005wSC!a>\u0003>.\u0012!q\u0018\t\u0005\u0005\u0003\u0014Y-\u0004\u0002\u0003D*!!Q\u0019Bd\u0003%)hn\u00195fG.,GMC\u0002\u0003J*\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iMa1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0004\u0003R\nA\tAa5\u0002\u00151{wm\u00117fC:,'\u000fE\u0002$\u0005+4a!\u0001\u0002\t\u0002\t]7c\u0001Bk\u0011!9qL!6\u0005\u0002\tmGC\u0001Bj\u0011)\u0011yN!6C\u0002\u0013\u0005!\u0011]\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0011\u0019\u000fE\u0003+\u0005?\tI\u0005C\u0005\u0003h\nU\u0007\u0015!\u0003\u0003d\u00061\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\b\u0005\u0003\u0005\u0003l\nUG\u0011\u0001Bw\u00035\u0019G.Z1oKJ\u001cuN\u001c4jOR\u0019!Ea<\t\u000f!\u0014I\u000f1\u0001\u0003.!A!1\u001fBk\t\u0003\u0011)0A\fde\u0016\fG/\u001a(fo\u000ecW-\u00198fIN+w-\\3oiR1!q\u001fB\u007f\u0005\u007f\u00042a\tB}\u0013\r\u0011YP\u0001\u0002\u000b\u0019><7+Z4nK:$\bBB\u0002\u0003r\u0002\u0007!\n\u0003\u0005\u0004\u0002\tE\b\u0019AA|\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0005\u000b\u0007\u000b\u0011).%A\u0005\u0002\r\u001d\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0004\n)\u001a\u0011L!0")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static LogSegment createNewCleanedSegment(Log log, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(log, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CleanerThread x$10) {
                return x$10.isThreadFailed();
            }
        });
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleaner $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                CleanerThread cleaner = this.$outer.new CleanerThread(i);
                this.$outer.cleaners().$plus$eq((Object)cleaner);
                cleaner.start();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$11) {
                x$11.shutdown();
            }
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        CleanerConfig newCleanerConfig = LogCleaner$.MODULE$.cleanerConfig(newConfig);
        int numThreads = newCleanerConfig.numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads should be at least 1"})).s((Seq)Nil$.MODULE$));
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads cannot be reduced to less than half the current value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentThreads)})));
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads cannot be increased to more than double the current value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentThreads)})));
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset2) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset2);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions2) {
        this.cleanerManager().resumeCleaning(topicPartitions2);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset2, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset2) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset2);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, (Function1)new Serializable(this, offset$1){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(long x$12) {
                return this.apply$mcZJ$sp(x$12);
            }

            public boolean apply$mcZJ$sp(long x$12) {
                return x$12 >= this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        }));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$1) {
                        return x$1.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$2) {
                        return (double)100 * x$2.bufferUtilization();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                ArrayBuffer stats = (ArrayBuffer)this.$outer.cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$3) {
                        return x$3.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$4) {
                        return x$4.bytesWritten();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$5) {
                        return x$5.bytesRead();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$6) {
                        return x$6.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$7) {
                        return x$7.elapsedSecs();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return Math.max(0, (int)(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PreCleanStats apply(CleanerThread x$8) {
                        return x$8.lastPreCleanStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(PreCleanStats x$9) {
                        return x$9.maxCompactionDelayMs();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) / 1000L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return this.$outer.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        public void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicPartition topicPartition) {
            if (this.isRunning()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        @Override
        public void doWork() {
            boolean cleaned = this.tryCleanFilthiestLog();
            if (!cleaned) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean tryCleanFilthiestLog() {
            boolean bl;
            try {
                bl = this.cleanFilthiestLog();
            }
            catch (LogCleaningException logCleaningException) {
                this.warn((Function0<String>)new Serializable(this, logCleaningException){
                    public static final long serialVersionUID = 0L;
                    private final LogCleaningException e$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected exception thrown when cleaning log ", ". Marking its partition (", ") as uncleanable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.log(), this.e$1.log().topicPartition()}));
                    }
                    {
                        this.e$1 = e$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, logCleaningException){
                    public static final long serialVersionUID = 0L;
                    private final LogCleaningException e$1;

                    public final LogCleaningException apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(logCleaningException.log().dir().getParent(), logCleaningException.log().topicPartition());
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private boolean cleanFilthiestLog() throws LogCleaningException {
            Option<LogToClean> option;
            block11: {
                boolean bl;
                block10: {
                    PreCleanStats preCleanStats;
                    block9: {
                        preCleanStats = new PreCleanStats();
                        option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
                        if (!None$.MODULE$.equals(option)) break block9;
                        bl = false;
                        break block10;
                    }
                    if (!(option instanceof Some)) break block11;
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.x();
                    this.lastPreCleanStats_$eq(preCleanStats);
                    try {
                        this.cleanLog(cleanable);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        boolean bl2 = throwable2 instanceof ThreadShutdownException ? true : throwable2 instanceof ControlThrowable;
                        if (bl2) {
                            throw throwable2;
                        }
                        if (throwable2 instanceof Exception) {
                            Exception exception = (Exception)throwable2;
                            throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                        }
                        throw throwable;
                    }
                }
                boolean cleaned = bl;
                Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                try {
                    void var2_6;
                    deletable.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final int apply(Tuple2<TopicPartition, Log> x0$1) {
                            Tuple2<TopicPartition, Log> tuple2 = x0$1;
                            if (tuple2 == null) throw new MatchError(tuple2);
                            Log log = (Log)tuple2._2();
                            try {
                                return log.deleteOldSegments();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                boolean bl = throwable2 instanceof ThreadShutdownException ? true : throwable2 instanceof ControlThrowable;
                                if (bl) {
                                    throw throwable2;
                                }
                                if (!(throwable2 instanceof Exception)) throw throwable;
                                Exception exception = (Exception)throwable2;
                                throw new LogCleaningException(log, exception.getMessage(), exception);
                            }
                        }
                    });
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicPartition apply(Tuple2<TopicPartition, Log> x$13) {
                            return (TopicPartition)x$13._1();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())));
                    return (boolean)var2_6;
                }
                catch (Throwable throwable) {
                    void var12_7;
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)var12_7.map((Function1)new /* invalid duplicate definition of identical inner class */, Iterable$.MODULE$.canBuildFrom())));
                    throw throwable;
                }
            }
            throw new MatchError(option);
        }

        private void cleanLog(LogToClean cleanable) {
            block8: {
                long endOffset = cleanable.firstDirtyOffset();
                try {
                    try {
                        Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            long nextDirtyOffset = tuple2._1$mcJ$sp();
                            CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                            long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                            CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                            this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                            endOffset = nextDirtyOffset2;
                            break block8;
                        }
                        throw new MatchError(tuple2);
                    }
                    catch (IOException iOException) {
                        String logDirectory = cleanable.log().dir().getParent();
                        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to clean up log for ", " in dir ", " due to IOException"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.topicPartition(), logDirectory}));
                        this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)new Serializable(this, msg){
                            public static final long serialVersionUID = 0L;
                            private final String msg$1;

                            public final String apply() {
                                return this.msg$1;
                            }
                            {
                                this.msg$1 = msg$1;
                            }
                        }, iOException);
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                    }
                    catch (LogCleaningAbortedException logCleaningAbortedException) {}
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
                }
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CleanerThread $outer;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.$outer.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.$outer.lastPreCleanStats().maxCompactionDelayMs())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)new Serializable(this, stats){
                    public static final long serialVersionUID = 0L;
                    private final CleanerStats stats$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.stats$1.invalidMessagesRead())}));
                    }
                    {
                        this.stats$1 = stats$1;
                    }
                });
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka-log-cleaner-thread-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threadId)})), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CleanerThread $outer;

                public final void apply(TopicPartition topicPartition) {
                    this.$outer.kafka$log$LogCleaner$CleanerThread$$checkDone(topicPartition);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

