/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import kafka.log.Log$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\b\t\u0003A!j\u0011!\t\u0006\u0003E\r\naaY8n[>t'BA\u0003%\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%\n#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tW\u0001\u0011\t\u0011)A\u0005?\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0004_E\u0012\u0004C\u0001\u0019\u0001\u001b\u0005\u0011\u0001\"B\u000b-\u0001\u00049\u0002\"B\u000f-\u0001\u0004y\u0002B\u0002\u001b\u0001A\u0003&Q'A\u000b`Y><WI\u001c3PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0011\u0005YJT\"A\u001c\u000b\u0005a\"\u0011AB:feZ,'/\u0003\u0002;o\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1)\u0005Mb\u0004CA\u0005>\u0013\tq$B\u0001\u0005w_2\fG/\u001b7f\u0011\u0019\u0001\u0005\u0001)Q\u0005\u0003\u0006yq\f\\8h'R\f'\u000f^(gMN,G\u000f\u0005\u0002\n\u0005&\u00111I\u0003\u0002\u0005\u0019>tw\r\u000b\u0002@y!1a\t\u0001Q!\n\u0005\u000b1\u0004\\1ti\u001a+Go\u00195MK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$\bFA#=\u0011\u0019I\u0005\u0001)Q\u0005\u0003\u0006yA.Y:u\r\u0016$8\r\u001b+j[\u0016l5\u000f\u000b\u0002Iy!1A\n\u0001Q!\n\u0005\u000b1c\u00187bgR\u001c\u0015-^4iiV\u0003H+[7f\u001bND#a\u0013\u001f\t\r=\u0003\u0001\u0015)\u0003B\u0003YyF.Y:u'\u0016tG\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007F\u0001(=\u0011\u0015\u0011\u0006\u0001\"\u0001T\u00039awnZ*uCJ$xJ\u001a4tKR,\u0012!\u0011\u0005\u0006+\u0002!\tAV\u0001\u0015Y><WI\u001c3PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0016\u0003UBQ\u0001\u0017\u0001\u0005\u0002M\u000bA\u0002\\8h\u000b:$wJ\u001a4tKRDQA\u0017\u0001\u0005\u0002M\u000b!\u0003\\1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3Ng\")A\f\u0001C\u0001'\u0006)B.Y:u'\u0016tG\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007\"\u00020\u0001\t\u0003y\u0016\u0001E;qI\u0006$XMR3uG\"\u001cF/\u0019;f)\u0019\u00017-Z4jWB\u0011\u0011\"Y\u0005\u0003E*\u0011A!\u00168ji\")A-\u0018a\u0001k\u0005Ybm\u001c7m_^,'OR3uG\"|eMZ:fi6+G/\u00193bi\u0006DQAZ/A\u0002\u0005\u000b1CZ8mY><XM]*uCJ$xJ\u001a4tKRDQ\u0001[/A\u0002\u0005\u000b1CZ8mY><XM\u001d$fi\u000eDG+[7f\u001bNDQA[/A\u0002\u0005\u000bq\u0002\\3bI\u0016\u0014XI\u001c3PM\u001a\u001cX\r\u001e\u0005\u0006Yv\u0003\r!Q\u0001\u0016Y\u0006\u001cHoU3oi\"Kw\r[<bi\u0016\u0014X.\u0019:l\u0011\u0015q\u0007\u0001\"\u0003p\u0003m)\b\u000fZ1uK2\u000b7\u000f^*f]RD\u0015n\u001a5XCR,'/\\1sWR\u0011\u0001\r\u001d\u0005\u0006c6\u0004\r!Q\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\t\u000bM\u0004A\u0011\u0001;\u0002+I,7/\u001a;MCN$8)Y;hQR,\u0006\u000fV5nKR!\u0001-^<z\u0011\u00151(\u000f1\u0001B\u0003U\u0019WO\u001d'fC\u0012,'\u000fT8h\u000b:$wJ\u001a4tKRDQ\u0001\u001f:A\u0002\u0005\u000b\u0011bY;s)&lW-T:\t\u000bi\u0013\b\u0019A!\t\u000bm\u0004A\u0011\t?\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012! \t\u0004}\u0006\raBA\u0005\u0000\u0013\r\t\tAC\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005!\u0002C\u0004\u0002\f\u0001!\t%!\u0004\u0002\r\u0015\fX/\u00197t)\u0011\ty!!\u0006\u0011\u0007%\t\t\"C\u0002\u0002\u0014)\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0018\u0005%\u0001\u0019AA\r\u0003\u0011!\b.\u0019;\u0011\u0007%\tY\"C\u0002\u0002\u001e)\u00111!\u00118z\u0011\u001d\t\t\u0003\u0001C!\u0003G\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002/\u0001")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private volatile LogOffsetMetadata _logEndOffsetMetadata;
    private volatile long _logStartOffset;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private volatile long _lastSentHighWatermark;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long logStartOffset() {
        return this._logStartOffset;
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this._logEndOffsetMetadata;
    }

    public long logEndOffset() {
        return this.logEndOffsetMetadata().messageOffset();
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public long lastSentHighWatermark() {
        return this._lastSentHighWatermark;
    }

    public void updateFetchState(LogOffsetMetadata followerFetchOffsetMetadata, long followerStartOffset, long followerFetchTimeMs, long leaderEndOffset, long lastSentHighwatermark) {
        if (followerFetchOffsetMetadata.messageOffset() >= leaderEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, followerFetchTimeMs);
        } else if (followerFetchOffsetMetadata.messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this.lastFetchTimeMs);
        }
        this._logStartOffset = followerStartOffset;
        this._logEndOffsetMetadata = followerFetchOffsetMetadata;
        this.lastFetchLeaderLogEndOffset = leaderEndOffset;
        this.lastFetchTimeMs = followerFetchTimeMs;
        this.updateLastSentHighWatermark(lastSentHighwatermark);
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated state of replica to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void updateLastSentHighWatermark(long highWatermark) {
        this._lastSentHighWatermark = highWatermark;
        this.trace((Function0<String>)new Serializable(this, highWatermark){
            public static final long serialVersionUID = 0L;
            private final long highWatermark$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated HW of replica to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.highWatermark$1)}));
            }
            {
                this.highWatermark$1 = highWatermark$1;
            }
        });
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this.lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset state of replica to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public String toString() {
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"Replica(replicaId=").append((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString());
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition().topic()})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", partition=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.topicPartition().partition())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastCaughtUpTimeMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastCaughtUpTimeMs())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", logStartOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.logStartOffset())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", logEndOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.logEndOffset())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", logEndOffsetMetadata=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logEndOffsetMetadata()})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastFetchLeaderLogEndOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastFetchLeaderLogEndOffset)})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastFetchTimeMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastFetchTimeMs)})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastSentHighWatermark=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastSentHighWatermark())})));
        replicaString.append(")");
        return replicaString.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public Replica(int brokerId, TopicPartition topicPartition) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        Logging$class.$init$(this);
        this._logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this._logStartOffset = Log$.MODULE$.UnknownOffset();
        this.lastFetchLeaderLogEndOffset = 0L;
        this.lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this._lastSentHighWatermark = 0L;
    }
}

