/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.ZkReplicaStateMachine$;
import kafka.controller.ZkReplicaStateMachine$$anonfun$kafka$controller$ZkReplicaStateMachine$;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001\u001d\u0011QCW6SKBd\u0017nY1Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001eD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0007G>tg-[4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011AB:feZ,'/\u0003\u0002\u001a-\tY1*\u00194lC\u000e{gNZ5h\u0011!Y\u0002A!A!\u0002\u0013a\u0012!E:uCR,7\t[1oO\u0016dunZ4feB\u0011\u0011\"H\u0005\u0003=\t\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011!\u0001\u0003A!A!\u0002\u0013\t\u0013!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011\u0011BI\u0005\u0003G\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011!)\u0003A!A!\u0002\u00131\u0013\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\"\u0011A\u0001>l\u0013\tY\u0003FA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u0005a2m\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007CA\u00050\u0013\t\u0001$A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0019!TGN\u001c9sA\u0011\u0011\u0002\u0001\u0005\u0006'E\u0002\r\u0001\u0006\u0005\u00067E\u0002\r\u0001\b\u0005\u0006AE\u0002\r!\t\u0005\u0006KE\u0002\rA\n\u0005\u0006[E\u0002\rA\f\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u00031\u0019wN\u001c;s_2dWM]%e+\u0005i\u0004C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$aA%oi\"1A\t\u0001Q\u0001\nu\nQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0003\"\u0002$\u0001\t\u0003:\u0015A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$2\u0001S&]!\tq\u0014*\u0003\u0002K\u007f\t!QK\\5u\u0011\u0015aU\t1\u0001N\u0003!\u0011X\r\u001d7jG\u0006\u001c\bc\u0001(W3:\u0011q\n\u0016\b\u0003!Nk\u0011!\u0015\u0006\u0003%\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001!\n\u0005U{\u0014a\u00029bG.\fw-Z\u0005\u0003/b\u00131aU3r\u0015\t)v\b\u0005\u0002\n5&\u00111L\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\u0006;\u0016\u0003\rAX\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0005\u0002\n?&\u0011\u0001M\u0001\u0002\r%\u0016\u0004H.[2b'R\fG/\u001a\u0005\u0006E\u0002!IaY\u0001\u0015I>D\u0015M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:\u0015\t!#gm\u001a\u0005\u0006K\u0006\u0004\r!P\u0001\ne\u0016\u0004H.[2b\u0013\u0012DQ\u0001T1A\u00025CQ!X1A\u0002yCQ!\u001b\u0001\u0005\n)\fQC]3n_Z,'+\u001a9mS\u000e\f7O\u0012:p[&\u001b(\u000fF\u0003l\u0003\u0003\t\u0019\u0001\u0005\u0003m_JlhB\u0001 n\u0013\tqw(\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u00141!T1q\u0015\tqw\b\u0005\u0002tw6\tAO\u0003\u0002vm\u000611m\\7n_:T!!B<\u000b\u0005aL\u0018AB1qC\u000eDWMC\u0001{\u0003\ry'oZ\u0005\u0003yR\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\n}&\u0011qP\u0001\u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000b\u0015D\u0007\u0019A\u001f\t\u000f\u0005\u0015\u0001\u000e1\u0001\u0002\b\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000793&\u000fC\u0004\u0002\f\u0001!I!!\u0004\u0002/\u0011|'+Z7pm\u0016\u0014V\r\u001d7jG\u0006\u001chI]8n\u0013N\u0014HCBA\b\u0003;\ty\u0002\u0005\u0005?\u0003#Y\u0017qAA\u000b\u0013\r\t\u0019b\u0010\u0002\u0007)V\u0004H.Z\u001a\u0011\u000b1|'/a\u0006\u0011\u00079\u000bI\"C\u0002\u0002\u001ca\u0013\u0011\"\u0012=dKB$\u0018n\u001c8\t\r\u0015\fI\u00011\u0001>\u0011!\t)!!\u0003A\u0002\u0005\u001d\u0001bBA\u0012\u0001\u0011%\u0011QE\u0001\u001eO\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000b^1uKN4%o\\7[WR!\u0011qEA\u001c!%q\u0014\u0011CA\u0015\u0003\u000f\t)\u0002E\u0003m_J\fY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004B\u0001\u0004CBL\u0017\u0002BA\u001b\u0003_\u0011A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJD\u0001\"!\u0002\u0002\"\u0001\u0007\u0011q\u0001\u0005\b\u0003w\u0001A\u0011BA\u001f\u0003]awnZ*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000eF\u0005I\u0003\u007f\t\t%!\u0012\u0002J!1Q-!\u000fA\u0002uBq!a\u0011\u0002:\u0001\u0007!/A\u0005qCJ$\u0018\u000e^5p]\"9\u0011qIA\u001d\u0001\u0004q\u0016!C2veJ\u001cF/\u0019;f\u0011\u0019i\u0016\u0011\ba\u0001=\"9\u0011Q\n\u0001\u0005\n\u0005=\u0013\u0001\u00067pO&sg/\u00197jIR\u0013\u0018M\\:ji&|g\u000eF\u0003I\u0003#\n)\u0006C\u0004\u0002T\u0005-\u0003\u0019A-\u0002\u000fI,\u0007\u000f\\5dC\"1Q,a\u0013A\u0002yCq!!\u0017\u0001\t\u0013\tY&\u0001\u000bm_\u001e4\u0015-\u001b7fIN#\u0018\r^3DQ\u0006tw-\u001a\u000b\n\u0011\u0006u\u0013qLA1\u0003GBq!a\u0015\u0002X\u0001\u0007\u0011\fC\u0004\u0002H\u0005]\u0003\u0019\u00010\t\ru\u000b9\u00061\u0001_\u0011!\t)'a\u0016A\u0002\u0005\u001d\u0014!\u0001;\u0011\u00079\u000bI'C\u0002\u0002la\u0013\u0011\u0002\u00165s_^\f'\r\\3")
public class ZkReplicaStateMachine
extends ReplicaStateMachine {
    private final StateChangeLogger stateChangeLogger;
    public final ControllerContext kafka$controller$ZkReplicaStateMachine$$controllerContext;
    private final KafkaZkClient zkClient;
    public final ControllerBrokerRequestBatch kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch;
    private final int kafka$controller$ZkReplicaStateMachine$$controllerId;

    public int kafka$controller$ZkReplicaStateMachine$$controllerId() {
        return this.kafka$controller$ZkReplicaStateMachine$$controllerId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleStateChanges(Seq<PartitionAndReplica> replicas, ReplicaState targetState) {
        if (!replicas.nonEmpty()) return;
        try {
            this.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch.newBatch();
            replicas.groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(PartitionAndReplica x$2) {
                    return x$2.replica();
                }
            }).foreach((Function1)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZkReplicaStateMachine $outer;
                private final ReplicaState targetState$1;

                public final void apply(Tuple2<Object, Seq<PartitionAndReplica>> x0$1) {
                    Tuple2<Object, Seq<PartitionAndReplica>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int replicaId = tuple2._1$mcI$sp();
                        Seq replicas = (Seq)tuple2._2();
                        this.$outer.kafka$controller$ZkReplicaStateMachine$$doHandleStateChanges(replicaId, (Seq<PartitionAndReplica>)replicas, this.targetState$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetState$1 = targetState$1;
                }
            });
            this.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch.sendRequestsToBrokers(this.kafka$controller$ZkReplicaStateMachine$$controllerContext.epoch());
            return;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final ReplicaState targetState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while moving some replicas to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            return;
        }
        catch (ControllerMovedException controllerMovedException) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final ReplicaState targetState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller moved to another broker when moving some replicas to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, controllerMovedException){
                public static final long serialVersionUID = 0L;
                private final ControllerMovedException e$1;

                public final ControllerMovedException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw controllerMovedException;
        }
    }

    public void kafka$controller$ZkReplicaStateMachine$$doHandleStateChanges(int replicaId, Seq<PartitionAndReplica> replicas, ReplicaState targetState) {
        Tuple2<Seq<PartitionAndReplica>, Seq<PartitionAndReplica>> tuple2;
        block2: {
            ReplicaState replicaState;
            block11: {
                block4: {
                    Seq validReplicas;
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    Tuple2 tuple22;
                                    block7: {
                                        Tuple2 tuple23;
                                        block5: {
                                            block3: {
                                                Tuple2 tuple24;
                                                replicas.foreach((Function1)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ ZkReplicaStateMachine $outer;

                                                    public final void apply(PartitionAndReplica replica) {
                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaStateIfNotExists(replica, NonExistentReplica$.MODULE$);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                });
                                                tuple2 = this.kafka$controller$ZkReplicaStateMachine$$controllerContext.checkValidReplicaStateChange(replicas, targetState);
                                                if (tuple2 == null) break block2;
                                                Seq validReplicas2 = (Seq)tuple2._1();
                                                Seq invalidReplicas = (Seq)tuple2._2();
                                                Tuple2 tuple25 = tuple24 = new Tuple2((Object)validReplicas2, (Object)invalidReplicas);
                                                validReplicas = (Seq)tuple25._1();
                                                Seq invalidReplicas2 = (Seq)tuple25._2();
                                                invalidReplicas2.foreach((Function1)new Serializable(this, targetState){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ ZkReplicaStateMachine $outer;
                                                    private final ReplicaState targetState$2;

                                                    public final void apply(PartitionAndReplica replica) {
                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$logInvalidTransition(replica, this.targetState$2);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        this.targetState$2 = targetState$2;
                                                    }
                                                });
                                                replicaState = targetState;
                                                if (!NewReplica$.MODULE$.equals(replicaState)) break block3;
                                                validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ ZkReplicaStateMachine $outer;
                                                    private final int replicaId$1;

                                                    public final void apply(PartitionAndReplica replica) {
                                                        Option option;
                                                        block7: {
                                                            block6: {
                                                                ReplicaState currentState;
                                                                TopicPartition partition;
                                                                block5: {
                                                                    BoxedUnit boxedUnit;
                                                                    partition = replica.topicPartition();
                                                                    currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                                                                    option = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionLeadershipInfo().get((Object)partition);
                                                                    if (!(option instanceof Some)) break block5;
                                                                    Some some = (Some)option;
                                                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                    if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == this.replicaId$1) {
                                                                        StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " for partition ", " cannot be moved to NewReplica state as it is being requested to become leader"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$1), partition})));
                                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, exception);
                                                                        boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replicaId$1}))), replica.topicPartition(), leaderIsrAndControllerEpoch, this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionReplicaAssignment(replica.topicPartition()), true);
                                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, partition, currentState, NewReplica$.MODULE$);
                                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
                                                                        boxedUnit = BoxedUnit.UNIT;
                                                                    }
                                                                    BoxedUnit boxedUnit2 = boxedUnit;
                                                                    break block6;
                                                                }
                                                                if (!None$.MODULE$.equals(option)) break block7;
                                                                this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, partition, currentState, NewReplica$.MODULE$);
                                                                this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            }
                                                            return;
                                                        }
                                                        throw new MatchError((Object)option);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        this.replicaId$1 = replicaId$1;
                                                    }
                                                });
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block4;
                                            }
                                            if (!OnlineReplica$.MODULE$.equals(replicaState)) break block5;
                                            validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ ZkReplicaStateMachine $outer;
                                                private final int replicaId$1;

                                                public final void apply(PartitionAndReplica replica) {
                                                    Option option;
                                                    block9: {
                                                        ReplicaState currentState;
                                                        TopicPartition partition;
                                                        block6: {
                                                            block8: {
                                                                block7: {
                                                                    block5: {
                                                                        BoxedUnit boxedUnit;
                                                                        partition = replica.topicPartition();
                                                                        currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                                                                        ReplicaState replicaState = currentState;
                                                                        if (!NewReplica$.MODULE$.equals(replicaState)) break block5;
                                                                        Seq<Object> assignment = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionReplicaAssignment(partition);
                                                                        if (assignment.contains((Object)BoxesRunTime.boxToInteger((int)this.replicaId$1))) {
                                                                            boxedUnit = BoxedUnit.UNIT;
                                                                        } else {
                                                                            this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.updatePartitionReplicaAssignment(partition, (Seq<Object>)((Seq)assignment.$colon$plus((Object)BoxesRunTime.boxToInteger((int)this.replicaId$1), Seq$.MODULE$.canBuildFrom())));
                                                                            boxedUnit = BoxedUnit.UNIT;
                                                                        }
                                                                        BoxedUnit boxedUnit2 = boxedUnit;
                                                                        break block6;
                                                                    }
                                                                    option = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionLeadershipInfo().get((Object)partition);
                                                                    if (!(option instanceof Some)) break block7;
                                                                    Some some = (Some)option;
                                                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                    this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replicaId$1}))), replica.topicPartition(), leaderIsrAndControllerEpoch, this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionReplicaAssignment(partition), false);
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    break block8;
                                                                }
                                                                if (!None$.MODULE$.equals(option)) break block9;
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            }
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        }
                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, partition, currentState, OnlineReplica$.MODULE$);
                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaState(replica, OnlineReplica$.MODULE$);
                                                        return;
                                                    }
                                                    throw new MatchError((Object)option);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.replicaId$1 = replicaId$1;
                                                }
                                            });
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block4;
                                        }
                                        if (!OfflineReplica$.MODULE$.equals(replicaState)) break block6;
                                        validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ ZkReplicaStateMachine $outer;
                                            private final int replicaId$1;

                                            public final void apply(PartitionAndReplica replica) {
                                                this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replicaId$1}))), replica.topicPartition(), false);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.replicaId$1 = replicaId$1;
                                            }
                                        });
                                        tuple22 = validReplicas.partition((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ ZkReplicaStateMachine $outer;

                                            public final boolean apply(PartitionAndReplica replica) {
                                                return this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionLeadershipInfo().contains((Object)replica.topicPartition());
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        if (tuple22 == null) break block7;
                                        Seq replicasWithLeadershipInfo = (Seq)tuple22._1();
                                        Seq replicasWithoutLeadershipInfo = (Seq)tuple22._2();
                                        Tuple2 tuple26 = tuple23 = new Tuple2((Object)replicasWithLeadershipInfo, (Object)replicasWithoutLeadershipInfo);
                                        Seq replicasWithLeadershipInfo2 = (Seq)tuple26._1();
                                        Seq replicasWithoutLeadershipInfo2 = (Seq)tuple26._2();
                                        Map<TopicPartition, LeaderIsrAndControllerEpoch> updatedLeaderIsrAndControllerEpochs = this.removeReplicasFromIsr(replicaId, (Seq<TopicPartition>)((Seq)replicasWithLeadershipInfo2.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final TopicPartition apply(PartitionAndReplica x$5) {
                                                return x$5.topicPartition();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())));
                                        updatedLeaderIsrAndControllerEpochs.foreach((Function1)new Serializable(this, replicaId){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ ZkReplicaStateMachine $outer;
                                            public final int replicaId$1;

                                            public final void apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$2) {
                                                Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$2;
                                                if (tuple2 != null) {
                                                    TopicPartition partition = (TopicPartition)tuple2._1();
                                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                                                    if (!this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
                                                        Seq recipients = (Seq)this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionReplicaAssignment(partition).filterNot((Function1)new Serializable(this){
                                                            public static final long serialVersionUID = 0L;
                                                            private final /* synthetic */ $anonfun$kafka$controller$ZkReplicaStateMachine$$doHandleStateChanges$6 $outer;

                                                            public final boolean apply(int x$6) {
                                                                return this.apply$mcZI$sp(x$6);
                                                            }

                                                            public boolean apply$mcZI$sp(int x$6) {
                                                                return x$6 == this.$outer.replicaId$1;
                                                            }
                                                            {
                                                                if ($outer == null) {
                                                                    throw null;
                                                                }
                                                                this.$outer = $outer;
                                                            }
                                                        });
                                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)recipients, partition, leaderIsrAndControllerEpoch, this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionReplicaAssignment(partition), false);
                                                    }
                                                    PartitionAndReplica replica = new PartitionAndReplica(partition, this.replicaId$1);
                                                    ReplicaState currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                                                    this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, partition, currentState, OfflineReplica$.MODULE$);
                                                    this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    return;
                                                }
                                                throw new MatchError(tuple2);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.replicaId$1 = replicaId$1;
                                            }
                                        });
                                        replicasWithoutLeadershipInfo2.foreach((Function1)new Serializable(this, replicaId){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ ZkReplicaStateMachine $outer;
                                            private final int replicaId$1;

                                            public final void apply(PartitionAndReplica replica) {
                                                ReplicaState currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                                                this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), currentState, OfflineReplica$.MODULE$);
                                                this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch.addUpdateMetadataRequestForBrokers((Seq<Object>)this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{replica.topicPartition()}))));
                                                this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.replicaId$1 = replicaId$1;
                                            }
                                        });
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    throw new MatchError((Object)tuple22);
                                }
                                if (!ReplicaDeletionStarted$.MODULE$.equals(replicaState)) break block8;
                                validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkReplicaStateMachine $outer;
                                    private final int replicaId$1;

                                    public final void apply(PartitionAndReplica replica) {
                                        ReplicaState currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionStarted$.MODULE$);
                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaState(replica, ReplicaDeletionStarted$.MODULE$);
                                        this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replicaId$1}))), replica.topicPartition(), true);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.replicaId$1 = replicaId$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (!ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) break block9;
                            validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ZkReplicaStateMachine $outer;
                                private final int replicaId$1;

                                public final void apply(PartitionAndReplica replica) {
                                    ReplicaState currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                                    this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionIneligible$.MODULE$);
                                    this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaState(replica, ReplicaDeletionIneligible$.MODULE$);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.replicaId$1 = replicaId$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (!ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) break block10;
                        validReplicas.foreach((Function1)new Serializable(this, replicaId){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ZkReplicaStateMachine $outer;
                            private final int replicaId$1;

                            public final void apply(PartitionAndReplica replica) {
                                ReplicaState currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                                this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionSuccessful$.MODULE$);
                                this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.putReplicaState(replica, ReplicaDeletionSuccessful$.MODULE$);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.replicaId$1 = replicaId$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!NonExistentReplica$.MODULE$.equals(replicaState)) break block11;
                    validReplicas.foreach((Function1)new Serializable(this, replicaId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ZkReplicaStateMachine $outer;
                        private final int replicaId$1;

                        public final void apply(PartitionAndReplica replica) {
                            ReplicaState currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                            Seq<Object> currentAssignedReplicas = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionReplicaAssignment(replica.topicPartition());
                            this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.updatePartitionReplicaAssignment(replica.topicPartition(), (Seq<Object>)((Seq)currentAssignedReplicas.filterNot((Function1)new Serializable(this, replica){
                                public static final long serialVersionUID = 0L;
                                private final PartitionAndReplica replica$2;

                                public final boolean apply(int x$7) {
                                    return this.apply$mcZI$sp(x$7);
                                }

                                public boolean apply$mcZI$sp(int x$7) {
                                    return x$7 == this.replica$2.replica();
                                }
                                {
                                    this.replica$2 = replica$2;
                                }
                            })));
                            this.$outer.kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), currentState, NonExistentReplica$.MODULE$);
                            this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.removeReplicaState(replica);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.replicaId$1 = replicaId$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)replicaState);
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private Map<TopicPartition, LeaderIsrAndControllerEpoch> removeReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        void var3_3;
        Map results = Predef$.MODULE$.Map().empty();
        Seq remaining = partitions;
        while (remaining.nonEmpty()) {
            Tuple3<Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple3 = this.doRemoveReplicasFromIsr(replicaId, remaining);
            if (tuple3 != null) {
                Tuple3 tuple32;
                Map successfulRemovals = (Map)tuple3._1();
                Seq removalsToRetry = (Seq)tuple3._2();
                Map failedRemovals = (Map)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)successfulRemovals, (Object)removalsToRetry, (Object)failedRemovals);
                Map successfulRemovals2 = (Map)tuple33._1();
                Seq removalsToRetry2 = (Seq)tuple33._2();
                Map failedRemovals2 = (Map)tuple33._3();
                results = results.$plus$plus((GenTraversableOnce)successfulRemovals2);
                remaining = removalsToRetry2;
                failedRemovals2.foreach((Function1)new Serializable(this, replicaId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ZkReplicaStateMachine $outer;
                    private final int replicaId$3;

                    public final void apply(Tuple2<TopicPartition, Exception> x0$3) {
                        Tuple2<TopicPartition, Exception> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            Exception e = (Exception)tuple2._2();
                            PartitionAndReplica replica = new PartitionAndReplica(partition, this.replicaId$3);
                            ReplicaState currentState = this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
                            this.$outer.kafka$controller$ZkReplicaStateMachine$$logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.replicaId$3 = replicaId$3;
                    }
                });
                continue;
            }
            throw new MatchError(tuple3);
        }
        return var3_3;
    }

    private Tuple3<Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, Map<TopicPartition, Exception>> doRemoveReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple3 = this.getTopicPartitionStatesFromZk(partitions);
        if (tuple3 != null) {
            Tuple3 tuple32;
            Map leaderAndIsrs = (Map)tuple3._1();
            Seq partitionsWithNoLeaderAndIsrInZk = (Seq)tuple3._2();
            Map failedStateReads = (Map)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)leaderAndIsrs, (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failedStateReads);
            Map leaderAndIsrs2 = (Map)tuple33._1();
            Seq partitionsWithNoLeaderAndIsrInZk2 = (Seq)tuple33._2();
            Map failedStateReads2 = (Map)tuple33._3();
            Tuple2 tuple2 = leaderAndIsrs2.partition((Function1)new Serializable(this, replicaId){
                public static final long serialVersionUID = 0L;
                private final int replicaId$4;

                public final boolean apply(Tuple2<TopicPartition, LeaderAndIsr> x0$4) {
                    Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$4;
                    if (tuple2 != null) {
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                        boolean bl = leaderAndIsr.isr().contains((Object)BoxesRunTime.boxToInteger((int)this.replicaId$4));
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.replicaId$4 = replicaId$4;
                }
            });
            if (tuple2 != null) {
                Tuple2 tuple22;
                Map leaderAndIsrsWithReplica = (Map)tuple2._1();
                Map leaderAndIsrsWithoutReplica = (Map)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)leaderAndIsrsWithReplica, (Object)leaderAndIsrsWithoutReplica);
                Map leaderAndIsrsWithReplica2 = (Map)tuple23._1();
                Map leaderAndIsrsWithoutReplica2 = (Map)tuple23._2();
                Map adjustedLeaderAndIsrs = leaderAndIsrsWithReplica2.mapValues((Function1)new Serializable(this, replicaId){
                    public static final long serialVersionUID = 0L;
                    public final int replicaId$4;

                    public final LeaderAndIsr apply(LeaderAndIsr leaderAndIsr) {
                        int newLeader = this.replicaId$4 == leaderAndIsr.leader() ? LeaderAndIsr$.MODULE$.NoLeader() : leaderAndIsr.leader();
                        List adjustedIsr = leaderAndIsr.isr().size() == 1 ? leaderAndIsr.isr() : (List)leaderAndIsr.isr().filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;

                            public final boolean apply(int x$11) {
                                return this.apply$mcZI$sp(x$11);
                            }

                            public boolean apply$mcZI$sp(int x$11) {
                                return x$11 != this.$outer.replicaId$4;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        return leaderAndIsr.newLeaderAndIsr(newLeader, adjustedIsr);
                    }
                    {
                        this.replicaId$4 = replicaId$4;
                    }
                });
                KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.kafka$controller$ZkReplicaStateMachine$$controllerContext.epoch(), this.kafka$controller$ZkReplicaStateMachine$$controllerContext.epochZkVersion());
                if (updateLeaderAndIsrResult != null) {
                    Tuple3 tuple34;
                    Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
                    Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
                    Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
                    Tuple3 tuple35 = tuple34 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
                    Map successfulUpdates2 = (Map)tuple35._1();
                    Seq updatesToRetry2 = (Seq)tuple35._2();
                    Map failedUpdates2 = (Map)tuple35._3();
                    Map exceptionsForPartitionsWithNoLeaderAndIsrInZk = ((TraversableOnce)partitionsWithNoLeaderAndIsrInZk2.flatMap((Function1)new Serializable(this, replicaId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ZkReplicaStateMachine $outer;
                        private final int replicaId$4;

                        public final Iterable<Tuple2<TopicPartition, StateChangeFailedException>> apply(TopicPartition partition) {
                            Iterable iterable;
                            if (this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
                                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            } else {
                                StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to change state of replica ", " for partition ", " since the leader and isr path in zookeeper is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$4), partition})));
                                iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)exception)));
                            }
                            return iterable;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.replicaId$4 = replicaId$4;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Map leaderIsrAndControllerEpochs = (Map)leaderAndIsrsWithoutReplica2.$plus$plus((GenTraversableOnce)successfulUpdates2).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ZkReplicaStateMachine $outer;

                        public final Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicPartition, LeaderAndIsr> x0$5) {
                            Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$5;
                            if (tuple2 != null) {
                                TopicPartition partition = (TopicPartition)tuple2._1();
                                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.epoch());
                                this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    return new Tuple3((Object)leaderIsrAndControllerEpochs, (Object)updatesToRetry2, (Object)failedStateReads2.$plus$plus((GenTraversableOnce)exceptionsForPartitionsWithNoLeaderAndIsrInZk).$plus$plus((GenTraversableOnce)failedUpdates2));
                }
                throw new MatchError((Object)updateLeaderAndIsrResult);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(tuple3);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>> getTopicPartitionStatesFromZk(Seq<TopicPartition> partitions) {
        Seq<GetDataResponse> getDataResponses;
        scala.collection.mutable.Map leaderAndIsrs = Map$.MODULE$.empty();
        Buffer partitionsWithNoLeaderAndIsrInZk = (Buffer)Buffer$.MODULE$.empty();
        scala.collection.mutable.Map failed = Map$.MODULE$.empty();
        try {
            getDataResponses = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception exception) {
            void var3_3;
            void var2_2;
            void var4_4;
            partitions.foreach((Function1)new Serializable(this, (scala.collection.mutable.Map)var4_4, exception){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Map failed$1;
                private final Exception e$3;

                public final Option<Exception> apply(TopicPartition partition) {
                    return this.failed$1.put((Object)partition, (Object)this.e$3);
                }
                {
                    this.failed$1 = failed$1;
                    this.e$3 = e$3;
                }
            });
            return new Tuple3((Object)var2_2.toMap(Predef$.MODULE$.$conforms()), (Object)var3_3, (Object)var4_4.toMap(Predef$.MODULE$.$conforms()));
        }
        getDataResponses.foreach((Function1)new Serializable(this, leaderAndIsrs, partitionsWithNoLeaderAndIsrInZk, failed){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkReplicaStateMachine $outer;
            private final scala.collection.mutable.Map leaderAndIsrs$1;
            private final Buffer partitionsWithNoLeaderAndIsrInZk$1;
            private final scala.collection.mutable.Map failed$1;

            public final Object apply(GetDataResponse getDataResponse) {
                Object object;
                TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
                KeeperException.Code code = getDataResponse.resultCode();
                KeeperException.Code code2 = KeeperException.Code.OK;
                if (!(code != null ? !code.equals(code2) : code2 != null)) {
                    Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                    if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                        object = this.partitionsWithNoLeaderAndIsrInZk$1.$plus$eq((Object)partition);
                    } else {
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochOpt.get();
                        if (leaderIsrAndControllerEpoch.controllerEpoch() > this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.epoch()) {
                            StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder().append((Object)"Leader and isr path written by another controller. This probably").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"means the current controller with epoch ", " went through a soft failure and another "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.epoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"controller was elected with epoch ", ". Aborting state change by this controller"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}))).toString());
                            object = this.failed$1.put((Object)partition, (Object)exception);
                        } else {
                            object = this.leaderAndIsrs$1.put((Object)partition, (Object)leaderIsrAndControllerEpoch.leaderAndIsr());
                        }
                    }
                } else {
                    KeeperException.Code code3 = getDataResponse.resultCode();
                    KeeperException.Code code4 = KeeperException.Code.NONODE;
                    object = !(code3 != null ? !code3.equals(code4) : code4 != null) ? this.partitionsWithNoLeaderAndIsrInZk$1.$plus$eq((Object)partition) : this.failed$1.put((Object)partition, getDataResponse.resultException().get());
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderAndIsrs$1 = leaderAndIsrs$1;
                this.partitionsWithNoLeaderAndIsrInZk$1 = partitionsWithNoLeaderAndIsrInZk$1;
                this.failed$1 = failed$1;
            }
        });
        return new Tuple3((Object)leaderAndIsrs.toMap(Predef$.MODULE$.$conforms()), (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failed.toMap(Predef$.MODULE$.$conforms()));
    }

    public void kafka$controller$ZkReplicaStateMachine$$logSuccessfulTransition(int replicaId, TopicPartition partition, ReplicaState currState, ReplicaState targetState) {
        this.stateChangeLogger.withControllerEpoch(this.kafka$controller$ZkReplicaStateMachine$$controllerContext.epoch()).trace((Function0<String>)new Serializable(this, replicaId, partition, currState, targetState){
            public static final long serialVersionUID = 0L;
            private final int replicaId$2;
            private final TopicPartition partition$1;
            private final ReplicaState currState$2;
            private final ReplicaState targetState$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed state of replica ", " for partition ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$2), this.partition$1, this.currState$2, this.targetState$4}));
            }
            {
                this.replicaId$2 = replicaId$2;
                this.partition$1 = partition$1;
                this.currState$2 = currState$2;
                this.targetState$4 = targetState$4;
            }
        });
    }

    public void kafka$controller$ZkReplicaStateMachine$$logInvalidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        ReplicaState currState = this.kafka$controller$ZkReplicaStateMachine$$controllerContext.replicaState(replica);
        IllegalStateException e = new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " should be in the ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica, targetState.validPreviousStates().mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"states before moving to ", " state. Instead it is in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, currState}))).toString());
        this.kafka$controller$ZkReplicaStateMachine$$logFailedStateChange(replica, currState, targetState, e);
    }

    public void kafka$controller$ZkReplicaStateMachine$$logFailedStateChange(PartitionAndReplica replica, ReplicaState currState, ReplicaState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.kafka$controller$ZkReplicaStateMachine$$controllerContext.epoch()).error((Function0<String>)new Serializable(this, replica, currState, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkReplicaStateMachine $outer;
            private final PartitionAndReplica replica$1;
            private final ReplicaState currState$1;
            private final ReplicaState targetState$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " initiated state change of replica ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkReplicaStateMachine$$controllerContext.epoch()), BoxesRunTime.boxToInteger((int)this.replica$1.replica())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", " from ", " to ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replica$1.topicPartition(), this.currState$1, this.targetState$3}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replica$1 = replica$1;
                this.currState$1 = currState$1;
                this.targetState$3 = targetState$3;
            }
        }, (Function0<Throwable>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Throwable apply() {
                return this.t$1;
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public ZkReplicaStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.stateChangeLogger = stateChangeLogger;
        this.kafka$controller$ZkReplicaStateMachine$$controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.kafka$controller$ZkReplicaStateMachine$$controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.kafka$controller$ZkReplicaStateMachine$$controllerId = config.brokerId();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$ZkReplicaStateMachine$$controllerId())})));
    }
}

