/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogOffsetSnapshot;
import kafka.log.LogSegment;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\b\t\u0003A!j\u0011!\t\u0006\u0003E\r\naaY8n[>t'BA\u0003%\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%\n#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tW\u0001\u0011\t\u0011)A\u0005?\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0011!\u0018.\\3\u0011\u0005=\nT\"\u0001\u0019\u000b\u0005E\t\u0013B\u0001\u001a1\u0005\u0011!\u0016.\\3\t\u0011Q\u0002!\u0011!Q\u0001\nU\n\u0011$\u001b8ji&\fG\u000eS5hQ^\u000bG/\u001a:nCJ\\g+\u00197vKB\u0011\u0011BN\u0005\u0003o)\u0011A\u0001T8oO\"A\u0011\b\u0001BA\u0002\u0013\u0005!(A\u0002m_\u001e,\u0012a\u000f\t\u0004\u0013qr\u0014BA\u001f\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011q(Q\u0007\u0002\u0001*\u0011\u0011\bB\u0005\u0003\u0005\u0002\u00131\u0001T8h\u0011!!\u0005A!a\u0001\n\u0003)\u0015a\u00027pO~#S-\u001d\u000b\u0003\r&\u0003\"!C$\n\u0005!S!\u0001B+oSRDqAS\"\u0002\u0002\u0003\u00071(A\u0002yIEB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006KaO\u0001\u0005Y><\u0007\u0005\u000b\u0002L\u001dB\u0011\u0011bT\u0005\u0003!*\u0011\u0001B^8mCRLG.\u001a\u0005\u0006%\u0002!\taU\u0001\u0007y%t\u0017\u000e\u001e \u0015\rQ3v\u000bW-[!\t)\u0006!D\u0001\u0003\u0011\u0015)\u0012\u000b1\u0001\u0018\u0011\u0015i\u0012\u000b1\u0001 \u0011\u001di\u0013\u000b%AA\u00029Bq\u0001N)\u0011\u0002\u0003\u0007Q\u0007C\u0004:#B\u0005\t\u0019A\u001e\t\rq\u0003\u0001\u0015)\u0003^\u0003UA\u0017n\u001a5XCR,'/\\1sW6+G/\u00193bi\u0006\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0003\u0002\rM,'O^3s\u0013\t\u0011wLA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006D#a\u0017(\t\r\u0015\u0004\u0001\u0015)\u0003^\u0003UyFn\\4F]\u0012|eMZ:fi6+G/\u00193bi\u0006D#\u0001\u001a(\t\r!\u0004\u0001\u0015)\u00036\u0003=yFn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bFA4O\u0011\u0019Y\u0007\u0001)Q\u0005k\u0005YB.Y:u\r\u0016$8\r\u001b'fC\u0012,'\u000fT8h\u000b:$wJ\u001a4tKRD#A\u001b(\t\r9\u0004\u0001\u0015)\u00036\u0003=a\u0017m\u001d;GKR\u001c\u0007\u000eV5nK6\u001b\bFA7O\u0011\u0019\t\b\u0001)Q\u0005k\u0005\u0019r\f\\1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3Ng\"\u0012\u0001O\u0014\u0005\u0006i\u0002!\t!^\u0001\bSNdunY1m+\u00051\bCA\u0005x\u0013\tA(BA\u0004C_>dW-\u00198\t\u000bi\u0004A\u0011A>\u0002%1\f7\u000f^\"bk\u001eDG/\u00169US6,Wj]\u000b\u0002k!)Q\u0010\u0001C\u0001}\u0006\u0019R\u000f\u001d3bi\u0016dun\u001a*fC\u0012\u0014Vm];miR\u0011ai \u0005\b\u0003\u0003a\b\u0019AA\u0002\u00035awn\u001a*fC\u0012\u0014Vm];miB\u0019a,!\u0002\n\u0007\u0005\u001dqLA\u0007M_\u001e\u0014V-\u00193SKN,H\u000e\u001e\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003U\u0011Xm]3u\u0019\u0006\u001cHoQ1vO\"$X\u000b\u001d+j[\u0016$rARA\b\u0003'\t9\u0002C\u0004\u0002\u0012\u0005%\u0001\u0019A\u001b\u0002+\r,(\u000fT3bI\u0016\u0014Hj\\4F]\u0012|eMZ:fi\"9\u0011QCA\u0005\u0001\u0004)\u0014!C2veRKW.Z't\u0011\u0019Q\u0018\u0011\u0002a\u0001k!9\u00111\u0004\u0001\u0005\n\u0005u\u0011\u0001\u00077pO\u0016sGm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018m\u0018\u0013fcR\u0019a)a\b\t\u000f\u0005\u0005\u0012\u0011\u0004a\u0001;\u0006ya.Z<M_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0002&\u0001!\t!a\n\u0002\u00171\fG/Z:u\u000bB|7\r[\u000b\u0003\u0003S\u00012!\u0003\u001f\u0018\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\t\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0011\t\t$!\u000f\u0011\t%a\u00141\u0007\t\u0004=\u0006U\u0012bAA\u001c?\nqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBA\u001e\u0003W\u0001\raF\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002@\u0001!\t!!\u0011\u0002)1|w-\u00128e\u001f\u001a47/\u001a;NKR\fG-\u0019;b+\u0005i\u0006BBA#\u0001\u0011\u000510\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0002J\u0001!\t!a\u0013\u000295\f\u0017PY3J]\u000e\u0014X-\\3oi2{wm\u0015;beR|eMZ:fiR\u0019a)!\u0014\t\u000f\u0005=\u0013q\ta\u0001k\u0005\tb.Z<M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V\u0005\u0011Bn\\4Ti\u0006\u0014Ho\u00144gg\u0016$x\fJ3r)\r1\u0015q\u000b\u0005\b\u0003\u001f\n\t\u00061\u00016\u0011\u0019\tY\u0006\u0001C\u0001w\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bbBA0\u0001\u0011\u0005\u0011\u0011M\u0001\u0012Q&<\u0007nV1uKJl\u0017M]6`I\u0015\fHc\u0001$\u0002d!9\u0011QMA/\u0001\u0004i\u0016\u0001\u00058fo\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0011\u001d\tI\u0007\u0001C\u0001\u0003\u0003\nQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007bBA7\u0001\u0011\u0005\u0011\u0011I\u0001\u0011Y\u0006\u001cHo\u0015;bE2,wJ\u001a4tKRDq!!\u001d\u0001\t\u0003\t\u0019(\u0001\u0010d_:4XM\u001d;I/R{Gj\\2bY>3gm]3u\u001b\u0016$\u0018\rZ1uCR\ta\tC\u0004\u0002x\u0001!\t!!\u001f\u0002\u001d=4gm]3u':\f\u0007o\u001d5piV\u0011\u00111\u0010\t\u0004\u007f\u0005u\u0014bAA@\u0001\n\tBj\\4PM\u001a\u001cX\r^*oCB\u001c\bn\u001c;\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\u00061Q-];bYN$2A^AD\u0011!\tI)!!A\u0002\u0005-\u0015\u0001\u0002;iCR\u00042!CAG\u0013\r\tyI\u0003\u0002\u0004\u0003:L\bbBAJ\u0001\u0011\u0005\u0013QS\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0003C\u0004\u0002\u001a\u0002!\t%a'\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!(\u0011\t\u0005}\u0015Q\u0015\b\u0004\u0013\u0005\u0005\u0016bAAR\u0015\u00051\u0001K]3eK\u001aLA!a*\u0002*\n11\u000b\u001e:j]\u001eT1!a)\u000b\u000f%\tiKAA\u0001\u0012\u0003\ty+A\u0004SKBd\u0017nY1\u0011\u0007U\u000b\tL\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAZ'\r\t\t\f\u0003\u0005\b%\u0006EF\u0011AA\\)\t\ty\u000b\u0003\u0006\u0002<\u0006E\u0016\u0013!C\u0001\u0003{\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA`U\rq\u0013\u0011Y\u0016\u0003\u0003\u0007\u0004B!!2\u0002P6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001a\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0006\u001d'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011Q[AY#\u0003%\t!a6\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\tINK\u00026\u0003\u0003D!\"!8\u00022F\u0005I\u0011AAp\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u001d\u0016\u0004w\u0005\u0005\u0007")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    public final long kafka$cluster$Replica$$initialHighWatermarkValue;
    private volatile Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    public volatile LogOffsetMetadata kafka$cluster$Replica$$_logEndOffsetMetadata;
    private volatile long _logStartOffset;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public void log_$eq(Option<Log> x$1) {
        this.log = x$1;
    }

    public boolean isLocal() {
        return this.log().isDefined();
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= logReadResult.leaderLogEndOffset()) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, logReadResult.fetchTimeMs());
        } else if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this.lastFetchTimeMs);
        }
        this.logStartOffset_$eq(logReadResult.followerLogStartOffset());
        this.logEndOffsetMetadata_$eq(logReadResult.info().fetchOffsetMetadata());
        this.lastFetchLeaderLogEndOffset = logReadResult.leaderLogEndOffset();
        this.lastFetchTimeMs = logReadResult.fetchTimeMs();
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this.lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
    }

    private void logEndOffsetMetadata_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log end offset on partition ", "'s local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.kafka$cluster$Replica$$_logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log end offset for replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topicPartition(), this.$outer.kafka$cluster$Replica$$_logEndOffsetMetadata}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> latestEpoch() {
        if (this.isLocal()) {
            return ((Log)this.log().get()).latestEpoch();
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot get latest epoch of non-local replica of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
    }

    public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
        if (this.isLocal()) {
            return ((Log)this.log().get()).endOffsetForEpoch(leaderEpoch);
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot lookup end offset for epoch of non-local replica of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.kafka$cluster$Replica$$_logEndOffsetMetadata;
    }

    public long logEndOffset() {
        return this.logEndOffsetMetadata().messageOffset();
    }

    public void maybeIncrementLogStartOffset(long newLogStartOffset) {
        if (this.isLocal()) {
            if (newLogStartOffset > this.highWatermark().messageOffset()) {
                throw new OffsetOutOfRangeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot increment the log start offset to ", " of partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset), this.topicPartition()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since it is larger than the high watermark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.highWatermark().messageOffset())}))).toString());
            }
            ((Log)this.log().get()).maybeIncrementLogStartOffset(newLogStartOffset);
            return;
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not try to delete records on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    private void logStartOffset_$eq(long newLogStartOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log start offset on partition ", "'s local replica ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"without attempting to delete records of the log"})).s((Seq)Nil$.MODULE$)).toString());
        }
        this._logStartOffset = newLogStartOffset;
        this.trace((Function0<String>)new Serializable(this, newLogStartOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;
            private final long newLogStartOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log start offset for remote replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topicPartition(), BoxesRunTime.boxToLong((long)this.newLogStartOffset$1)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newLogStartOffset$1 = newLogStartOffset$1;
            }
        });
    }

    public long logStartOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logStartOffset() : this._logStartOffset;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (this.isLocal()) {
            if (newHighWatermark.messageOffset() < 0L) {
                throw new IllegalArgumentException("High watermark offset should be non-negative");
            }
            this.highWatermarkMetadata = newHighWatermark;
            this.log().foreach((Function1)new Serializable(this, newHighWatermark){
                public static final long serialVersionUID = 0L;
                private final LogOffsetMetadata newHighWatermark$1;

                public final void apply(Log x$2) {
                    x$2.onHighWatermarkIncremented(this.newHighWatermark$1.messageOffset());
                }
                {
                    this.newHighWatermark$1 = newHighWatermark$1;
                }
            });
            this.trace((Function0<String>)new Serializable(this, newHighWatermark){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Replica $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting high watermark for replica ", " partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topicPartition(), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = newHighWatermark$1;
                }
            });
            return;
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public LogOffsetMetadata lastStableOffset() {
        return (LogOffsetMetadata)this.log().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final LogOffsetMetadata apply(Log log) {
                Some some;
                LogOffsetMetadata offsetMetadata;
                Option<LogOffsetMetadata> option = log.firstUnstableOffset();
                LogOffsetMetadata logOffsetMetadata = option instanceof Some && (offsetMetadata = (LogOffsetMetadata)(some = (Some)option).x()).messageOffset() < this.$outer.highWatermark().messageOffset() ? offsetMetadata : this.$outer.highWatermark();
                return logOffsetMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final Nothing$ apply() {
                throw new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot fetch last stable offset on partition ", "'s "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicPartition()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId())}))).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void convertHWToLocalOffsetMetadata() {
        if (this.isLocal()) {
            this.highWatermarkMetadata = (LogOffsetMetadata)((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset()).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Replica $outer;

                public final LogOffsetMetadata apply() {
                    return (LogOffsetMetadata)((Log)this.$outer.log().get()).convertToOffsetMetadata(this.$outer.logStartOffset()).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$convertHWToLocalOffsetMetadata$1 $outer;

                        public final LogOffsetMetadata apply() {
                            long firstSegmentOffset = ((LogSegment)((Log)this.$outer.kafka$cluster$Replica$$anonfun$$$outer().log().get()).logSegments().head()).baseOffset();
                            return new LogOffsetMetadata(firstSegmentOffset, firstSegmentOffset, 0);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ Replica kafka$cluster$Replica$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not construct complete high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    public LogOffsetSnapshot offsetSnapshot() {
        return new LogOffsetSnapshot(this.logStartOffset(), this.logEndOffsetMetadata(), this.highWatermark(), this.lastStableOffset());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"Replica(replicaId=").append((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString());
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition().topic()})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", partition=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.topicPartition().partition())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", isLocal=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.isLocal())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastCaughtUpTimeMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastCaughtUpTimeMs())})));
        if (this.isLocal()) {
            replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", highWatermark=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.highWatermark()})));
            boxedUnit = replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastStableOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lastStableOffset()})));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        replicaString.append(")");
        return replicaString.toString();
    }

    public Replica(int brokerId, TopicPartition topicPartition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.kafka$cluster$Replica$$initialHighWatermarkValue = initialHighWatermarkValue;
        this.log = log;
        Logging$class.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.kafka$cluster$Replica$$_logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this._logStartOffset = Log$.MODULE$.UnknownLogStartOffset();
        this.lastFetchLeaderLogEndOffset = 0L;
        this.lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica loaded for partition ", " with initial high watermark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicPartition(), BoxesRunTime.boxToLong((long)this.$outer.kafka$cluster$Replica$$initialHighWatermarkValue)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.log().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final void apply(Log x$1) {
                x$1.onHighWatermarkIncremented(this.$outer.kafka$cluster$Replica$$initialHighWatermarkValue);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

