/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r]a\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001B\u0004\u000b\u001b!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u00059Q.\u001a;sS\u000e\u001c\u0018BA\r\u0017\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0011\taa]3sm\u0016\u0014\u0018BA\u0010\u001d\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\"A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0007j]&$\u0018.\u00197D_:4\u0017n\u001a\t\u0003G\u0011j\u0011AA\u0005\u0003K\t\u0011Qb\u00117fC:,'oQ8oM&<\u0007\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0015\u0002\u000f1|w\rR5sgV\t\u0011\u0006E\u0002+eUr!a\u000b\u0019\u000f\u00051zS\"A\u0017\u000b\u000592\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t\t$\"A\u0004qC\u000e\\\u0017mZ3\n\u0005M\"$aA*fc*\u0011\u0011G\u0003\t\u0003mmj\u0011a\u000e\u0006\u0003qe\n!![8\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\u0005\r&dW\r\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003*\u0003!awn\u001a#jeN\u0004\u0003\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011A!\u0002\t1|wm]\u000b\u0002\u0005B!qbQ#Q\u0013\t!\u0005C\u0001\u0003Q_>d\u0007C\u0001$O\u001b\u00059%B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011QA\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\u000f\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u0012R\u0013\t\u0011&AA\u0002M_\u001eD\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0006Y><7\u000f\t\u0005\t-\u0002\u0011)\u0019!C\u0001/\u0006!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\u0012\u0001\u0017\t\u00037eK!A\u0017\u000f\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0011!a\u0006A!A!\u0002\u0013A\u0016!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\t\u0005\t=\u0002\u0011\t\u0011)A\u0005?\u0006!A/[7f!\t\u0001'-D\u0001b\u0015\t\tr)\u0003\u0002dC\n!A+[7f\u0011\u0015)\u0007\u0001\"\u0001g\u0003\u0019a\u0014N\\5u}Q1q\r[5kW2\u0004\"a\t\u0001\t\u000b\u0005\"\u0007\u0019\u0001\u0012\t\u000b\u001d\"\u0007\u0019A\u0015\t\u000b\u0001#\u0007\u0019\u0001\"\t\u000bY#\u0007\u0019\u0001-\t\u000fy#\u0007\u0013!a\u0001?\"9a\u000e\u0001a\u0001\n\u0013y\u0017AB2p]\u001aLw-F\u0001#\u0011\u001d\t\b\u00011A\u0005\nI\f!bY8oM&<w\fJ3r)\t\u0019h\u000f\u0005\u0002\ni&\u0011QO\u0003\u0002\u0005+:LG\u000fC\u0004xa\u0006\u0005\t\u0019\u0001\u0012\u0002\u0007a$\u0013\u0007\u0003\u0004z\u0001\u0001\u0006KAI\u0001\bG>tg-[4!Q\tA8\u0010\u0005\u0002\ny&\u0011QP\u0003\u0002\tm>d\u0017\r^5mK\"Iq\u0010\u0001b\u0001\n\u0003\u0011\u0011\u0011A\u0001\u000fG2,\u0017M\\3s\u001b\u0006t\u0017mZ3s+\t\t\u0019\u0001E\u0002$\u0003\u000bI1!a\u0002\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\t\u0003\u0017\u0001\u0001\u0015!\u0003\u0002\u0004\u0005y1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012\u0005IA\u000f\u001b:piRdWM]\u000b\u0003\u0003'\u00012aDA\u000b\u0013\r\t9\u0002\u0005\u0002\n)\"\u0014x\u000e\u001e;mKJD\u0001\"a\u0007\u0001A\u0003%\u00111C\u0001\u000bi\"\u0014x\u000e\u001e;mKJ\u0004\u0003\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0003!\u0019G.Z1oKJ\u001cXCAA\u0012!\u0019\t)#a\f\u000245\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0004nkR\f'\r\\3\u000b\u0007\u00055\"\"\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002(\tY\u0011I\u001d:bs\n+hMZ3s!\u0011\t)$a\u000e\u000e\u0003\u00011a!!\u000f\u0001\t\u0005m\"!D\"mK\u0006tWM\u001d+ie\u0016\fGm\u0005\u0003\u00028\u0005u\u0002cA\b\u0002@%\u0019\u0011\u0011\t\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\f\u0003\u000b\n9D!A!\u0002\u0013\t9%\u0001\u0005uQJ,\u0017\rZ%e!\rI\u0011\u0011J\u0005\u0004\u0003\u0017R!aA%oi\"9Q-a\u000e\u0005\u0002\u0005=C\u0003BA\u001a\u0003#B\u0001\"!\u0012\u0002N\u0001\u0007\u0011q\t\u0005\t\u0003+\n9\u0004\"\u0015\u0002X\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}\u0013(\u0001\u0003mC:<\u0017\u0002BA2\u0003;\u0012aa\u0015;sS:<\u0007BCA4\u0003o\u0011\r\u0011\"\u0001\u0002j\u000591\r\\3b]\u0016\u0014XCAA6!\r\u0019\u0013QN\u0005\u0004\u0003_\u0012!aB\"mK\u0006tWM\u001d\u0005\n\u0003g\n9\u0004)A\u0005\u0003W\n\u0001b\u00197fC:,'\u000f\t\u0005\u000b\u0003o\n9\u00041A\u0005\u0002\u0005e\u0014!\u00037bgR\u001cF/\u0019;t+\t\tY\bE\u0002$\u0003{J1!a \u0003\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0011)\t\u0019)a\u000eA\u0002\u0013\u0005\u0011QQ\u0001\u000eY\u0006\u001cHo\u0015;biN|F%Z9\u0015\u0007M\f9\tC\u0005x\u0003\u0003\u000b\t\u00111\u0001\u0002|!I\u00111RA\u001cA\u0003&\u00111P\u0001\u000bY\u0006\u001cHo\u0015;biN\u0004\u0003fAAEw\"Q\u0011\u0011SA\u001c\u0001\u0004%\t!a%\u0002#1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8/\u0006\u0002\u0002\u0016B\u00191%a&\n\u0007\u0005e%AA\u0007Qe\u0016\u001cE.Z1o'R\fGo\u001d\u0005\u000b\u0003;\u000b9\u00041A\u0005\u0002\u0005}\u0015!\u00067bgR\u0004&/Z\"mK\u0006t7\u000b^1ug~#S-\u001d\u000b\u0004g\u0006\u0005\u0006\"C<\u0002\u001c\u0006\u0005\t\u0019AAK\u0011%\t)+a\u000e!B\u0013\t)*\u0001\nmCN$\bK]3DY\u0016\fgn\u0015;biN\u0004\u0003fAARw\"A\u00111VA\u001c\t\u0013\ti+A\u0005dQ\u0016\u001c7\u000eR8oKR\u00191/a,\t\u000f\u0005E\u0016\u0011\u0016a\u0001\u000b\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002CA[\u0003o!\t%a.\u0002\r\u0011|wk\u001c:l)\u0005\u0019\b\u0002CA^\u0003o!I!!0\u0002#\rdW-\u00198GS2$\b.[3ti2{w\r\u0006\u0002\u0002@B\u0019\u0011\"!1\n\u0007\u0005\r'BA\u0004C_>dW-\u00198\t\u0011\u0005\u001d\u0017q\u0007C\u0005\u0003\u0013\f\u0001b\u00197fC:dun\u001a\u000b\u0004g\u0006-\u0007\u0002CAg\u0003\u000b\u0004\r!a4\u0002\u0013\rdW-\u00198bE2,\u0007cA\u0012\u0002R&\u0019\u00111\u001b\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002X\u0006]B\u0011AAm\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0017M\fY.a8\u0002p\u0006e\u0018Q \u0005\t\u0003;\f)\u000e1\u0001\u0002H\u0005\u0011\u0011\u000e\u001a\u0005\t\u0003C\f)\u000e1\u0001\u0002d\u0006!a.Y7f!\u0011\t)/a;\u000f\u0007%\t9/C\u0002\u0002j*\ta\u0001\u0015:fI\u00164\u0017\u0002BA2\u0003[T1!!;\u000b\u0011!\t\t0!6A\u0002\u0005M\u0018\u0001\u00024s_6\u00042!CA{\u0013\r\t9P\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0002|\u0006U\u0007\u0019AAz\u0003\t!x\u000e\u0003\u0005\u0002\u0000\u0006U\u0007\u0019AA>\u0003\u0015\u0019H/\u0019;t\u0011!\u0011\u0019\u0001\u0001Q\u0001\n\u0005\r\u0012!C2mK\u0006tWM]:!\u0011\u001d\u00119\u0001\u0001C\u0001\u0003o\u000bqa\u001d;beR,\b\u000fC\u0004\u0003\f\u0001!\t!a.\u0002\u0011MDW\u000f\u001e3po:DqAa\u0004\u0001\t\u0003\u0012\t\"A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\tM\u0001C\u0002B\u000b\u0005/\t\u0019/\u0004\u0002\u0002,%!!\u0011DA\u0016\u0005\r\u0019V\r\u001e\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000eF\u0002t\u0005CA\u0001Ba\t\u0003\u001c\u0001\u0007!QE\u0001\n]\u0016<8i\u001c8gS\u001e\u00042a\u0007B\u0014\u0013\r\u0011I\u0003\b\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0004\u0003.\u0001!\tEa\f\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0006g\nE\"Q\u0007\u0005\t\u0005g\u0011Y\u00031\u0001\u0003&\u0005Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\t\u0005G\u0011Y\u00031\u0001\u0003&!9!\u0011\b\u0001\u0005\u0002\tm\u0012!D1c_J$8\t\\3b]&tw\rF\u0002t\u0005{Aq!!-\u00038\u0001\u0007Q\tC\u0004\u0003B\u0001!\tAa\u0011\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000fF\u0002t\u0005\u000bBqAa\u0012\u0003@\u0001\u0007Q'A\u0004eCR\fG)\u001b:\t\u000f\t-\u0003\u0001\"\u0001\u0003N\u0005\u0011\u0012\r\u001c;fe\u000eCWmY6q_&tG\u000fR5s)\u001d\u0019(q\nB)\u0005+Bq!!-\u0003J\u0001\u0007Q\tC\u0004\u0003T\t%\u0003\u0019A\u001b\u0002\u0019M|WO]2f\u0019><G)\u001b:\t\u000f\t]#\u0011\na\u0001k\u0005QA-Z:u\u0019><G)\u001b:\t\u000f\tm\u0003\u0001\"\u0001\u0003^\u0005\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR\u00191Oa\u0018\t\u0011\t\u0005$\u0011\fa\u0001\u0003G\f1\u0001Z5s\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005O\nq#\\1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;\u0015\u000fM\u0014IGa\u001b\u0003n!9!q\tB2\u0001\u0004)\u0004bBAY\u0005G\u0002\r!\u0012\u0005\t\u0005_\u0012\u0019\u00071\u0001\u0002t\u00061qN\u001a4tKRDqAa\u001d\u0001\t\u0003\u0011)(A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\u0007M\u00149\bC\u0004\u00022\nE\u0004\u0019A#\t\u000f\tm\u0004\u0001\"\u0001\u0003~\u0005q!/Z:v[\u0016\u001cE.Z1oS:<GcA:\u0003\u0000!A!\u0011\u0011B=\u0001\u0004\u0011\u0019)A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0015\u0011)B!\"F\u0013\u0011\u00119)a\u000b\u0003\u0011%#XM]1cY\u0016DqAa#\u0001\t\u0003\u0011i)\u0001\u0007bo\u0006LGo\u00117fC:,G\r\u0006\u0005\u0002@\n=%\u0011\u0013BJ\u0011\u001d\t\tL!#A\u0002\u0015C\u0001Ba\u001c\u0003\n\u0002\u0007\u00111\u001f\u0005\u000b\u0005+\u0013I\t%AA\u0002\u0005M\u0018!C7bq^\u000b\u0017\u000e^'t\u0011\u001d\u0011I\n\u0001C\u0001\u00057\u000ba\u0005]1vg\u0016\u001cE.Z1oS:<gi\u001c:O_:\u001cu.\u001c9bGR,G\rU1si&$\u0018n\u001c8t)\t\u0011i\n\u0005\u0004\u0003\u0016\t\u0015%q\u0014\t\u0006\u0013\t\u0005V\tU\u0005\u0004\u0005GS!A\u0002+va2,'\u0007C\u0004\u0003(\u0002!\t\u0001B8\u0002\u001b\r,(O]3oi\u000e{gNZ5h\u0011!\u0011Y\u000b\u0001C\u0001\u0005\t5\u0016\u0001D2mK\u0006tWM]\"pk:$XCAA$\u0011%\u0011\t\fAI\u0001\n\u0003\u0011\u0019,\u0001\fbo\u0006LGo\u00117fC:,G\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)L\u000b\u0003\u0002t\n]6F\u0001B]!\u0011\u0011YL!2\u000e\u0005\tu&\u0002\u0002B`\u0005\u0003\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\r'\"\u0001\u0006b]:|G/\u0019;j_:LAAa2\u0003>\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u000f\t-'\u0001#\u0001\u0003N\u0006QAj\\4DY\u0016\fg.\u001a:\u0011\u0007\r\u0012yM\u0002\u0004\u0002\u0005!\u0005!\u0011[\n\u0004\u0005\u001fD\u0001bB3\u0003P\u0012\u0005!Q\u001b\u000b\u0003\u0005\u001bD!B!7\u0003P\n\u0007I\u0011\u0001Bn\u0003U\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"A!8\u0011\r\tU!qCA-\u0011%\u0011\tOa4!\u0002\u0013\u0011i.\u0001\fSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!\u0011!\u0011)Oa4\u0005\u0002\t\u001d\u0018!D2mK\u0006tWM]\"p]\u001aLw\rF\u0002#\u0005SDqA\u001cBr\u0001\u0004\u0011)\u0003\u0003\u0005\u0003n\n=G\u0011\u0001Bx\u0003]\u0019'/Z1uK:+wo\u00117fC:,GmU3h[\u0016tG\u000f\u0006\u0004\u0003r\n](\u0011 \t\u0004G\tM\u0018b\u0001B{\u0005\tQAj\\4TK\u001elWM\u001c;\t\r\r\u0011Y\u000f1\u0001Q\u0011!\u0011YPa;A\u0002\u0005M\u0018A\u00032bg\u0016|eMZ:fi\"A!q Bh\t\u0003\u0019\t!A\fdC2\u001cW\u000f\\1uK\u000ecW-\u00198bE2,')\u001f;fgRA11AB\u0003\u0007\u000f\u0019Y\u0001E\u0004\n\u0005C\u000b\u00190a=\t\r\r\u0011i\u00101\u0001Q\u0011!\u0019IA!@A\u0002\u0005M\u0018\u0001\u00054jeN$H)\u001b:us>3gm]3u\u0011!\u0019iA!@A\u0002\u0005M\u0018!E;oG2,\u0017M\\1cY\u0016|eMZ:fi\"Q1\u0011\u0003Bh#\u0003%\taa\u0005\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019)BK\u0002`\u0005o\u0003")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static Tuple2<Object, Object> calculateCleanableBytes(Log log, long l, long l2) {
        return LogCleaner$.MODULE$.calculateCleanableBytes(log, l, l2);
    }

    public static LogSegment createNewCleanedSegment(Log log, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(log, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleaner $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                CleanerThread cleaner = this.$outer.new CleanerThread(i);
                this.$outer.kafka$log$LogCleaner$$cleaners().$plus$eq((Object)cleaner);
                cleaner.start();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$10) {
                x$10.shutdown();
            }
        });
        this.kafka$log$LogCleaner$$cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        CleanerConfig newCleanerConfig = LogCleaner$.MODULE$.cleanerConfig(newConfig);
        int numThreads = newCleanerConfig.numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads should be at least 1"})).s((Seq)Nil$.MODULE$));
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads cannot be reduced to less than half the current value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentThreads)})));
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads cannot be increased to more than double the current value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentThreads)})));
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset2) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset2);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset2, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset2) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset2);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.kafka$log$LogCleaner$$cleaners().size();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, (Function1)new Serializable(this, offset$1){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(long x$11) {
                return this.apply$mcZJ$sp(x$11);
            }

            public boolean apply$mcZJ$sp(long x$11) {
                return x$11 >= this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        }));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$1) {
                        return x$1.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$2) {
                        return (double)100 * x$2.bufferUtilization();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                ArrayBuffer stats = (ArrayBuffer)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$3) {
                        return x$3.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$4) {
                        return x$4.bytesWritten();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$5) {
                        return x$5.bytesRead();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$6) {
                        return x$6.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$7) {
                        return x$7.elapsedSecs();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return Math.max(0, (int)(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PreCleanStats apply(CleanerThread x$8) {
                        return x$8.lastPreCleanStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(PreCleanStats x$9) {
                        return x$9.maxCompactionDelayMs();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) / 1000L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        public void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicPartition topicPartition) {
            if (this.isRunning()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        @Override
        public void doWork() {
            boolean cleaned = this.cleanFilthiestLog();
            if (!cleaned) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean cleanFilthiestLog() {
            Throwable throwable3;
            block8: {
                boolean bl;
                block7: {
                    ObjectRef currentLog = ObjectRef.create((Object)None$.MODULE$);
                    try {
                        Option<LogToClean> option;
                        block11: {
                            boolean bl2;
                            block10: {
                                PreCleanStats preCleanStats;
                                block9: {
                                    preCleanStats = new PreCleanStats();
                                    option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
                                    if (!None$.MODULE$.equals(option)) break block9;
                                    bl2 = false;
                                    break block10;
                                }
                                if (!(option instanceof Some)) break block11;
                                Some some = (Some)option;
                                LogToClean cleanable = (LogToClean)some.x();
                                this.lastPreCleanStats_$eq(preCleanStats);
                                currentLog.elem = new Some((Object)cleanable.log());
                                this.cleanLog(cleanable);
                                bl2 = true;
                            }
                            boolean cleaned = bl2;
                            Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                            try {
                                deletable.foreach((Function1)new Serializable(this, currentLog){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef currentLog$1;

                                    public final int apply(Tuple2<TopicPartition, Log> x0$1) {
                                        Tuple2<TopicPartition, Log> tuple2 = x0$1;
                                        if (tuple2 != null) {
                                            Log log = (Log)tuple2._2();
                                            this.currentLog$1.elem = new Some((Object)log);
                                            int n = log.deleteOldSegments();
                                            return n;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        this.currentLog$1 = currentLog$1;
                                    }
                                });
                                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final TopicPartition apply(Tuple2<TopicPartition, Log> x$12) {
                                        return (TopicPartition)x$12._1();
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())));
                                bl = cleaned;
                                break block7;
                            }
                            catch (Throwable throwable2) {
                                void var14_8;
                                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)var14_8.map((Function1)new /* invalid duplicate definition of identical inner class */, Iterable$.MODULE$.canBuildFrom())));
                                throw throwable2;
                            }
                        }
                        throw new MatchError(option);
                    }
                    catch (Throwable throwable3) {
                        boolean bl3;
                        Throwable throwable4 = throwable3;
                        boolean bl4 = throwable4 instanceof ThreadShutdownException ? true : throwable4 instanceof ControlThrowable;
                        if (bl4) {
                            throw throwable4;
                        }
                        if (!(throwable4 instanceof Exception)) break block8;
                        Exception exception = (Exception)throwable4;
                        if (((Option)currentLog.elem).isEmpty()) {
                            throw new IllegalStateException("currentLog cannot be empty on an unexpected exception", exception);
                        }
                        Log erroneousLog = (Log)((Option)currentLog.elem).get();
                        this.warn((Function0<String>)new Serializable(this, erroneousLog){
                            public static final long serialVersionUID = 0L;
                            private final Log erroneousLog$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected exception thrown when cleaning log ", ". Marking its partition (", ") as uncleanable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.erroneousLog$1, this.erroneousLog$1.topicPartition()}));
                            }
                            {
                                this.erroneousLog$1 = erroneousLog$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, exception){
                            public static final long serialVersionUID = 0L;
                            private final Exception x10$1;

                            public final Exception apply() {
                                return this.x10$1;
                            }
                            {
                                this.x10$1 = x10$1;
                            }
                        });
                        this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(erroneousLog.dir().getParent(), erroneousLog.topicPartition());
                        bl = bl3 = false;
                    }
                }
                return bl;
            }
            throw throwable3;
        }

        private void cleanLog(LogToClean cleanable) {
            block8: {
                long endOffset = cleanable.firstDirtyOffset();
                try {
                    try {
                        Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            long nextDirtyOffset = tuple2._1$mcJ$sp();
                            CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                            long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                            CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                            this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                            endOffset = nextDirtyOffset2;
                            break block8;
                        }
                        throw new MatchError(tuple2);
                    }
                    catch (IOException iOException) {
                        String logDirectory = cleanable.log().dir().getParent();
                        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to clean up log for ", " in dir ", " due to IOException"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.topicPartition(), logDirectory}));
                        this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)new Serializable(this, msg){
                            public static final long serialVersionUID = 0L;
                            private final String msg$1;

                            public final String apply() {
                                return this.msg$1;
                            }
                            {
                                this.msg$1 = msg$1;
                            }
                        }, iOException);
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                    }
                    catch (LogCleaningAbortedException logCleaningAbortedException) {}
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
                }
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CleanerThread $outer;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.$outer.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.$outer.lastPreCleanStats().maxCompactionDelayMs())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)new Serializable(this, stats){
                    public static final long serialVersionUID = 0L;
                    private final CleanerStats stats$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.stats$1.invalidMessagesRead())}));
                    }
                    {
                        this.stats$1 = stats$1;
                    }
                });
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka-log-cleaner-thread-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threadId)})), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CleanerThread $outer;

                public final void apply(TopicPartition topicPartition) {
                    this.$outer.kafka$log$LogCleaner$CleanerThread$$checkDone(topicPartition);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

