/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import junit.framework.Assert;
import kafka.common.KafkaException;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet;
import kafka.server.OffsetCheckpoint;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"BA\u0006K+:LGoM*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002A1A\u0005\u0002e\tA\u0001^5nKV\t!\u0004\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\t\u0005)Q\u000f^5mg&\u0011q\u0004\b\u0002\t\u001b>\u001c7\u000eV5nK\"1\u0011\u0005\u0001Q\u0001\ni\tQ\u0001^5nK\u0002Bqa\t\u0001C\u0002\u0013\u0005A%A\bnCb\u0014v\u000e\u001c7J]R,'O^1m+\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#aA%oi\"1A\u0006\u0001Q\u0001\n\u0015\n\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\t\u000f9\u0002!\u0019!C\u0001I\u0005YQ.\u0019=M_\u001e\fu-Z't\u0011\u0019\u0001\u0004\u0001)A\u0005K\u0005aQ.\u0019=M_\u001e\fu-Z'tA!9!\u0007\u0001b\u0001\n\u0003\u0019\u0014!\u00037pO\u000e{gNZ5h+\u0005!\u0004C\u0001\f6\u0013\t1$AA\u0005M_\u001e\u001cuN\u001c4jO\"1\u0001\b\u0001Q\u0001\nQ\n!\u0002\\8h\u0007>tg-[4!\u0011\u001dQ\u0004\u00011A\u0005\u0002m\na\u0001\\8h\t&\u0014X#\u0001\u001f\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015AA5p\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\t\u0019KG.\u001a\u0005\b\u000b\u0002\u0001\r\u0011\"\u0001G\u0003)awn\u001a#je~#S-\u001d\u000b\u0003\u000f*\u0003\"A\n%\n\u0005%;#\u0001B+oSRDqa\u0013#\u0002\u0002\u0003\u0007A(A\u0002yIEBa!\u0014\u0001!B\u0013a\u0014a\u00027pO\u0012K'\u000f\t\u0005\b\u001f\u0002\u0001\r\u0011\"\u0001Q\u0003)awnZ'b]\u0006<WM]\u000b\u0002#B\u0011aCU\u0005\u0003'\n\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0011\u001d)\u0006\u00011A\u0005\u0002Y\u000ba\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002H/\"91\nVA\u0001\u0002\u0004\t\u0006BB-\u0001A\u0003&\u0011+A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001X\u0001\u0005]\u0006lW-F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001\u0007)\u0001\u0003mC:<\u0017B\u00012`\u0005\u0019\u0019FO]5oO\"1A\r\u0001Q\u0001\nu\u000bQA\\1nK\u0002BqA\u001a\u0001C\u0002\u0013\u0005q-A\rwKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006dW#\u00015\u0011\u0005\u0019J\u0017B\u00016(\u0005\u0011auN\\4\t\r1\u0004\u0001\u0015!\u0003i\u0003i1XM]=MCJ<W\rT8h\r2,8\u000f[%oi\u0016\u0014h/\u00197!\u0011\u0015q\u0007\u0001\"\u0011p\u0003\u0015\u0019X\r^+q)\u00059\u0005\"B9\u0001\t\u0003z\u0017\u0001\u0003;fCJ$un\u001e8\t\u000bM\u0004A\u0011A8\u0002\u001bQ,7\u000f^\"sK\u0006$X\rT8hQ\t\u0011X\u000f\u0005\u0002wq6\tqO\u0003\u0002\f\u001d%\u0011\u0011p\u001e\u0002\u0005)\u0016\u001cH\u000fC\u0003|\u0001\u0011\u0005q.A\u000buKN$x)\u001a;O_:,\u00050[:uK:$Hj\\4)\u0005i,\b\"\u0002@\u0001\t\u0003y\u0017A\u0007;fgR\u001cE.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001c\bFA?v\u0011\u0019\t\u0019\u0001\u0001C\u0001_\u0006\tC/Z:u\u00072,\u0017M\\;q'\u0016<W.\u001a8ugR{W*Y5oi\u0006LgnU5{K\"\u001a\u0011\u0011A;\t\r\u0005%\u0001\u0001\"\u0001p\u0003I!Xm\u001d;US6,')Y:fI\u001acWo\u001d5)\u0007\u0005\u001dQ\u000f\u0003\u0004\u0002\u0010\u0001!\ta\\\u0001\u001ai\u0016\u001cH\u000fT3bgRdu.\u00193fI\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u0002\u000eUDa!!\u0006\u0001\t\u0003y\u0017a\t;fgR$vo\u001c'pO6\u000bg.Y4feN,6/\u001b8h'\u0006lW\rR5s\r\u0006LGn\u001d\u0015\u0004\u0003')\bBBA\u000e\u0001\u0011\u0005q.\u0001\u000fuKN$8\t[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z!>Lg\u000e^:)\u0007\u0005eQ\u000f\u0003\u0004\u0002\"\u0001!\ta\\\u0001.i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\b\u000e\u0016:bS2LgnZ*mCND\u0007fAA\u0010k\"1\u0011q\u0005\u0001\u0005\u0002=\f\u0011\u0007^3tiJ+7m\u001c<fef$\u0015N]3di>\u0014\u00180T1qa&twmV5uQJ+G.\u0019;jm\u0016$\u0015N]3di>\u0014\u0018\u0010K\u0002\u0002&UDq!!\f\u0001\t\u0013\ty#\u0001\rwKJLg-_\"iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef$RaRA\u0019\u00033B\u0001\"a\r\u0002,\u0001\u0007\u0011QG\u0001\u0013i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u00028\u0005\u001d\u0013Q\n\b\u0005\u0003s\t\u0019E\u0004\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tyDB\u0001\u0007yI|w\u000e\u001e \n\u0003!J1!!\u0012(\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0013\u0002L\t\u00191+Z9\u000b\u0007\u0005\u0015s\u0005\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019\u0006B\u0001\u0007G>lWn\u001c8\n\t\u0005]\u0013\u0011\u000b\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007BB(\u0002,\u0001\u0007\u0011\u000bC\u0004\u0002^\u0001!I!a\u0018\u0002!\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014HcA)\u0002b!Q\u00111MA.!\u0003\u0005\r!!\u001a\u0002\u000f1|w\rR5sgB!a%a\u001a=\u0013\r\tIg\n\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0003[\u0002\u0011\u0013!C\u0005\u0003_\n!d\u0019:fCR,Gj\\4NC:\fw-\u001a:%I\u00164\u0017-\u001e7uIE*\"!!\u001d+\t\u0005\u0015\u00141O\u0016\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0005v]\u000eDWmY6fI*\u0019\u0011qP\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0004\u0006e$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class LogManagerTest
extends JUnit3Suite {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    public void setUp() {
        super.setUp();
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        this.logDir_$eq(this.logManager().logDirs()[0]);
    }

    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils$.MODULE$.rm(this.logDir());
        Predef$.MODULE$.refArrayOps((Object[])this.logManager().logDirs()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils$.MODULE$.rm(x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        super.tearDown();
    }

    @Test
    public void testCreateLog() {
        Log log = this.logManager().createLog(new TopicAndPartition(this.name(), 0), this.logConfig());
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
    }

    @Test
    public void testGetNonExistentLog() {
        Option log = this.logManager().getLog(new TopicAndPartition(this.name(), 0));
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        Log log = this.logManager().createLog(new TopicAndPartition(this.name(), 0), this.logConfig());
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final LongRef offset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                Log.LogAppendInfo info = this.log$1.append(set, this.log$1.append$default$2());
                this.offset$1.elem = info.lastOffset();
            }
            {
                this.log$1 = log$1;
                this.offset$1 = offset$1;
            }
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$2) {
                return x$2.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (int)1, (int)log.numberOfSegments());
        this.time().sleep(log.config().fileDeleteDelayMs() + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (int)(log.numberOfSegments() * 2), (int)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (int)0, (int)log.read(offset.elem + 1L, 1024, log.read$default$3()).messageSet().sizeInBytes());
        try {
            log.read(0L, 1024, log.read$default$3());
            throw this.fail("Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
            return;
        }
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()).sizeInBytes();
        this.logManager().shutdown();
        int x$22 = 10 * setSize;
        long x$23 = 50L * (long)setSize + 10L;
        long x$24 = this.logConfig().copy$default$2();
        long x$25 = this.logConfig().copy$default$3();
        long x$26 = this.logConfig().copy$default$4();
        long x$27 = this.logConfig().copy$default$5();
        long x$28 = this.logConfig().copy$default$7();
        int x$29 = this.logConfig().copy$default$8();
        int x$30 = this.logConfig().copy$default$9();
        int x$31 = this.logConfig().copy$default$10();
        long x$32 = this.logConfig().copy$default$11();
        long x$33 = this.logConfig().copy$default$12();
        double x$34 = this.logConfig().copy$default$13();
        boolean x$35 = this.logConfig().copy$default$14();
        boolean x$36 = this.logConfig().copy$default$15();
        int x$37 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$22, x$24, x$25, x$26, x$27, x$23, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        Log log = this.logManager().createLog(new TopicAndPartition(this.name(), 0), config);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final LongRef offset$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                Log.LogAppendInfo info = this.log$2.append(set, this.log$2.append$default$2());
                this.offset$2.elem = info.firstOffset();
            }
            {
                this.log$2 = log$2;
                this.offset$2 = offset$2;
            }
        });
        Assert.assertEquals((String)"Check we have the expected number of segments.", (int)(numMessages * setSize / config.segmentSize()), (int)log.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (int)6, (int)log.numberOfSegments());
        this.time().sleep(log.config().fileDeleteDelayMs() + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (int)(log.numberOfSegments() * 2), (int)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (int)0, (int)log.read(offset.elem + 1L, 1024, log.read$default$3()).messageSet().sizeInBytes());
        try {
            log.read(0L, 1024, log.read$default$3());
            throw this.fail("Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
            return;
        }
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        long x$38 = 1000L;
        int x$39 = this.logConfig().copy$default$1();
        long x$40 = this.logConfig().copy$default$2();
        long x$41 = this.logConfig().copy$default$3();
        long x$42 = this.logConfig().copy$default$4();
        long x$43 = this.logConfig().copy$default$6();
        long x$44 = this.logConfig().copy$default$7();
        int x$45 = this.logConfig().copy$default$8();
        int x$46 = this.logConfig().copy$default$9();
        int x$47 = this.logConfig().copy$default$10();
        long x$48 = this.logConfig().copy$default$11();
        long x$49 = this.logConfig().copy$default$12();
        double x$50 = this.logConfig().copy$default$13();
        boolean x$51 = this.logConfig().copy$default$14();
        boolean x$52 = this.logConfig().copy$default$15();
        int x$53 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$39, x$40, x$41, x$42, x$38, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        Log log = this.logManager().createLog(new TopicAndPartition(this.name(), 0), config);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$3;

            public final Log.LogAppendInfo apply(int i) {
                ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                return this.log$3.append(set, this.log$3.append$default$2());
            }
            {
                this.log$3 = log$3;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered triggered", (lastFlush != log.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        File[] dirs = (File[])((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()});
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                this.$outer.logManager().createLog(new TopicAndPartition("test", partition), this.$outer.logConfig());
                Assert.assertEquals((String)"We should have created the right number of logs", (int)(partition + 1), (int)this.$outer.logManager().allLogs().size());
                Iterable counts = (Iterable)this.$outer.logManager().allLogs().groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Log x$3) {
                        return x$3.dir().getParent();
                    }
                }).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Iterable<Log> x$4) {
                        return x$4.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            throw this.fail("Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicAndPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test-a", 1), new TopicAndPartition("test-b", 1)}))), this.logManager());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((File[])((Object[])new File[]{new File(new StringBuilder().append((Object)this.logDir().getAbsolutePath()).append((Object)File.separator).toString())}), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicAndPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test-a", 1)}))), this.logManager());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logDir_$eq(new File(new StringBuilder().append((Object)"data").append((Object)File.separator).append((Object)this.logDir().getName()).toString()));
        this.logDir().mkdirs();
        this.logDir().deleteOnExit();
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicAndPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test-a", 1)}))), this.logManager());
    }

    private void verifyCheckpointRecovery(Seq<TopicAndPartition> topicAndPartitions, LogManager logManager) {
        Seq logs = (Seq)topicAndPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final Log apply(TopicAndPartition x$5) {
                return this.$outer.logManager().createLog(x$5, this.$outer.logConfig());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Log log) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final Log log$4;

                    public final Log.LogAppendInfo apply(int i) {
                        return this.log$4.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), this.log$4.append$default$2());
                    }
                    {
                        this.log$4 = log$4;
                    }
                });
                log.flush();
            }
        });
        logManager.checkpointRecoveryPointOffsets();
        Map checkpoints = new OffsetCheckpoint(new File(this.logDir(), logManager.RecoveryPointCheckpointFile())).read();
        ((IterableLike)topicAndPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$1;

            public final void apply(Tuple2<TopicAndPartition, Log> x0$1) {
                Tuple2<TopicAndPartition, Log> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Log log = (Log)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$1 = checkpoints$1;
            }
        });
    }

    private LogManager createLogManager(File[] logDirs) {
        LogConfig x$54 = this.logConfig();
        File[] x$55 = logDirs;
        MockTime x$56 = this.time();
        CleanerConfig x$57 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager(x$55, x$54, x$57, x$56);
    }

    private File[] createLogManager$default$1() {
        return (File[])((Object[])new File[]{this.logDir()});
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 36000000;
        int x$6 = 1024;
        int x$7 = 4096;
        long x$8 = this.maxLogAgeMs();
        long x$9 = LogConfig$.MODULE$.apply$default$2();
        long x$10 = LogConfig$.MODULE$.apply$default$3();
        long x$11 = LogConfig$.MODULE$.apply$default$4();
        long x$12 = LogConfig$.MODULE$.apply$default$5();
        long x$13 = LogConfig$.MODULE$.apply$default$6();
        int x$14 = LogConfig$.MODULE$.apply$default$8();
        int x$15 = LogConfig$.MODULE$.apply$default$10();
        long x$16 = LogConfig$.MODULE$.apply$default$11();
        long x$17 = LogConfig$.MODULE$.apply$default$12();
        double x$18 = LogConfig$.MODULE$.apply$default$13();
        boolean x$19 = LogConfig$.MODULE$.apply$default$14();
        boolean x$20 = LogConfig$.MODULE$.apply$default$15();
        int x$21 = LogConfig$.MODULE$.apply$default$16();
        this.logConfig = new LogConfig(x$6, x$9, x$10, x$11, x$12, x$13, x$8, x$14, x$7, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

