/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.PayloadGenerator;

public class GaussianTimestampRandomPayloadGenerator
implements PayloadGenerator {
    private final int messageSizeAverage;
    private final int messageSizeDeviation;
    private final int messagesUntilSizeChange;
    private final long seed;
    private final Random random = new Random();
    private final ByteBuffer buffer;
    private int messageTracker = 0;
    private int messageSize = 0;

    @JsonCreator
    public GaussianTimestampRandomPayloadGenerator(@JsonProperty(value="messageSizeAverage") int messageSizeAverage, @JsonProperty(value="messageSizeDeviation") int messageSizeDeviation, @JsonProperty(value="messagesUntilSizeChange") int messagesUntilSizeChange, @JsonProperty(value="seed") long seed) {
        this.messageSizeAverage = messageSizeAverage;
        this.messageSizeDeviation = messageSizeDeviation;
        this.seed = seed;
        this.messagesUntilSizeChange = messagesUntilSizeChange;
        this.buffer = ByteBuffer.allocate(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @JsonProperty
    public int messageSizeAverage() {
        return this.messageSizeAverage;
    }

    @JsonProperty
    public long messageSizeDeviation() {
        return this.messageSizeDeviation;
    }

    @JsonProperty
    public long seed() {
        return this.seed;
    }

    @Override
    public synchronized byte[] generate(long position) {
        this.random.setSeed(this.seed + position);
        if (this.messageSize == 0 || this.messageTracker >= this.messagesUntilSizeChange) {
            this.messageTracker = 0;
            this.messageSize = Math.max((int)(this.random.nextGaussian() * (double)this.messageSizeDeviation) + this.messageSizeAverage, 8);
        }
        ++this.messageTracker;
        byte[] result = new byte[this.messageSize];
        this.random.nextBytes(result);
        this.buffer.clear();
        this.buffer.putLong(Time.SYSTEM.milliseconds());
        this.buffer.rewind();
        System.arraycopy(this.buffer.array(), 0, result, 0, 8);
        return result;
    }
}

