/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.kafka.trogdor.coordinator.Coordinator;
import org.apache.kafka.trogdor.rest.CoordinatorShutdownRequest;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateTaskRequest;
import org.apache.kafka.trogdor.rest.DestroyTaskRequest;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.StopTaskRequest;
import org.apache.kafka.trogdor.rest.TasksRequest;
import org.apache.kafka.trogdor.rest.TasksResponse;

@Path(value="/coordinator")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CoordinatorRestResource {
    private final AtomicReference<Coordinator> coordinator = new AtomicReference();
    @Context
    private ServletContext context;

    public void setCoordinator(Coordinator myCoordinator) {
        this.coordinator.set(myCoordinator);
    }

    @GET
    @Path(value="/status")
    public CoordinatorStatusResponse status() throws Throwable {
        return this.coordinator().status();
    }

    @POST
    @Path(value="/task/create")
    public Empty createTask(CreateTaskRequest request) throws Throwable {
        this.coordinator().createTask(request);
        return Empty.INSTANCE;
    }

    @PUT
    @Path(value="/task/stop")
    public Empty stopTask(StopTaskRequest request) throws Throwable {
        this.coordinator().stopTask(request);
        return Empty.INSTANCE;
    }

    @DELETE
    @Path(value="/tasks")
    public Empty destroyTask(@DefaultValue(value="") @QueryParam(value="taskId") String taskId) throws Throwable {
        this.coordinator().destroyTask(new DestroyTaskRequest(taskId));
        return Empty.INSTANCE;
    }

    @GET
    @Path(value="/tasks")
    public TasksResponse tasks(@QueryParam(value="taskId") List<String> taskId, @DefaultValue(value="0") @QueryParam(value="firstStartMs") int firstStartMs, @DefaultValue(value="0") @QueryParam(value="lastStartMs") int lastStartMs, @DefaultValue(value="0") @QueryParam(value="firstEndMs") int firstEndMs, @DefaultValue(value="0") @QueryParam(value="lastEndMs") int lastEndMs) throws Throwable {
        return this.coordinator().tasks(new TasksRequest(taskId, firstStartMs, lastStartMs, firstEndMs, lastEndMs));
    }

    @PUT
    @Path(value="/shutdown")
    public Empty beginShutdown(CoordinatorShutdownRequest request) throws Throwable {
        this.coordinator().beginShutdown(request.stopAgents());
        return Empty.INSTANCE;
    }

    private Coordinator coordinator() {
        Coordinator myCoordinator = this.coordinator.get();
        if (myCoordinator == null) {
            throw new RuntimeException("CoordinatorRestResource has not been initialized yet.");
        }
        return myCoordinator;
    }
}

