/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.quality.Strictness;

public final class StreamsTestUtils {
    private StreamsTestUtils() {
    }

    public static Properties getStreamsConfig(String applicationId, String bootstrapServers, String keySerdeClassName, String valueSerdeClassName, Properties additional) {
        Properties props = new Properties();
        props.put("application.id", applicationId);
        props.put("bootstrap.servers", bootstrapServers);
        props.put("default.key.serde", keySerdeClassName);
        props.put("default.value.serde", valueSerdeClassName);
        props.put("state.dir", TestUtils.tempDirectory().getPath());
        props.put("metrics.recording.level", Sensor.RecordingLevel.DEBUG.name);
        props.putAll((Map<?, ?>)additional);
        return props;
    }

    public static Properties getStreamsConfig(String applicationId, String bootstrapServers, Properties additional) {
        Properties props = new Properties();
        props.put("application.id", applicationId);
        props.put("bootstrap.servers", bootstrapServers);
        props.put("state.dir", TestUtils.tempDirectory().getPath());
        props.put("metrics.recording.level", Sensor.RecordingLevel.DEBUG.name);
        props.putAll((Map<?, ?>)additional);
        return props;
    }

    public static Properties getStreamsConfig(Serde<?> keyDeserializer, Serde<?> valueDeserializer) {
        return StreamsTestUtils.getStreamsConfig(UUID.randomUUID().toString(), "localhost:9091", keyDeserializer.getClass().getName(), valueDeserializer.getClass().getName(), new Properties());
    }

    public static Properties getStreamsConfig(String applicationId) {
        return StreamsTestUtils.getStreamsConfig(applicationId, new Properties());
    }

    public static Properties getStreamsConfig(String applicationId, Properties additional) {
        return StreamsTestUtils.getStreamsConfig(applicationId, "localhost:9091", additional);
    }

    public static Properties getStreamsConfig() {
        return StreamsTestUtils.getStreamsConfig(UUID.randomUUID().toString());
    }

    public static <K, V> List<KeyValue<K, V>> toList(Iterator<KeyValue<K, V>> iterator) {
        ArrayList<KeyValue<K, V>> results = new ArrayList<KeyValue<K, V>>();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        if (iterator instanceof Closeable) {
            try {
                ((Closeable)((Object)iterator)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return results;
    }

    public static <K, V> Set<KeyValue<K, V>> toSet(Iterator<KeyValue<K, V>> iterator) {
        LinkedHashSet<KeyValue<K, V>> results = new LinkedHashSet<KeyValue<K, V>>();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        return results;
    }

    public static <K, V> Set<V> valuesToSet(Iterator<KeyValue<K, V>> iterator) {
        HashSet<Object> results = new HashSet<Object>();
        while (iterator.hasNext()) {
            results.add(iterator.next().value);
        }
        return results;
    }

    public static <K> void verifyKeyValueList(List<KeyValue<K, byte[]>> expected, List<KeyValue<K, byte[]>> actual) {
        MatcherAssert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.equalTo((Object)expected.size()));
        for (int i = 0; i < actual.size(); ++i) {
            KeyValue<K, byte[]> expectedKv = expected.get(i);
            KeyValue<K, byte[]> actualKv = actual.get(i);
            MatcherAssert.assertThat((Object)actualKv.key, (Matcher)CoreMatchers.equalTo((Object)expectedKv.key));
            MatcherAssert.assertThat((Object)actualKv.value, (Matcher)CoreMatchers.equalTo((Object)expectedKv.value));
        }
    }

    public static void verifyAllWindowedKeyValues(KeyValueIterator<Windowed<Bytes>, byte[]> iterator, List<Windowed<Bytes>> expectedKeys, List<String> expectedValues) {
        if (expectedKeys.size() != expectedValues.size()) {
            throw new IllegalArgumentException("expectedKeys and expectedValues should have the same size. expectedKeys size: " + expectedKeys.size() + ", expectedValues size: " + expectedValues.size());
        }
        for (int i = 0; i < expectedKeys.size(); ++i) {
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), expectedKeys.get(i), expectedValues.get(i));
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    public static void verifyWindowedKeyValue(KeyValue<Windowed<Bytes>, byte[]> actual, Windowed<Bytes> expectedKey, String expectedValue) {
        MatcherAssert.assertThat((Object)((Windowed)actual.key).window(), (Matcher)CoreMatchers.equalTo((Object)expectedKey.window()));
        MatcherAssert.assertThat((Object)((Windowed)actual.key).key(), (Matcher)CoreMatchers.equalTo((Object)expectedKey.key()));
        MatcherAssert.assertThat((Object)actual.value, (Matcher)CoreMatchers.equalTo((Object)expectedValue.getBytes()));
    }

    public static Metric getMetricByName(Map<MetricName, ? extends Metric> metrics, String name, String group) {
        Metric metric = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : metrics.entrySet()) {
            if (!entry.getKey().name().equals(name) || !entry.getKey().group().equals(group)) continue;
            if (metric == null) {
                metric = entry.getValue();
                continue;
            }
            throw new IllegalStateException("Found two metrics with name=[" + name + "]: \n" + metric.metricName().toString() + " AND \n" + entry.getKey().toString());
        }
        if (metric == null) {
            throw new IllegalStateException("Didn't find metric with name=[" + name + "]");
        }
        return metric;
    }

    public static Metric getMetricByNameFilterByTags(Map<MetricName, ? extends Metric> metrics, String name, String group, Map<String, String> filterTags) {
        Metric metric = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : metrics.entrySet()) {
            if (!entry.getKey().name().equals(name) || !entry.getKey().group().equals(group)) continue;
            boolean filtersMatch = true;
            for (Map.Entry<String, String> filter : filterTags.entrySet()) {
                if (filter.getValue().equals(entry.getKey().tags().get(filter.getKey()))) continue;
                filtersMatch = false;
            }
            if (!filtersMatch) continue;
            if (metric == null) {
                metric = entry.getValue();
                continue;
            }
            throw new IllegalStateException("Found two metrics with name=[" + name + "] and tags=[" + filterTags + "]: \n" + metric.metricName().toString() + " AND \n" + entry.getKey().toString());
        }
        if (metric == null) {
            throw new IllegalStateException("Didn't find metric with name=[" + name + "] and tags=[" + filterTags + "]");
        }
        return metric;
    }

    public static boolean containsMetric(Metrics metrics, String name, String group, Map<String, String> tags) {
        MetricName metricName = metrics.metricName(name, group, tags);
        return metrics.metric(metricName) != null;
    }

    public static boolean isCheckSupplierCall() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(caller -> "org.apache.kafka.streams.internals.ApiUtils".equals(caller.getClassName()) && "checkSupplier".equals(caller.getMethodName()));
    }

    public static class TopologyMetadataBuilder {
        private final TopologyMetadata topologyMetadata;

        private TopologyMetadataBuilder(TopologyMetadata topologyMetadata) {
            this.topologyMetadata = topologyMetadata;
        }

        public static TopologyMetadataBuilder unnamedTopology() {
            TopologyMetadata topologyMetadata = (TopologyMetadata)Mockito.mock(TopologyMetadata.class);
            Mockito.when((Object)topologyMetadata.isPaused(null)).thenReturn((Object)false);
            return new TopologyMetadataBuilder(topologyMetadata);
        }

        public TopologyMetadata build() {
            return this.topologyMetadata;
        }
    }

    public static class TaskBuilder<T extends Task> {
        private final T task;

        private TaskBuilder(T task) {
            this.task = task;
        }

        public static TaskBuilder<StreamTask> statelessTask(TaskId taskId) {
            StreamTask task = (StreamTask)Mockito.mock(StreamTask.class, (MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT));
            Mockito.when((Object)task.changelogPartitions()).thenReturn(Collections.emptySet());
            Mockito.when((Object)task.isActive()).thenReturn((Object)true);
            Mockito.when((Object)task.id()).thenReturn((Object)taskId);
            return new TaskBuilder<StreamTask>(task);
        }

        public static TaskBuilder<StreamTask> statefulTask(TaskId taskId, Set<TopicPartition> changelogPartitions) {
            StreamTask task = (StreamTask)Mockito.mock(StreamTask.class, (MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT));
            Mockito.when((Object)task.isActive()).thenReturn((Object)true);
            TaskBuilder.setupStatefulTask((Task)task, taskId, changelogPartitions);
            return new TaskBuilder<StreamTask>(task);
        }

        public static TaskBuilder<StandbyTask> standbyTask(TaskId taskId, Set<TopicPartition> changelogPartitions) {
            StandbyTask task = (StandbyTask)Mockito.mock(StandbyTask.class, (MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT));
            Mockito.when((Object)task.isActive()).thenReturn((Object)false);
            TaskBuilder.setupStatefulTask((Task)task, taskId, changelogPartitions);
            return new TaskBuilder<StandbyTask>(task);
        }

        private static void setupStatefulTask(Task task, TaskId taskId, Set<TopicPartition> changelogPartitions) {
            Mockito.when((Object)task.changelogPartitions()).thenReturn(changelogPartitions);
            Mockito.when((Object)task.id()).thenReturn((Object)taskId);
            Mockito.when((Object)task.stateManager()).thenReturn(Mockito.mock(ProcessorStateManager.class));
        }

        public TaskBuilder<T> inState(Task.State state) {
            Mockito.when((Object)this.task.state()).thenReturn((Object)state);
            return this;
        }

        public TaskBuilder<T> withInputPartitions(Set<TopicPartition> inputPartitions) {
            Mockito.when((Object)this.task.inputPartitions()).thenReturn(inputPartitions);
            return this;
        }

        public T build() {
            return this.task;
        }
    }
}

