/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetrics;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecordingTrigger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.rocksdb.Cache;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.RocksDB;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.TickerType;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class RocksDBMetricsRecorderTest {
    private static final String METRICS_SCOPE = "metrics-scope";
    private static final TaskId TASK_ID1 = new TaskId(0, 0);
    private static final TaskId TASK_ID2 = new TaskId(0, 1);
    private static final String STORE_NAME = "store-name";
    private static final String SEGMENT_STORE_NAME_1 = "segment-store-name-1";
    private static final String SEGMENT_STORE_NAME_2 = "segment-store-name-2";
    private static final String SEGMENT_STORE_NAME_3 = "segment-store-name-3";
    private final RocksDB dbToAdd1 = (RocksDB)Mockito.mock(RocksDB.class);
    private final RocksDB dbToAdd2 = (RocksDB)Mockito.mock(RocksDB.class);
    private final RocksDB dbToAdd3 = (RocksDB)Mockito.mock(RocksDB.class);
    private final Cache cacheToAdd1 = (Cache)Mockito.mock(Cache.class);
    private final Cache cacheToAdd2 = (Cache)Mockito.mock(Cache.class);
    private final Statistics statisticsToAdd1 = (Statistics)Mockito.mock(Statistics.class);
    private final Statistics statisticsToAdd2 = (Statistics)Mockito.mock(Statistics.class);
    private final Statistics statisticsToAdd3 = (Statistics)Mockito.mock(Statistics.class);
    private final Sensor bytesWrittenToDatabaseSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor bytesReadFromDatabaseSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor memtableBytesFlushedSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor memtableHitRatioSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor memtableAvgFlushTimeSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor memtableMinFlushTimeSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor memtableMaxFlushTimeSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor writeStallDurationSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor blockCacheDataHitRatioSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor blockCacheIndexHitRatioSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor blockCacheFilterHitRatioSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor bytesReadDuringCompactionSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor bytesWrittenDuringCompactionSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor compactionTimeAvgSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor compactionTimeMinSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor compactionTimeMaxSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor numberOfOpenFilesSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Sensor numberOfFileErrorsSensor = (Sensor)Mockito.mock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);
    private final RocksDBMetricsRecordingTrigger recordingTrigger = (RocksDBMetricsRecordingTrigger)Mockito.mock(RocksDBMetricsRecordingTrigger.class);
    private final RocksDBMetricsRecorder recorder = new RocksDBMetricsRecorder("metrics-scope", "store-name");
    private final RocksDBMetrics.RocksDBMetricContext metricsContext = new RocksDBMetrics.RocksDBMetricContext(TASK_ID1.toString(), "metrics-scope", "store-name");
    private MockedStatic<RocksDBMetrics> dbMetrics;

    @BeforeEach
    public void setUp() {
        this.setUpMetricsMock();
        Mockito.when((Object)this.streamsMetrics.rocksDBMetricsRecordingTrigger()).thenReturn((Object)this.recordingTrigger);
        this.recorder.init(this.streamsMetrics, TASK_ID1);
    }

    @AfterEach
    public void cleanUpMocks() {
        this.dbMetrics.close();
    }

    @AfterAll
    public static void cleanUpMockito() {
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void shouldInitMetricsRecorder() {
        this.dbMetrics.verify(() -> RocksDBMetrics.bytesWrittenToDatabaseSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.bytesReadFromDatabaseSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.memtableBytesFlushedSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.memtableHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.memtableAvgFlushTimeSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.memtableMinFlushTimeSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.memtableMaxFlushTimeSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.writeStallDurationSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.blockCacheDataHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.blockCacheIndexHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.blockCacheFilterHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.bytesWrittenDuringCompactionSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.bytesReadDuringCompactionSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.compactionTimeAvgSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.compactionTimeMinSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.compactionTimeMaxSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.numberOfOpenFilesSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.numberOfFileErrorsSensor((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.any()), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addNumImmutableMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addCurSizeActiveMemTable((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addCurSizeAllMemTables((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addSizeAllMemTables((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addNumEntriesActiveMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addNumEntriesImmMemTablesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addNumDeletesActiveMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addNumDeletesImmMemTablesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addMemTableFlushPending((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addNumRunningFlushesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addCompactionPendingMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addNumRunningCompactionsMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addEstimatePendingCompactionBytesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addTotalSstFilesSizeMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addLiveSstFilesSizeMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addNumLiveVersionMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addBlockCacheCapacityMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addBlockCacheUsageMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addBlockCachePinnedUsageMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addEstimateNumKeysMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addEstimateTableReadersMemMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        this.dbMetrics.verify(() -> RocksDBMetrics.addBackgroundErrorsMetric((StreamsMetricsImpl)((StreamsMetricsImpl)ArgumentMatchers.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)ArgumentMatchers.eq((Object)this.metricsContext)), (Gauge)((Gauge)ArgumentMatchers.any())));
        MatcherAssert.assertThat((Object)this.recorder.taskId(), (Matcher)CoreMatchers.is((Object)TASK_ID1));
    }

    @Test
    public void shouldThrowIfMetricRecorderIsReInitialisedWithDifferentTask() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.init(this.streamsMetrics, TASK_ID2));
    }

    @Test
    public void shouldThrowIfMetricRecorderIsReInitialisedWithDifferentStreamsMetrics() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.init(new StreamsMetricsImpl(new Metrics(), "test-client", "latest", (Time)new MockTime()), TASK_ID1));
    }

    @Test
    public void shouldSetStatsLevelToExceptDetailedTimersWhenValueProvidersWithStatisticsAreAdded() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        ((Statistics)Mockito.verify((Object)this.statisticsToAdd1)).setStatsLevel(StatsLevel.EXCEPT_DETAILED_TIMERS);
    }

    @Test
    public void shouldNotSetStatsLevelToExceptDetailedTimersWhenValueProvidersWithoutStatisticsAreAdded() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.statisticsToAdd1});
    }

    @Test
    public void shouldThrowIfValueProvidersForASegmentHasBeenAlreadyAdded() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd2));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Value providers for store segment-store-name-1 of task " + TASK_ID1 + " has been already added. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfStatisticsToAddIsNotNullButExistingStatisticsAreNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, null);
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Statistics for segment segment-store-name-2 of task " + TASK_ID1 + " is not null although the statistics of another segment in this metrics recorder is null. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfStatisticsToAddIsNullButExistingStatisticsAreNotNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Statistics for segment segment-store-name-2 of task " + TASK_ID1 + " is null although the statistics of another segment in this metrics recorder is not null. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfCacheToAddIsNullButExistingCacheIsNotNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, null, this.statisticsToAdd1);
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd1, this.statisticsToAdd1));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Cache for segment segment-store-name-2 of task " + TASK_ID1 + " is not null although the cache of another segment in this metrics recorder is null. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfCacheToAddIsNotNullButExistingCacheIsNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, null, this.statisticsToAdd2));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Cache for segment segment-store-name-2 of task " + TASK_ID1 + " is null although the cache of another segment in this metrics recorder is not null. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfCacheToAddIsNotSameAsAllExistingCaches() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd1, this.statisticsToAdd2);
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_3, this.dbToAdd3, this.cacheToAdd2, this.statisticsToAdd3));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Caches for store store-name of task " + TASK_ID1 + " are either not all distinct or do not all refer to the same cache. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfCacheToAddIsSameAsOnlyOneOfMultipleCaches() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_3, this.dbToAdd3, this.cacheToAdd1, this.statisticsToAdd3));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Caches for store store-name of task " + TASK_ID1 + " are either not all distinct or do not all refer to the same cache. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfDbToAddWasAlreadyAddedForOtherSegment() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd1, this.cacheToAdd2, this.statisticsToAdd2));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("DB instance for store segment-store-name-2 of task " + TASK_ID1 + " was already added for another segment as a value provider. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldAddItselfToRecordingTriggerWhenFirstValueProvidersAreAddedToNewlyCreatedRecorder() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        ((RocksDBMetricsRecordingTrigger)Mockito.verify((Object)this.recordingTrigger)).addMetricsRecorder(this.recorder);
    }

    @Test
    public void shouldAddItselfToRecordingTriggerWhenFirstValueProvidersAreAddedAfterLastValueProvidersWereRemoved() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        ((RocksDBMetricsRecordingTrigger)Mockito.verify((Object)this.recordingTrigger, (VerificationMode)Mockito.times((int)2))).addMetricsRecorder(this.recorder);
    }

    @Test
    public void shouldNotAddItselfToRecordingTriggerWhenNotEmpty() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        ((RocksDBMetricsRecordingTrigger)Mockito.verify((Object)this.recordingTrigger)).addMetricsRecorder(this.recorder);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldNotRemoveItselfFromRecordingTriggerWhenAtLeastOneValueProviderIsPresent() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_1);
        ((RocksDBMetricsRecordingTrigger)Mockito.verify((Object)this.recordingTrigger, (VerificationMode)Mockito.never())).removeMetricsRecorder(this.recorder);
    }

    @Test
    public void shouldRemoveItselfFromRecordingTriggerWhenAllValueProvidersAreRemoved() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_1);
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_2);
        ((RocksDBMetricsRecordingTrigger)Mockito.verify((Object)this.recordingTrigger)).removeMetricsRecorder(this.recorder);
    }

    @Test
    public void shouldThrowIfValueProvidersToRemoveNotFound() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Assertions.assertThrows(IllegalStateException.class, () -> this.recorder.removeValueProviders(SEGMENT_STORE_NAME_2));
    }

    @Test
    public void shouldRecordStatisticsBasedMetrics() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        long now = 0L;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BYTES_WRITTEN)).thenReturn((Object)1L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BYTES_WRITTEN)).thenReturn((Object)2L);
        double expectedBytesWrittenToDatabaseSensor = 3.0;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BYTES_READ)).thenReturn((Object)2L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BYTES_READ)).thenReturn((Object)3L);
        double expectedBytesReadFromDatabaseSensor = 5.0;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.FLUSH_WRITE_BYTES)).thenReturn((Object)3L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.FLUSH_WRITE_BYTES)).thenReturn((Object)4L);
        double expectedMemtableBytesFlushedSensor = 7.0;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.MEMTABLE_HIT)).thenReturn((Object)1L);
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.MEMTABLE_MISS)).thenReturn((Object)2L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.MEMTABLE_HIT)).thenReturn((Object)3L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.MEMTABLE_MISS)).thenReturn((Object)4L);
        double expectedMemtableHitRatioSensorRecord = 0.4;
        HistogramData memtableFlushTimeData1 = new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 16.0, 2L, 10L, 3.0);
        HistogramData memtableFlushTimeData2 = new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 20.0, 4L, 8L, 10.0);
        Mockito.when((Object)this.statisticsToAdd1.getHistogramData(HistogramType.FLUSH_TIME)).thenReturn((Object)memtableFlushTimeData1);
        Mockito.when((Object)this.statisticsToAdd2.getHistogramData(HistogramType.FLUSH_TIME)).thenReturn((Object)memtableFlushTimeData2);
        double expectedMemtableAvgFlushTimeSensor = 3.0;
        double expectedMemtableMinFlushTimeSensor = 3.0;
        double expectedMemtableMaxFlushTimeSensor = 20.0;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.STALL_MICROS)).thenReturn((Object)4L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.STALL_MICROS)).thenReturn((Object)5L);
        double expectedWriteStallDurationSensor = 9.0;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_HIT)).thenReturn((Object)5L);
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_MISS)).thenReturn((Object)4L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_HIT)).thenReturn((Object)3L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_MISS)).thenReturn((Object)2L);
        double expectedBlockCacheDataHitRatioSensor = 0.5714285714285714;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_HIT)).thenReturn((Object)4L);
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_MISS)).thenReturn((Object)2L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_HIT)).thenReturn((Object)2L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_MISS)).thenReturn((Object)4L);
        double expectedBlockCacheIndexHitRatioSensor = 0.5;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_HIT)).thenReturn((Object)2L);
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_MISS)).thenReturn((Object)4L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_HIT)).thenReturn((Object)3L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_MISS)).thenReturn((Object)5L);
        double expectedBlockCacheFilterHitRatioSensor = 0.35714285714285715;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.COMPACT_WRITE_BYTES)).thenReturn((Object)2L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.COMPACT_WRITE_BYTES)).thenReturn((Object)4L);
        double expectedBytesWrittenDuringCompactionSensor = 6.0;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.COMPACT_READ_BYTES)).thenReturn((Object)5L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.COMPACT_READ_BYTES)).thenReturn((Object)6L);
        double expectedBytesReadDuringCompactionSensor = 11.0;
        HistogramData compactionTimeData1 = new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 16.0, 2L, 8L, 6.0);
        HistogramData compactionTimeData2 = new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 24.0, 2L, 8L, 4.0);
        Mockito.when((Object)this.statisticsToAdd1.getHistogramData(HistogramType.COMPACTION_TIME)).thenReturn((Object)compactionTimeData1);
        Mockito.when((Object)this.statisticsToAdd2.getHistogramData(HistogramType.COMPACTION_TIME)).thenReturn((Object)compactionTimeData2);
        double expectedCompactionTimeAvgSensor = 4.0;
        double expectedCompactionTimeMinSensor = 4.0;
        double expectedCompactionTimeMaxSensor = 24.0;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_OPENS)).thenReturn((Object)5L);
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_CLOSES)).thenReturn((Object)3L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_OPENS)).thenReturn((Object)7L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_CLOSES)).thenReturn((Object)4L);
        double expectedNumberOfOpenFilesSensor = 5.0;
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_ERRORS)).thenReturn((Object)34L);
        Mockito.when((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_ERRORS)).thenReturn((Object)11L);
        double expectedNumberOfFileErrorsSensor = 45.0;
        this.recorder.record(0L);
        ((Statistics)Mockito.verify((Object)this.statisticsToAdd1, (VerificationMode)Mockito.times((int)17))).getAndResetTickerCount((TickerType)ArgumentMatchers.isA(TickerType.class));
        ((Statistics)Mockito.verify((Object)this.statisticsToAdd2, (VerificationMode)Mockito.times((int)17))).getAndResetTickerCount((TickerType)ArgumentMatchers.isA(TickerType.class));
        ((Statistics)Mockito.verify((Object)this.statisticsToAdd1, (VerificationMode)Mockito.times((int)2))).getHistogramData((HistogramType)ArgumentMatchers.isA(HistogramType.class));
        ((Statistics)Mockito.verify((Object)this.statisticsToAdd2, (VerificationMode)Mockito.times((int)2))).getHistogramData((HistogramType)ArgumentMatchers.isA(HistogramType.class));
        ((Sensor)Mockito.verify((Object)this.bytesWrittenToDatabaseSensor)).record(3.0, 0L);
        ((Sensor)Mockito.verify((Object)this.bytesReadFromDatabaseSensor)).record(5.0, 0L);
        ((Sensor)Mockito.verify((Object)this.memtableBytesFlushedSensor)).record(7.0, 0L);
        ((Sensor)Mockito.verify((Object)this.memtableHitRatioSensor)).record(0.4, 0L);
        ((Sensor)Mockito.verify((Object)this.memtableAvgFlushTimeSensor)).record(3.0, 0L);
        ((Sensor)Mockito.verify((Object)this.memtableMinFlushTimeSensor)).record(3.0, 0L);
        ((Sensor)Mockito.verify((Object)this.memtableMaxFlushTimeSensor)).record(20.0, 0L);
        ((Sensor)Mockito.verify((Object)this.writeStallDurationSensor)).record(9.0, 0L);
        ((Sensor)Mockito.verify((Object)this.blockCacheDataHitRatioSensor)).record(0.5714285714285714, 0L);
        ((Sensor)Mockito.verify((Object)this.blockCacheIndexHitRatioSensor)).record(0.5, 0L);
        ((Sensor)Mockito.verify((Object)this.blockCacheFilterHitRatioSensor)).record(0.35714285714285715, 0L);
        ((Sensor)Mockito.verify((Object)this.bytesWrittenDuringCompactionSensor)).record(6.0, 0L);
        ((Sensor)Mockito.verify((Object)this.bytesReadDuringCompactionSensor)).record(11.0, 0L);
        ((Sensor)Mockito.verify((Object)this.compactionTimeAvgSensor)).record(4.0, 0L);
        ((Sensor)Mockito.verify((Object)this.compactionTimeMinSensor)).record(4.0, 0L);
        ((Sensor)Mockito.verify((Object)this.compactionTimeMaxSensor)).record(24.0, 0L);
        ((Sensor)Mockito.verify((Object)this.numberOfOpenFilesSensor)).record(5.0, 0L);
        ((Sensor)Mockito.verify((Object)this.numberOfFileErrorsSensor)).record(45.0, 0L);
    }

    @Test
    public void shouldNotRecordStatisticsBasedMetricsIfStatisticsIsNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, null);
        this.recorder.record(0L);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.bytesWrittenToDatabaseSensor, this.bytesReadFromDatabaseSensor, this.memtableBytesFlushedSensor, this.memtableHitRatioSensor, this.memtableAvgFlushTimeSensor, this.memtableMinFlushTimeSensor, this.memtableMaxFlushTimeSensor, this.writeStallDurationSensor, this.blockCacheDataHitRatioSensor, this.blockCacheIndexHitRatioSensor, this.blockCacheFilterHitRatioSensor, this.bytesWrittenDuringCompactionSensor, this.bytesReadDuringCompactionSensor, this.compactionTimeAvgSensor, this.compactionTimeMinSensor, this.compactionTimeMaxSensor, this.numberOfOpenFilesSensor, this.numberOfFileErrorsSensor});
    }

    @Test
    public void shouldCorrectlyHandleHitRatioRecordingsWithZeroHitsAndMisses() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Mockito.when((Object)this.statisticsToAdd1.getHistogramData((HistogramType)ArgumentMatchers.any())).thenReturn((Object)new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 0L, 0.0));
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount((TickerType)ArgumentMatchers.any())).thenReturn((Object)0L);
        this.recorder.record(0L);
        ((Sensor)Mockito.verify((Object)this.memtableHitRatioSensor)).record(0.0, 0L);
        ((Sensor)Mockito.verify((Object)this.blockCacheDataHitRatioSensor)).record(0.0, 0L);
        ((Sensor)Mockito.verify((Object)this.blockCacheIndexHitRatioSensor)).record(0.0, 0L);
        ((Sensor)Mockito.verify((Object)this.blockCacheFilterHitRatioSensor)).record(0.0, 0L);
    }

    @Test
    public void shouldCorrectlyHandleAvgRecordingsWithZeroSumAndCount() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        long now = 0L;
        Mockito.when((Object)this.statisticsToAdd1.getHistogramData((HistogramType)ArgumentMatchers.any())).thenReturn((Object)new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 0L, 0.0));
        Mockito.when((Object)this.statisticsToAdd1.getAndResetTickerCount((TickerType)ArgumentMatchers.any())).thenReturn((Object)0L);
        this.recorder.record(0L);
        ((Sensor)Mockito.verify((Object)this.compactionTimeAvgSensor)).record(0.0, 0L);
        ((Sensor)Mockito.verify((Object)this.memtableAvgFlushTimeSensor)).record(0.0, 0L);
    }

    private void setUpMetricsMock() {
        this.dbMetrics = Mockito.mockStatic(RocksDBMetrics.class);
        this.dbMetrics.when(() -> RocksDBMetrics.bytesWrittenToDatabaseSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.bytesWrittenToDatabaseSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.bytesReadFromDatabaseSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.bytesReadFromDatabaseSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.memtableBytesFlushedSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.memtableBytesFlushedSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.memtableHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.memtableHitRatioSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.memtableAvgFlushTimeSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.memtableAvgFlushTimeSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.memtableMinFlushTimeSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.memtableMinFlushTimeSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.memtableMaxFlushTimeSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.memtableMaxFlushTimeSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.writeStallDurationSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.writeStallDurationSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.blockCacheDataHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.blockCacheDataHitRatioSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.blockCacheIndexHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.blockCacheIndexHitRatioSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.blockCacheFilterHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.blockCacheFilterHitRatioSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.bytesWrittenDuringCompactionSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.bytesWrittenDuringCompactionSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.bytesReadDuringCompactionSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.bytesReadDuringCompactionSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.compactionTimeAvgSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.compactionTimeAvgSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.compactionTimeMinSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.compactionTimeMinSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.compactionTimeMaxSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.compactionTimeMaxSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.numberOfOpenFilesSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.numberOfOpenFilesSensor);
        this.dbMetrics.when(() -> RocksDBMetrics.numberOfFileErrorsSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)this.metricsContext)).thenReturn((Object)this.numberOfFileErrorsSensor);
    }
}

