/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.NamedCacheMetrics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class NamedCacheMetricsTest {
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private static final String STORE_NAME = "storeName";
    private static final String HIT_RATIO_AVG_DESCRIPTION = "The average cache hit ratio";
    private static final String HIT_RATIO_MIN_DESCRIPTION = "The minimum cache hit ratio";
    private static final String HIT_RATIO_MAX_DESCRIPTION = "The maximum cache hit ratio";
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);
    private final Sensor expectedSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Map<String, String> tagMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"key", (Object)"value")});

    @Test
    public void shouldGetHitRatioSensorWithBuiltInMetricsVersionCurrent() {
        String hitRatio = "hit-ratio";
        Mockito.when((Object)this.streamsMetrics.cacheLevelSensor(THREAD_ID, TASK_ID, STORE_NAME, "hit-ratio", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.cacheLevelTagMap(THREAD_ID, TASK_ID, STORE_NAME)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = NamedCacheMetrics.hitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (String)THREAD_ID, (String)TASK_ID, (String)STORE_NAME);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addAvgAndMinAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-record-cache-metrics", this.tagMap, (String)"hit-ratio", (String)HIT_RATIO_AVG_DESCRIPTION, (String)HIT_RATIO_MIN_DESCRIPTION, (String)HIT_RATIO_MAX_DESCRIPTION));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }
}

