/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueAndTimestampSerializerTest {
    private static final String TOPIC = "some-topic";
    private static final long TIMESTAMP = 23L;
    private static final ValueAndTimestampSerde<String> STRING_SERDE = new ValueAndTimestampSerde(Serdes.String());

    @Test
    public void shouldSerializeNonNullDataUsingTheInternalSerializer() {
        String value = "some-string";
        ValueAndTimestamp valueAndTimestamp = ValueAndTimestamp.make((Object)"some-string", (long)23L);
        byte[] serialized = STRING_SERDE.serializer().serialize(TOPIC, (Object)valueAndTimestamp);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ValueAndTimestamp deserialized = (ValueAndTimestamp)STRING_SERDE.deserializer().deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is((Object)valueAndTimestamp));
    }

    @Test
    public void shouldDropSerializedValueIfEqualWithGreaterTimestamp() {
        String value = "food";
        ValueAndTimestamp oldValueAndTimestamp = ValueAndTimestamp.make((Object)"food", (long)23L);
        byte[] oldSerializedValue = STRING_SERDE.serializer().serialize(TOPIC, (Object)oldValueAndTimestamp);
        ValueAndTimestamp newValueAndTimestamp = ValueAndTimestamp.make((Object)"food", (long)24L);
        byte[] newSerializedValue = STRING_SERDE.serializer().serialize(TOPIC, (Object)newValueAndTimestamp);
        Assertions.assertTrue((boolean)ValueAndTimestampSerializer.valuesAreSameAndTimeIsIncreasing((byte[])oldSerializedValue, (byte[])newSerializedValue));
    }

    @Test
    public void shouldKeepSerializedValueIfOutOfOrder() {
        String value = "balls";
        ValueAndTimestamp oldValueAndTimestamp = ValueAndTimestamp.make((Object)"balls", (long)23L);
        byte[] oldSerializedValue = STRING_SERDE.serializer().serialize(TOPIC, (Object)oldValueAndTimestamp);
        ValueAndTimestamp outOfOrderValueAndTimestamp = ValueAndTimestamp.make((Object)"balls", (long)22L);
        byte[] outOfOrderSerializedValue = STRING_SERDE.serializer().serialize(TOPIC, (Object)outOfOrderValueAndTimestamp);
        Assertions.assertFalse((boolean)ValueAndTimestampSerializer.valuesAreSameAndTimeIsIncreasing((byte[])oldSerializedValue, (byte[])outOfOrderSerializedValue));
    }

    @Test
    public void shouldSerializeNullDataAsNull() {
        byte[] serialized = STRING_SERDE.serializer().serialize(TOPIC, (Object)ValueAndTimestamp.make(null, (long)23L));
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldReturnNullWhenTheInternalSerializerReturnsNull() {
        Serializer alwaysNullSerializer = (topic, data) -> null;
        ValueAndTimestampSerializer serializer = new ValueAndTimestampSerializer(alwaysNullSerializer);
        byte[] serialized = serializer.serialize(TOPIC, (Object)"non-null-data", 23L);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

