/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.KeyQuery;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class StoreQueryUtilsTest {
    @Test
    public void shouldReturnErrorOnNullContext() {
        KeyQuery query = (KeyQuery)Mockito.mock(KeyQuery.class);
        KeyValueStore store = (KeyValueStore)Mockito.mock(KeyValueStore.class);
        Position position = Position.emptyPosition().withComponent("topic", 0, 1L);
        QueryResult queryResult = StoreQueryUtils.handleBasicQueries((Query)query, (PositionBound)PositionBound.at((Position)position), (QueryConfig)new QueryConfig(false), (StateStore)store, (Position)position, null);
        MatcherAssert.assertThat((Object)queryResult.isFailure(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)queryResult.getFailureReason(), (Matcher)Matchers.is((Object)FailureReason.NOT_UP_TO_BOUND));
        MatcherAssert.assertThat((Object)queryResult.getFailureMessage(), (Matcher)Matchers.is((Object)"The store is not initialized yet, so it is not yet up to the bound PositionBound{position=Position{position={topic={0=1}}}}"));
    }

    @Test
    public void shouldReturnErrorOnBoundViolation() {
        KeyQuery query = (KeyQuery)Mockito.mock(KeyQuery.class);
        KeyValueStore store = (KeyValueStore)Mockito.mock(KeyValueStore.class);
        StateStoreContext context = (StateStoreContext)Mockito.mock(StateStoreContext.class);
        Mockito.when((Object)context.taskId()).thenReturn((Object)new TaskId(0, 0));
        QueryResult queryResult = StoreQueryUtils.handleBasicQueries((Query)query, (PositionBound)PositionBound.at((Position)Position.emptyPosition().withComponent("topic", 0, 1L)), (QueryConfig)new QueryConfig(false), (StateStore)store, (Position)Position.emptyPosition().withComponent("topic", 0, 0L), (StateStoreContext)context);
        MatcherAssert.assertThat((Object)queryResult.isFailure(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)queryResult.getFailureReason(), (Matcher)Matchers.is((Object)FailureReason.NOT_UP_TO_BOUND));
        MatcherAssert.assertThat((Object)queryResult.getFailureMessage(), (Matcher)Matchers.is((Object)"For store partition 0, the current position Position{position={topic={0=0}}} is not yet up to the bound PositionBound{position=Position{position={topic={0=1}}}}"));
    }
}

