/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDbIndexedTimeOrderedWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RocksDbIndexedTimeOrderedWindowBytesStoreSupplierTest {
    @Test
    public void shouldThrowIfStoreNameIsNull() {
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create(null, (Duration)Duration.ZERO, (Duration)Duration.ZERO, (boolean)false, (boolean)false));
        Assertions.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfRetentionPeriodIsNegative() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create((String)"anyName", (Duration)Duration.ofMillis(-1L), (Duration)Duration.ZERO, (boolean)false, (boolean)false));
        Assertions.assertEquals((Object)"retentionPeriod cannot be negative", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfWindowSizeIsNegative() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create((String)"anyName", (Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(-1L), (boolean)false, (boolean)false));
        Assertions.assertEquals((Object)"windowSize cannot be negative", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfWindowSizeIsLargerThanRetention() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create((String)"anyName", (Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(2L), (boolean)false, (boolean)false));
        Assertions.assertEquals((Object)"The retention period of the window store anyName must be no smaller than its window size. Got size=[2], retention=[1]", (Object)e.getMessage());
    }

    @Test
    public void shouldCreateRocksDbTimeOrderedWindowStoreWithIndex() {
        WindowStore store = RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create((String)"store", (Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(1L), (boolean)false, (boolean)true).get();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(RocksDBTimeOrderedWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(RocksDBTimeOrderedWindowSegmentedBytesStore.class));
        Assertions.assertTrue((boolean)((RocksDBTimeOrderedWindowSegmentedBytesStore)wrapped).hasIndex());
    }

    @Test
    public void shouldCreateRocksDbTimeOrderedWindowStoreWithoutIndex() {
        WindowStore store = RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create((String)"store", (Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(1L), (boolean)false, (boolean)false).get();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(RocksDBTimeOrderedWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(RocksDBTimeOrderedWindowSegmentedBytesStore.class));
        Assertions.assertFalse((boolean)((RocksDBTimeOrderedWindowSegmentedBytesStore)wrapped).hasIndex());
    }
}

