/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.NamedCache;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NamedCacheTest {
    private final Headers headers = new RecordHeaders(new Header[]{new RecordHeader("key", "value".getBytes())});
    private NamedCache cache;

    @BeforeEach
    public void setUp() {
        Metrics innerMetrics = new Metrics();
        MockStreamsMetrics metrics = new MockStreamsMetrics(innerMetrics);
        this.cache = new NamedCache("dummy-name", (StreamsMetricsImpl)metrics);
    }

    @Test
    public void shouldKeepTrackOfMostRecentlyAndLeastRecentlyUsed() {
        List<KeyValue> toInsert = Arrays.asList(new KeyValue((Object)"K1", (Object)"V1"), new KeyValue((Object)"K2", (Object)"V2"), new KeyValue((Object)"K3", (Object)"V3"), new KeyValue((Object)"K4", (Object)"V4"), new KeyValue((Object)"K5", (Object)"V5"));
        for (KeyValue stringStringKeyValue : toInsert) {
            byte[] key = ((String)stringStringKeyValue.key).getBytes();
            byte[] value = ((String)stringStringKeyValue.value).getBytes();
            this.cache.put(Bytes.wrap((byte[])key), new LRUCacheEntry(value, (Headers)new RecordHeaders(), true, 1L, 1L, 1, ""));
            LRUCacheEntry head = this.cache.first();
            LRUCacheEntry tail = this.cache.last();
            Assertions.assertEquals((Object)new String(head.value()), (Object)stringStringKeyValue.value);
            Assertions.assertEquals((Object)new String(tail.value()), (Object)toInsert.get((int)0).value);
            Assertions.assertEquals((long)this.cache.flushes(), (long)0L);
            Assertions.assertEquals((long)this.cache.hits(), (long)0L);
            Assertions.assertEquals((long)this.cache.misses(), (long)0L);
            Assertions.assertEquals((long)this.cache.overwrites(), (long)0L);
        }
    }

    @Test
    public void shouldKeepTrackOfSize() {
        LRUCacheEntry value = new LRUCacheEntry(new byte[]{0});
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), value);
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), value);
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), value);
        long size = this.cache.sizeInBytes();
        Assertions.assertEquals((long)((value.size() + 25L) * 3L), (long)size);
    }

    @Test
    public void shouldPutGet() {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{11}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), new LRUCacheEntry(new byte[]{12}));
        Assertions.assertArrayEquals((byte[])new byte[]{10}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{0})).value());
        Assertions.assertArrayEquals((byte[])new byte[]{11}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{1})).value());
        Assertions.assertArrayEquals((byte[])new byte[]{12}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{2})).value());
        Assertions.assertEquals((long)this.cache.hits(), (long)3L);
    }

    @Test
    public void shouldPutIfAbsent() {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}));
        this.cache.putIfAbsent(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{20}));
        this.cache.putIfAbsent(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{30}));
        Assertions.assertArrayEquals((byte[])new byte[]{10}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{0})).value());
        Assertions.assertArrayEquals((byte[])new byte[]{30}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{1})).value());
    }

    @Test
    public void shouldDeleteAndUpdateSize() {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}));
        LRUCacheEntry deleted = this.cache.delete(Bytes.wrap((byte[])new byte[]{0}));
        Assertions.assertArrayEquals((byte[])new byte[]{10}, (byte[])deleted.value());
        Assertions.assertEquals((long)0L, (long)this.cache.sizeInBytes());
    }

    @Test
    public void shouldPutAll() {
        this.cache.putAll(Arrays.asList(KeyValue.pair((Object)new byte[]{0}, (Object)new LRUCacheEntry(new byte[]{0})), KeyValue.pair((Object)new byte[]{1}, (Object)new LRUCacheEntry(new byte[]{1})), KeyValue.pair((Object)new byte[]{2}, (Object)new LRUCacheEntry(new byte[]{2}))));
        Assertions.assertArrayEquals((byte[])new byte[]{0}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{0})).value());
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{1})).value());
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{2})).value());
    }

    @Test
    public void shouldOverwriteAll() {
        this.cache.putAll(Arrays.asList(KeyValue.pair((Object)new byte[]{0}, (Object)new LRUCacheEntry(new byte[]{0})), KeyValue.pair((Object)new byte[]{0}, (Object)new LRUCacheEntry(new byte[]{1})), KeyValue.pair((Object)new byte[]{0}, (Object)new LRUCacheEntry(new byte[]{2}))));
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])this.cache.get(Bytes.wrap((byte[])new byte[]{0})).value());
        Assertions.assertEquals((long)this.cache.overwrites(), (long)2L);
    }

    @Test
    public void shouldEvictEldestEntry() {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{20}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), new LRUCacheEntry(new byte[]{30}));
        this.cache.evict();
        Assertions.assertNull((Object)this.cache.get(Bytes.wrap((byte[])new byte[]{0})));
        Assertions.assertEquals((long)2L, (long)this.cache.size());
    }

    @Test
    public void shouldFlushDirtEntriesOnEviction() {
        ArrayList flushed = new ArrayList();
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}, this.headers, true, 0L, 0L, 0, ""));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{20}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), new LRUCacheEntry(new byte[]{30}, this.headers, true, 0L, 0L, 0, ""));
        this.cache.setListener(flushed::addAll);
        this.cache.evict();
        Assertions.assertEquals((int)2, (int)flushed.size());
        Assertions.assertEquals((Object)Bytes.wrap((byte[])new byte[]{0}), (Object)((ThreadCache.DirtyEntry)flushed.get(0)).key());
        Assertions.assertEquals((Object)this.headers, (Object)((ThreadCache.DirtyEntry)flushed.get(0)).entry().context().headers());
        Assertions.assertArrayEquals((byte[])new byte[]{10}, (byte[])((ThreadCache.DirtyEntry)flushed.get(0)).newValue());
        Assertions.assertEquals((Object)Bytes.wrap((byte[])new byte[]{2}), (Object)((ThreadCache.DirtyEntry)flushed.get(1)).key());
        Assertions.assertArrayEquals((byte[])new byte[]{30}, (byte[])((ThreadCache.DirtyEntry)flushed.get(1)).newValue());
        Assertions.assertEquals((long)this.cache.flushes(), (long)1L);
    }

    @Test
    public void shouldNotThrowNullPointerWhenCacheIsEmptyAndEvictionCalled() {
        this.cache.evict();
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenTryingToOverwriteDirtyEntryWithCleanEntry() {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}, this.headers, true, 0L, 0L, 0, ""));
        Assertions.assertThrows(IllegalStateException.class, () -> this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}, (Headers)new RecordHeaders(), false, 0L, 0L, 0, "")));
    }

    @Test
    public void shouldRemoveDeletedValuesOnFlush() {
        this.cache.setListener(dirty -> {});
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(null, this.headers, true, 0L, 0L, 0, ""));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{20}, (Headers)new RecordHeaders(), true, 0L, 0L, 0, ""));
        this.cache.flush();
        Assertions.assertEquals((long)1L, (long)this.cache.size());
        Assertions.assertNotNull((Object)this.cache.get(Bytes.wrap((byte[])new byte[]{1})));
    }

    @Test
    public void shouldBeReentrantAndNotBreakLRU() {
        LRUCacheEntry dirty = new LRUCacheEntry(new byte[]{3}, (Headers)new RecordHeaders(), true, 0L, 0L, 0, "");
        LRUCacheEntry clean = new LRUCacheEntry(new byte[]{3});
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), dirty);
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), clean);
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), clean);
        Assertions.assertEquals((long)(3L * this.cache.head().size()), (long)this.cache.sizeInBytes());
        this.cache.setListener(dirty1 -> {
            this.cache.put(Bytes.wrap((byte[])new byte[]{3}), clean);
            this.cache.evict();
            this.cache.evict();
        });
        Assertions.assertEquals((long)(3L * this.cache.head().size()), (long)this.cache.sizeInBytes());
        this.cache.evict();
        Bytes entryFour = Bytes.wrap((byte[])new byte[]{4});
        this.cache.put(entryFour, dirty);
        NamedCache.LRUNode head = this.cache.head();
        NamedCache.LRUNode tail = this.cache.tail();
        Assertions.assertEquals((long)2L, (long)this.cache.size());
        Assertions.assertEquals((long)(2L * head.size()), (long)this.cache.sizeInBytes());
        Assertions.assertEquals((Object)entryFour, (Object)head.key());
        Assertions.assertEquals((Object)Bytes.wrap((byte[])new byte[]{3}), (Object)tail.key());
        Assertions.assertSame((Object)tail, (Object)head.next());
        Assertions.assertNull((Object)head.previous());
        Assertions.assertSame((Object)head, (Object)tail.previous());
        Assertions.assertNull((Object)tail.next());
        this.cache.evict();
        Assertions.assertSame((Object)this.cache.head(), (Object)this.cache.tail());
        Assertions.assertEquals((Object)entryFour, (Object)this.cache.head().key());
        Assertions.assertNull((Object)this.cache.head().next());
        Assertions.assertNull((Object)this.cache.head().previous());
    }

    @Test
    public void shouldNotThrowIllegalArgumentAfterEvictingDirtyRecordAndThenPuttingNewRecordWithSameKey() {
        LRUCacheEntry dirty = new LRUCacheEntry(new byte[]{3}, (Headers)new RecordHeaders(), true, 0L, 0L, 0, "");
        LRUCacheEntry clean = new LRUCacheEntry(new byte[]{3});
        Bytes key = Bytes.wrap((byte[])new byte[]{3});
        this.cache.setListener(dirty1 -> this.cache.put(key, clean));
        this.cache.put(key, dirty);
        this.cache.evict();
    }

    @Test
    public void shouldReturnNullIfKeyIsNull() {
        Assertions.assertNull((Object)this.cache.get(null));
    }
}

