/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.LinkedList;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.AbstractWindowBytesStoreTest;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryWindowStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InMemoryWindowStoreTest
extends AbstractWindowBytesStoreTest {
    private static final String STORE_NAME = "InMemoryWindowStore";

    @Override
    <K, V> WindowStore<K, V> buildWindowStore(long retentionPeriod, long windowSize, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde) {
        return (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)STORE_NAME, (Duration)Duration.ofMillis(retentionPeriod), (Duration)Duration.ofMillis(windowSize), (boolean)retainDuplicates), keySerde, valueSerde).build();
    }

    @Test
    public void shouldRestore() {
        Assertions.assertFalse((boolean)this.windowStore.all().hasNext());
        StateSerdes serdes = new StateSerdes("", Serdes.Integer(), Serdes.String());
        LinkedList<KeyValue<byte[], byte[]>> restorableEntries = new LinkedList<KeyValue<byte[], byte[]>>();
        restorableEntries.add(new KeyValue((Object)WindowKeySchema.toStoreKeyBinary((Object)1, (long)0L, (int)0, (StateSerdes)serdes).get(), (Object)serdes.rawValue((Object)"one")));
        restorableEntries.add(new KeyValue((Object)WindowKeySchema.toStoreKeyBinary((Object)2, (long)3L, (int)0, (StateSerdes)serdes).get(), (Object)serdes.rawValue((Object)"two")));
        restorableEntries.add(new KeyValue((Object)WindowKeySchema.toStoreKeyBinary((Object)3, (long)6L, (int)0, (StateSerdes)serdes).get(), (Object)serdes.rawValue((Object)"three")));
        this.context.restore(STORE_NAME, restorableEntries);
        try (KeyValueIterator iterator = this.windowStore.fetchAll(0L, 6L);){
            Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "one", 0L), (Object)iterator.next());
            Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(2, "two", 3L), (Object)iterator.next());
            Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(3, "three", 6L), (Object)iterator.next());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldNotExpireFromOpenIterator() {
        this.windowStore.put((Object)1, (Object)"one", 0L);
        this.windowStore.put((Object)1, (Object)"two", 10L);
        this.windowStore.put((Object)2, (Object)"one", 5L);
        this.windowStore.put((Object)2, (Object)"two", 15L);
        WindowStoreIterator iterator1 = this.windowStore.fetch((Object)1, 0L, 50L);
        WindowStoreIterator iterator2 = this.windowStore.fetch((Object)2, 0L, 50L);
        this.windowStore.put((Object)1, (Object)"four", 240000L);
        Assertions.assertEquals((Object)new KeyValue((Object)0L, (Object)"one"), (Object)iterator1.next());
        Assertions.assertEquals((Object)new KeyValue((Object)5L, (Object)"one"), (Object)iterator2.next());
        Assertions.assertEquals((Object)new KeyValue((Object)15L, (Object)"two"), (Object)iterator2.next());
        Assertions.assertEquals((Object)new KeyValue((Object)10L, (Object)"two"), (Object)iterator1.next());
        Assertions.assertFalse((boolean)iterator1.hasNext());
        Assertions.assertFalse((boolean)iterator2.hasNext());
        iterator1.close();
        iterator2.close();
        Assertions.assertFalse((boolean)this.windowStore.fetch((Object)1, 0L, 50L).hasNext());
    }

    @Test
    public void testExpiration() {
        long currentTime = 0L;
        this.windowStore.put((Object)1, (Object)"one", currentTime);
        this.windowStore.put((Object)1, (Object)"two", currentTime += 30000L);
        this.windowStore.put((Object)1, (Object)"three", currentTime += 30000L);
        this.windowStore.put((Object)1, (Object)"four", currentTime += 30000L);
        this.windowStore.put((Object)1, (Object)"five", currentTime += 30000L);
        KeyValueIterator iterator = this.windowStore.fetchAll(0L, currentTime);
        this.windowStore.put((Object)1, (Object)"six", currentTime += 30000L);
        Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "two", 30000L), (Object)iterator.next());
        Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "three", 60000L), (Object)iterator.next());
        Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "four", 90000L), (Object)iterator.next());
        Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "five", 120000L), (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        iterator = this.windowStore.fetchAll(0L, currentTime);
        Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "three", 60000L), (Object)iterator.next());
        Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "four", 90000L), (Object)iterator.next());
        Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "five", 120000L), (Object)iterator.next());
        Assertions.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "six", 150000L), (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldMatchPositionAfterPut() {
        MeteredWindowStore meteredSessionStore = (MeteredWindowStore)this.windowStore;
        ChangeLoggingWindowBytesStore changeLoggingSessionBytesStore = (ChangeLoggingWindowBytesStore)meteredSessionStore.wrapped();
        InMemoryWindowStore inMemoryWindowStore = (InMemoryWindowStore)changeLoggingSessionBytesStore.wrapped();
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.windowStore.put((Object)0, (Object)"0", 60000L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.windowStore.put((Object)1, (Object)"1", 60000L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        this.windowStore.put((Object)2, (Object)"2", 60000L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 4L, 0, "", (Headers)new RecordHeaders()));
        this.windowStore.put((Object)3, (Object)"3", 60000L);
        Position expected = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)4L)}))}));
        Position actual = inMemoryWindowStore.getPosition();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

