/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class GlobalStateStoreProviderTest {
    private final Map<String, StateStore> stores = new HashMap<String, StateStore>();
    private static final Map<String, Object> CONFIGS = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"__internal.override.topic.prefix__", (Object)"appId")});

    @BeforeEach
    public void before() {
        this.stores.put("kv-store", Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"kv-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("ts-kv-store", Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"ts-kv-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("w-store", Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"w-store", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(2L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("ts-w-store", Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"ts-w-store", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(2L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("s-store", Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.inMemorySessionStore((String)"s-store", (Duration)Duration.ofMillis(10L)), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        ProcessorContextImpl mockContext = (ProcessorContextImpl)Mockito.mock(ProcessorContextImpl.class);
        Mockito.when((Object)mockContext.applicationId()).thenReturn((Object)"appId");
        Mockito.when((Object)mockContext.metrics()).thenReturn((Object)new StreamsMetricsImpl(new Metrics(), "threadName", "latest", (Time)new MockTime()));
        Mockito.when((Object)mockContext.taskId()).thenReturn((Object)new TaskId(0, 0));
        Mockito.when((Object)mockContext.appConfigs()).thenReturn(CONFIGS);
        for (StateStore store : this.stores.values()) {
            store.init((StateStoreContext)mockContext, null);
        }
    }

    @Test
    public void shouldReturnSingleItemListIfStoreExists() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.singletonMap("global", new NoOpReadOnlyStore()));
        List stores = provider.stores("global", QueryableStoreTypes.keyValueStore());
        Assertions.assertEquals((int)stores.size(), (int)1);
    }

    @Test
    public void shouldReturnEmptyItemListIfStoreDoesntExist() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.emptyMap());
        List stores = provider.stores("global", QueryableStoreTypes.keyValueStore());
        Assertions.assertTrue((boolean)stores.isEmpty());
    }

    @Test
    public void shouldThrowExceptionIfStoreIsntOpen() {
        NoOpReadOnlyStore store = new NoOpReadOnlyStore();
        store.close();
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.singletonMap("global", store));
        Assertions.assertThrows(InvalidStateStoreException.class, () -> provider.stores("global", QueryableStoreTypes.keyValueStore()));
    }

    @Test
    public void shouldReturnKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("kv-store", QueryableStoreTypes.keyValueStore());
        Assertions.assertEquals((int)1, (int)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldReturnTimestampedKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-kv-store", QueryableStoreTypes.timestampedKeyValueStore());
        Assertions.assertEquals((int)1, (int)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class));
        }
    }

    @Test
    public void shouldNotReturnKeyValueStoreAsTimestampedStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("kv-store", QueryableStoreTypes.timestampedKeyValueStore());
        Assertions.assertEquals((int)0, (int)stores.size());
    }

    @Test
    public void shouldReturnTimestampedKeyValueStoreAsKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-kv-store", QueryableStoreTypes.keyValueStore());
        Assertions.assertEquals((int)1, (int)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldReturnWindowStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("w-store", QueryableStoreTypes.windowStore());
        Assertions.assertEquals((int)1, (int)stores.size());
        for (ReadOnlyWindowStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyWindowStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedWindowStore.class)));
        }
    }

    @Test
    public void shouldNotReturnWindowStoreAsTimestampedStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("w-store", QueryableStoreTypes.timestampedWindowStore());
        Assertions.assertEquals((int)0, (int)stores.size());
    }

    @Test
    public void shouldReturnTimestampedWindowStoreAsWindowStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-w-store", QueryableStoreTypes.windowStore());
        Assertions.assertEquals((int)1, (int)stores.size());
        for (ReadOnlyWindowStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyWindowStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedWindowStore.class)));
        }
    }

    @Test
    public void shouldReturnSessionStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("s-store", QueryableStoreTypes.sessionStore());
        Assertions.assertEquals((int)1, (int)stores.size());
        for (ReadOnlySessionStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlySessionStore.class));
        }
    }
}

