/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.state.internals.ContextualRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ContextualRecordTest {
    ContextualRecordTest() {
    }

    @Test
    public void testEquals() {
        byte[] value1 = new byte[]{1, 2, 3};
        byte[] value2 = new byte[]{1, 2, 3};
        long timestamp = Time.SYSTEM.milliseconds();
        ProcessorRecordContext context1 = new ProcessorRecordContext(timestamp, 12345L, 0, "test-topic", (Headers)new RecordHeaders());
        ProcessorRecordContext context2 = new ProcessorRecordContext(timestamp, 12345L, 0, "test-topic", (Headers)new RecordHeaders());
        ContextualRecord record1 = new ContextualRecord(value1, context1);
        ContextualRecord record2 = new ContextualRecord(value2, context2);
        Assertions.assertEquals((Object)record1, (Object)record2);
    }

    @Test
    public void testNotEqualsDifferentContent() {
        byte[] value1 = new byte[]{1, 2, 3};
        byte[] value2 = new byte[]{4, 5, 6};
        long timestamp = Time.SYSTEM.milliseconds();
        ProcessorRecordContext context1 = new ProcessorRecordContext(timestamp, 12345L, 0, "test-topic", (Headers)new RecordHeaders());
        ProcessorRecordContext context2 = new ProcessorRecordContext(timestamp, 12345L, 0, "test-topic", (Headers)new RecordHeaders());
        ContextualRecord record1 = new ContextualRecord(value1, context1);
        ContextualRecord record2 = new ContextualRecord(value2, context2);
        Assertions.assertNotEquals((Object)record1, (Object)record2);
    }

    @Test
    public void testEqualsSameInstance() {
        byte[] value = new byte[]{1, 2, 3};
        ProcessorRecordContext context = new ProcessorRecordContext(Time.SYSTEM.milliseconds(), 12345L, 0, "test-topic", (Headers)new RecordHeaders());
        ContextualRecord record = new ContextualRecord(value, context);
        Assertions.assertEquals((Object)record, (Object)record);
    }

    @Test
    public void testHashCodeThrowsException() {
        byte[] value = new byte[]{1, 2, 3};
        ProcessorRecordContext context = new ProcessorRecordContext(Time.SYSTEM.milliseconds(), 12345L, 0, "test-topic", (Headers)new RecordHeaders());
        ContextualRecord record = new ContextualRecord(value, context);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((ContextualRecord)record).hashCode());
    }
}

