/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.PositionSerde;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class ChangeLoggingKeyValueBytesStoreTest {
    private final MockRecordCollector collector = new MockRecordCollector();
    private final InMemoryKeyValueStore inner = new InMemoryKeyValueStore("kv");
    private final ChangeLoggingKeyValueBytesStore store = new ChangeLoggingKeyValueBytesStore((KeyValueStore)this.inner);
    private InternalMockProcessorContext context;
    private final StreamsConfig streamsConfig = this.streamsConfigMock();
    private final Bytes hi = Bytes.wrap((byte[])"hi".getBytes());
    private final Bytes hello = Bytes.wrap((byte[])"hello".getBytes());
    private final byte[] there = "there".getBytes();
    private final byte[] world = "world".getBytes();
    private static final String INPUT_TOPIC_NAME = "input-topic";
    private static final Integer INPUT_PARTITION = 0;
    private static final Long INPUT_OFFSET = 100L;

    @BeforeEach
    public void before() {
        this.context = this.mockContext();
        this.context.setTime(0L);
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
    }

    private InternalMockProcessorContext mockContext() {
        return new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), new StreamsMetricsImpl(new Metrics(), "mock", "latest", (Time)new MockTime()), this.streamsConfig, () -> this.collector, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
    }

    @AfterEach
    public void after() {
        this.store.close();
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        InternalMockProcessorContext context = this.mockContext();
        KeyValueStore innerMock = (KeyValueStore)Mockito.mock(InMemoryKeyValueStore.class);
        ChangeLoggingKeyValueBytesStore outer = new ChangeLoggingKeyValueBytesStore(innerMock);
        outer.init((ProcessorContext)context, (StateStore)outer);
        ((KeyValueStore)Mockito.verify((Object)innerMock)).init((ProcessorContext)context, (StateStore)outer);
    }

    @Test
    public void shouldDelegateInit() {
        InternalMockProcessorContext context = this.mockContext();
        KeyValueStore innerMock = (KeyValueStore)Mockito.mock(InMemoryKeyValueStore.class);
        ChangeLoggingKeyValueBytesStore outer = new ChangeLoggingKeyValueBytesStore(innerMock);
        outer.init((StateStoreContext)context, (StateStore)outer);
        ((KeyValueStore)Mockito.verify((Object)innerMock)).init((StateStoreContext)context, (StateStore)outer);
    }

    @Test
    public void shouldWriteKeyValueBytesToInnerStoreOnPut() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldWriteAllKeyValueToInnerStoreOnPutAll() {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)this.hi, (Object)this.there), KeyValue.pair((Object)this.hello, (Object)this.world)));
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.inner.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.world));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).key(), (Matcher)CoreMatchers.equalTo((Object)this.hello));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).value(), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldPropagateDelete() {
        this.store.put(this.hi, this.there);
        this.store.delete(this.hi);
        MatcherAssert.assertThat((Object)this.inner.approximateNumEntries(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnOldValueOnDelete() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.delete(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldLogKeyNullOnDelete() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.delete(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).value(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldWriteToInnerOnPutIfAbsentNoPreviousValue() {
        this.store.putIfAbsent(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldNotWriteToInnerOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put(this.hi, this.there);
        this.store.putIfAbsent(this.hi, this.world);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldWriteToChangelogOnPutIfAbsentWhenNoPreviousValue() {
        this.store.putIfAbsent(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldNotWriteToChangeLogOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put(this.hi, this.there);
        this.store.putIfAbsent(this.hi, this.world);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldReturnCurrentValueOnPutIfAbsent() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.world), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldReturnNullOnPutIfAbsentWhenNoPreviousValue() {
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.there), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldReturnValueOnGetWhenExists() {
        this.store.put(this.hello, this.world);
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldGetRecordsWithPrefixKey() {
        this.store.put(this.hi, this.there);
        this.store.put(Bytes.increment((Bytes)this.hi), this.world);
        ArrayList<Object> keys = new ArrayList<Object>();
        ArrayList<Bytes> values = new ArrayList<Bytes>();
        int numberOfKeysReturned = 0;
        try (KeyValueIterator keysWithPrefix = this.store.prefixScan((Object)this.hi.toString(), (Serializer)new StringSerializer());){
            while (keysWithPrefix.hasNext()) {
                KeyValue next = (KeyValue)keysWithPrefix.next();
                keys.add(next.key);
                values.add(Bytes.wrap((byte[])((byte[])next.value)));
                ++numberOfKeysReturned;
            }
        }
        MatcherAssert.assertThat((Object)numberOfKeysReturned, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(keys, (Matcher)CoreMatchers.is(Collections.singletonList(this.hi)));
        MatcherAssert.assertThat(values, (Matcher)CoreMatchers.is(Collections.singletonList(Bytes.wrap((byte[])this.there))));
    }

    @Test
    public void shouldReturnNullOnGetWhenDoesntExist() {
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldLogPositionOnPut() {
        this.context.setRecordContext(new ProcessorRecordContext(-1L, INPUT_OFFSET.longValue(), INPUT_PARTITION.intValue(), INPUT_TOPIC_NAME, (Headers)new RecordHeaders()));
        this.context.setTime(1L);
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).headers(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Header versionHeader = this.collector.collected().get(0).headers().lastHeader("v");
        MatcherAssert.assertThat((Object)versionHeader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)versionHeader.equals(ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY), (Matcher)CoreMatchers.is((Object)true));
        Header vectorHeader = this.collector.collected().get(0).headers().lastHeader("c");
        MatcherAssert.assertThat((Object)vectorHeader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Position position = PositionSerde.deserialize((ByteBuffer)ByteBuffer.wrap(vectorHeader.value()));
        MatcherAssert.assertThat((Object)position.getPartitionPositions(INPUT_TOPIC_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)position.getPartitionPositions(INPUT_TOPIC_NAME), (Matcher)Matchers.hasEntry((Object)0, (Object)100L));
    }

    private StreamsConfig streamsConfigMock() {
        StreamsConfig streamsConfig = (StreamsConfig)Mockito.mock(StreamsConfig.class);
        HashMap<String, Boolean> myValues = new HashMap<String, Boolean>();
        myValues.put("__iq.consistency.offset.vector.enabled__", true);
        Mockito.when((Object)streamsConfig.originals()).thenReturn(myValues);
        Mockito.when((Object)streamsConfig.values()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)streamsConfig.getString("application.id")).thenReturn((Object)"add-id");
        return streamsConfig;
    }
}

