/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.TaskMovement;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class TaskMovementTest {
    @Test
    public void shouldAssignTasksToClientsAndReturnFalseWhenAllClientsCaughtUp() {
        int maxWarmupReplicas = Integer.MAX_VALUE;
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2});
        HashMap<TaskId, SortedSet> tasksToCaughtUpClients = new HashMap<TaskId, SortedSet>();
        HashMap<TaskId, SortedSet<ProcessId>> tasksToClientByLag = new HashMap<TaskId, SortedSet<ProcessId>>();
        for (TaskId task : allTasks) {
            tasksToCaughtUpClients.put(task, Utils.mkSortedSet((Comparable[])new ProcessId[]{AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3}));
            tasksToClientByLag.put(task, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3));
        }
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0}), allTasks, allTasks);
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}), allTasks, allTasks);
        ClientState client3 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2}), allTasks, allTasks);
        MatcherAssert.assertThat((Object)TaskMovement.assignActiveTaskMovements(tasksToCaughtUpClients, tasksToClientByLag, AssignmentTestUtils.getClientStatesMap(client1, client2, client3), new TreeMap(), (AtomicInteger)new AtomicInteger(Integer.MAX_VALUE)), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldAssignAllTasksToClientsAndReturnFalseIfNoClientsAreCaughtUp() {
        int maxWarmupReplicas = Integer.MAX_VALUE;
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2});
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0}), Utils.mkSet((Object[])new TaskId[0]), allTasks);
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}), Utils.mkSet((Object[])new TaskId[0]), allTasks);
        ClientState client3 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2}), Utils.mkSet((Object[])new TaskId[0]), allTasks);
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_0, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_1, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_2, Collections.emptySortedSet())});
        Map tasksToClientByLag = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_0, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_1, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_2, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3))});
        MatcherAssert.assertThat((Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, (Map)tasksToClientByLag, AssignmentTestUtils.getClientStatesMap(client1, client2, client3), new TreeMap(), (AtomicInteger)new AtomicInteger(Integer.MAX_VALUE)), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldMoveTasksToCaughtUpClientsAndAssignWarmupReplicasInTheirPlace() {
        int maxWarmupReplicas = Integer.MAX_VALUE;
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2});
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), allTasks);
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), allTasks);
        ClientState client3 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), allTasks);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[]{AssignmentTestUtils.PID_1})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[]{AssignmentTestUtils.PID_3})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[]{AssignmentTestUtils.PID_2}))});
        Map tasksToClientByLag = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_3))});
        MatcherAssert.assertThat((String)"should have assigned movements", (Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, (Map)tasksToClientByLag, clientStates, new TreeMap(), (AtomicInteger)new AtomicInteger(Integer.MAX_VALUE)), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
    }

    @Test
    public void shouldMoveTasksToMostCaughtUpClientsAndAssignWarmupReplicasInTheirPlace() {
        int maxWarmupReplicas = Integer.MAX_VALUE;
        Map client1Lags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)10000L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)20000L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)30000L)});
        Map client2Lags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)10000L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)20000L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)30000L)});
        Map client3Lags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)10000L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)20000L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)30000L)});
        ClientState client1 = TaskMovementTest.getClientStateWithLags(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), client1Lags);
        ClientState client2 = TaskMovementTest.getClientStateWithLags(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), client2Lags);
        ClientState client3 = TaskMovementTest.getClientStateWithLags(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), client3Lags);
        client3.assignStandby(AssignmentTestUtils.TASK_0_1);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[0])), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[0])), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[0]))});
        Map tasksToClientByLag = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_1))});
        MatcherAssert.assertThat((String)"should have assigned movements", (Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, (Map)tasksToClientByLag, clientStates, new TreeMap(), (AtomicInteger)new AtomicInteger(Integer.MAX_VALUE)), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
    }

    @Test
    public void shouldOnlyGetUpToMaxWarmupReplicasAndReturnTrue() {
        boolean maxWarmupReplicas = true;
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2});
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), allTasks);
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), allTasks);
        ClientState client3 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), allTasks);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[]{AssignmentTestUtils.PID_1})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[]{AssignmentTestUtils.PID_3})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[]{AssignmentTestUtils.PID_2}))});
        Map tasksToClientByLag = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2)), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_3))});
        MatcherAssert.assertThat((String)"should have assigned movements", (Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, (Map)tasksToClientByLag, clientStates, new TreeMap(), (AtomicInteger)new AtomicInteger(1)), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
    }

    @Test
    public void shouldNotCountPreviousStandbyTasksTowardsMaxWarmupReplicas() {
        boolean maxWarmupReplicas = false;
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0});
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), allTasks);
        client1.assignStandby(AssignmentTestUtils.TASK_0_0);
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0]), allTasks);
        Map<ProcessId, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)Utils.mkSortedSet((Comparable[])new ProcessId[]{AssignmentTestUtils.PID_1}))});
        Map tasksToClientByLag = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, TaskMovementTest.mkOrderedSet(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2))});
        MatcherAssert.assertThat((String)"should have assigned movements", (Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, (Map)tasksToClientByLag, clientStates, new TreeMap(), (AtomicInteger)new AtomicInteger(0)), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
    }

    private static ClientState getClientStateWithActiveAssignment(Set<TaskId> activeTasks, Set<TaskId> caughtUpTasks, Set<TaskId> allTasks) {
        HashMap<TaskId, Long> lags = new HashMap<TaskId, Long>();
        for (TaskId task : allTasks) {
            if (caughtUpTasks.contains(task)) {
                lags.put(task, 0L);
                continue;
            }
            lags.put(task, 10000L);
        }
        return TaskMovementTest.getClientStateWithLags(activeTasks, lags);
    }

    private static ClientState getClientStateWithLags(Set<TaskId> activeTasks, Map<TaskId, Long> taskLags) {
        ClientState client1 = new ClientState(activeTasks, Collections.emptySet(), taskLags, Collections.emptyMap(), 1);
        client1.assignActiveTasks(activeTasks);
        return client1;
    }

    private static SortedSet<ProcessId> mkOrderedSet(ProcessId ... clients) {
        List<ProcessId> clientList = Arrays.asList(clients);
        TreeSet<ProcessId> set = new TreeSet<ProcessId>(Comparator.comparing(clientList::indexOf));
        set.addAll(clientList);
        return set;
    }
}

