/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.testutil.DummyStreamsConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class TopologyMetadataTest {
    static final String TOPOLOGY1 = "topology1";
    static final String TOPOLOGY2 = "topology2";

    @Test
    public void testPauseResume() {
        InternalTopologyBuilder internalTopologyBuilder = (InternalTopologyBuilder)Mockito.mock(InternalTopologyBuilder.class);
        DummyStreamsConfig config = new DummyStreamsConfig();
        TopologyMetadata topologyMetadata = new TopologyMetadata(internalTopologyBuilder, (StreamsConfig)config);
        Assertions.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assertions.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
        topologyMetadata.pauseTopology(TOPOLOGY1);
        Assertions.assertTrue((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assertions.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
        topologyMetadata.resumeTopology(TOPOLOGY1);
        Assertions.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assertions.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
    }

    @Test
    public void testSubtopologyCompare() {
        TopologyMetadata.Subtopology subtopology1 = new TopologyMetadata.Subtopology(0, "1");
        TopologyMetadata.Subtopology subtopology2 = new TopologyMetadata.Subtopology(1, "1");
        Assertions.assertTrue((subtopology1.compareTo(subtopology2) < 0 ? 1 : 0) != 0);
        subtopology1 = new TopologyMetadata.Subtopology(0, null);
        subtopology2 = new TopologyMetadata.Subtopology(0, null);
        Assertions.assertEquals((int)0, (int)subtopology1.compareTo(subtopology2));
        subtopology1 = new TopologyMetadata.Subtopology(0, null);
        subtopology2 = new TopologyMetadata.Subtopology(0, "1");
        Assertions.assertTrue((subtopology1.compareTo(subtopology2) < 0 ? 1 : 0) != 0);
        subtopology1 = new TopologyMetadata.Subtopology(0, "1");
        subtopology2 = new TopologyMetadata.Subtopology(0, null);
        Assertions.assertTrue((subtopology1.compareTo(subtopology2) > 0 ? 1 : 0) != 0);
        subtopology1 = new TopologyMetadata.Subtopology(0, "1");
        subtopology2 = new TopologyMetadata.Subtopology(0, "2");
        Assertions.assertTrue((subtopology1.compareTo(subtopology2) < 0 ? 1 : 0) != 0);
    }
}

