/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskExecutionMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TaskExecutionMetadataTest {
    static final String TOPOLOGY1 = "topology1";
    static final String TOPOLOGY2 = "topology2";
    static final Set<String> NAMED_TOPOLOGIES = new HashSet<String>(Arrays.asList("topology1", "topology2"));
    static final int TIME_ZERO = 0;
    static final int CONSTANT_BACKOFF_MS = 5000;

    @Test
    public void testCanProcessWithoutNamedTopologies() {
        Set<String> topologies = Collections.singleton("__UNNAMED_TOPOLOGY__");
        HashSet<String> pausedTopologies = new HashSet<String>();
        TaskExecutionMetadata metadata = new TaskExecutionMetadata(topologies, pausedTopologies, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE);
        Task mockTask = TaskExecutionMetadataTest.createMockTask("__UNNAMED_TOPOLOGY__");
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask, 0L));
        pausedTopologies.add("__UNNAMED_TOPOLOGY__");
        Assertions.assertFalse((boolean)metadata.canProcessTask(mockTask, 0L));
    }

    @Test
    public void testNamedTopologiesCanBePausedIndependently() {
        HashSet<String> pausedTopologies = new HashSet<String>();
        TaskExecutionMetadata metadata = new TaskExecutionMetadata(NAMED_TOPOLOGIES, pausedTopologies, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE);
        Task mockTask1 = TaskExecutionMetadataTest.createMockTask(TOPOLOGY1);
        Task mockTask2 = TaskExecutionMetadataTest.createMockTask(TOPOLOGY2);
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask1, 0L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 0L));
        pausedTopologies.add(TOPOLOGY1);
        Assertions.assertFalse((boolean)metadata.canProcessTask(mockTask1, 0L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 0L));
        pausedTopologies.remove(TOPOLOGY1);
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask1, 0L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 0L));
    }

    @Test
    public void testNamedTopologiesCanBeStartedPaused() {
        HashSet<String> pausedTopologies = new HashSet<String>();
        pausedTopologies.add(TOPOLOGY1);
        TaskExecutionMetadata metadata = new TaskExecutionMetadata(NAMED_TOPOLOGIES, pausedTopologies, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE);
        Task mockTask1 = TaskExecutionMetadataTest.createMockTask(TOPOLOGY1);
        Task mockTask2 = TaskExecutionMetadataTest.createMockTask(TOPOLOGY2);
        Assertions.assertFalse((boolean)metadata.canProcessTask(mockTask1, 0L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 0L));
        pausedTopologies.remove(TOPOLOGY1);
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask1, 0L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 0L));
    }

    @Test
    public void testNamedTopologiesCanBackoff() {
        HashSet pausedTopologies = new HashSet();
        TaskExecutionMetadata metadata = new TaskExecutionMetadata(NAMED_TOPOLOGIES, pausedTopologies, StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE);
        Task mockTask1 = TaskExecutionMetadataTest.createMockTask(TOPOLOGY1);
        Task mockTask2 = TaskExecutionMetadataTest.createMockTask(TOPOLOGY2);
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask1, 0L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 0L));
        metadata.registerTaskError(mockTask1, new Throwable("Error"), 0L);
        Assertions.assertFalse((boolean)metadata.canProcessTask(mockTask1, 4999L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 4999L));
        Assertions.assertFalse((boolean)metadata.canProcessTask(mockTask1, 5000L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 5000L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask1, 5001L));
        Assertions.assertTrue((boolean)metadata.canProcessTask(mockTask2, 5001L));
    }

    private static Task createMockTask(String topologyName) {
        Task mockTask = (Task)Mockito.mock(Task.class);
        TaskId taskId = new TaskId(0, 0, topologyName);
        Mockito.when((Object)mockTask.id()).thenReturn((Object)taskId);
        return mockTask;
    }
}

