/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.StoreToProcessorContextAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class StoreToProcessorContextAdapterTest {
    @Mock
    private StateStoreContext delegate;
    private ProcessorContext context;
    @Mock
    private Punctuator punctuator;

    @BeforeEach
    public void setUp() {
        this.context = StoreToProcessorContextAdapter.adapt((StateStoreContext)this.delegate);
    }

    @Test
    public void shouldThrowOnCurrentSystemTime() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.currentSystemTimeMs());
    }

    @Test
    public void shouldThrowOnCurrentStreamTime() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.currentStreamTimeMs());
    }

    @Test
    public void shouldThrowOnGetStateStore() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.getStateStore("store"));
    }

    @Test
    public void shouldThrowOnScheduleWithDuration() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.schedule(Duration.ZERO, PunctuationType.WALL_CLOCK_TIME, this.punctuator));
    }

    @Test
    public void shouldThrowOnForward() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.forward((Object)"key", (Object)"value"));
    }

    @Test
    public void shouldThrowOnForwardWithTo() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.forward((Object)"key", (Object)"value", To.all()));
    }

    @Test
    public void shouldThrowOnCommit() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.commit());
    }

    @Test
    public void shouldThrowOnTopic() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.topic());
    }

    @Test
    public void shouldThrowOnPartition() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.partition());
    }

    @Test
    public void shouldThrowOnOffset() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.offset());
    }

    @Test
    public void shouldThrowOnHeaders() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.headers());
    }

    @Test
    public void shouldThrowOnTimestamp() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.context.timestamp());
    }
}

