/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SessionWindowTest {
    private final long start = 50L;
    private final long end = 100L;
    private final SessionWindow window = new SessionWindow(50L, 100L);
    private final TimeWindow timeWindow = new TimeWindow(50L, 100L);

    @Test
    public void shouldNotOverlapIfOtherWindowIsBeforeThisWindow() {
        Assertions.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(0L, 25L)));
        Assertions.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(0L, 49L)));
        Assertions.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(49L, 49L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowEndIsWithinThisWindow() {
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 50L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 51L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 75L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 99L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 100L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 50L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 51L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 75L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 99L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 100L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowContainsThisWindow() {
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 100L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 101L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 150L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 100L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 101L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 150L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 100L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 101L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 150L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowIsWithinThisWindow() {
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 50L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 75L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 100L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, 100L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(100L, 100L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowStartIsWithinThisWindow() {
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 101L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 150L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, 101L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, 150L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(100L, 101L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(100L, 150L)));
    }

    @Test
    public void shouldNotOverlapIsOtherWindowIsAfterThisWindow() {
        Assertions.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(101L, 101L)));
        Assertions.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(101L, 150L)));
        Assertions.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(125L, 150L)));
    }

    @Test
    public void cannotCompareSessionWindowWithDifferentWindowType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.window.overlap((Window)this.timeWindow));
    }
}

