/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.KStreamKTableJoin;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.test.MockApiProcessor;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KStreamKTableJoinTest {
    private static final KeyValueTimestamp<?, ?>[] EMPTY = new KeyValueTimestamp[0];
    private final String streamTopic = "streamTopic";
    private final String tableTopic = "tableTopic";
    private TestInputTopic<Integer, String> inputStreamTopic;
    private TestInputTopic<Integer, String> inputTableTopic;
    private final int[] expectedKeys = new int[]{0, 1, 2, 3};
    private MockApiProcessor<Integer, String, Void, Void> processor;
    private TopologyTestDriver driver;
    private StreamsBuilder builder;
    private final MockApiProcessorSupplier<Integer, String, Void, Void> supplier = new MockApiProcessorSupplier();
    private final String expectedTopologyWithGeneratedRepartitionTopicNames = "Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [topic])\n      --> KSTREAM-MAP-0000000007\n    Processor: KSTREAM-MAP-0000000007 (stores: [])\n      --> KSTREAM-FILTER-0000000009\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KSTREAM-FILTER-0000000009 (stores: [])\n      --> KSTREAM-SINK-0000000008\n      <-- KSTREAM-MAP-0000000007\n    Sink: KSTREAM-SINK-0000000008 (topic: KSTREAM-MAP-0000000007-repartition)\n      <-- KSTREAM-FILTER-0000000009\n\n  Sub-topology: 1\n    Source: KSTREAM-SOURCE-0000000010 (topics: [KSTREAM-MAP-0000000007-repartition])\n      --> KSTREAM-JOIN-0000000011, KSTREAM-JOIN-0000000016\n    Processor: KSTREAM-JOIN-0000000011 (stores: [topic2-STATE-STORE-0000000001])\n      --> KSTREAM-SINK-0000000012\n      <-- KSTREAM-SOURCE-0000000010\n    Processor: KSTREAM-JOIN-0000000016 (stores: [topic3-STATE-STORE-0000000004])\n      --> KSTREAM-SINK-0000000017\n      <-- KSTREAM-SOURCE-0000000010\n    Source: KSTREAM-SOURCE-0000000002 (topics: [topic2])\n      --> KTABLE-SOURCE-0000000003\n    Source: KSTREAM-SOURCE-0000000005 (topics: [topic3])\n      --> KTABLE-SOURCE-0000000006\n    Sink: KSTREAM-SINK-0000000012 (topic: out-one)\n      <-- KSTREAM-JOIN-0000000011\n    Sink: KSTREAM-SINK-0000000017 (topic: out-two)\n      <-- KSTREAM-JOIN-0000000016\n    Processor: KTABLE-SOURCE-0000000003 (stores: [topic2-STATE-STORE-0000000001])\n      --> none\n      <-- KSTREAM-SOURCE-0000000002\n    Processor: KTABLE-SOURCE-0000000006 (stores: [topic3-STATE-STORE-0000000004])\n      --> none\n      <-- KSTREAM-SOURCE-0000000005\n\n";
    private final String expectedTopologyWithUserProvidedRepartitionTopicNames = "Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [topic])\n      --> KSTREAM-MAP-0000000007\n    Processor: KSTREAM-MAP-0000000007 (stores: [])\n      --> first-join-repartition-filter, second-join-repartition-filter\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: first-join-repartition-filter (stores: [])\n      --> first-join-repartition-sink\n      <-- KSTREAM-MAP-0000000007\n    Processor: second-join-repartition-filter (stores: [])\n      --> second-join-repartition-sink\n      <-- KSTREAM-MAP-0000000007\n    Sink: first-join-repartition-sink (topic: first-join-repartition)\n      <-- first-join-repartition-filter\n    Sink: second-join-repartition-sink (topic: second-join-repartition)\n      <-- second-join-repartition-filter\n\n  Sub-topology: 1\n    Source: first-join-repartition-source (topics: [first-join-repartition])\n      --> first-join\n    Source: KSTREAM-SOURCE-0000000002 (topics: [topic2])\n      --> KTABLE-SOURCE-0000000003\n    Processor: first-join (stores: [topic2-STATE-STORE-0000000001])\n      --> KSTREAM-SINK-0000000012\n      <-- first-join-repartition-source\n    Sink: KSTREAM-SINK-0000000012 (topic: out-one)\n      <-- first-join\n    Processor: KTABLE-SOURCE-0000000003 (stores: [topic2-STATE-STORE-0000000001])\n      --> none\n      <-- KSTREAM-SOURCE-0000000002\n\n  Sub-topology: 2\n    Source: second-join-repartition-source (topics: [second-join-repartition])\n      --> second-join\n    Source: KSTREAM-SOURCE-0000000005 (topics: [topic3])\n      --> KTABLE-SOURCE-0000000006\n    Processor: second-join (stores: [topic3-STATE-STORE-0000000004])\n      --> KSTREAM-SINK-0000000017\n      <-- second-join-repartition-source\n    Sink: KSTREAM-SINK-0000000017 (topic: out-two)\n      <-- second-join\n    Processor: KTABLE-SOURCE-0000000006 (stores: [topic3-STATE-STORE-0000000004])\n      --> none\n      <-- KSTREAM-SOURCE-0000000005\n\n";

    @BeforeEach
    public void setUp() {
        this.builder = new StreamsBuilder();
        Consumed consumed = Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String());
        KStream stream = this.builder.stream("streamTopic", consumed);
        KTable table = this.builder.table("tableTopic", consumed);
        stream.join(table, MockValueJoiner.TOSTRING_JOINER).process(this.supplier, new String[0]);
        Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());
        this.driver = new TopologyTestDriver(this.builder.build(), props);
        this.inputStreamTopic = this.driver.createInputTopic("streamTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
        this.inputTableTopic = this.driver.createInputTopic("tableTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
        this.processor = this.supplier.theCapturedProcessor();
    }

    @AfterEach
    public void cleanup() {
        this.driver.close();
    }

    private void pushToStream(int messageCount, String valuePrefix) {
        for (int i = 0; i < messageCount; ++i) {
            this.inputStreamTopic.pipeInput((Object)this.expectedKeys[i], (Object)(valuePrefix + this.expectedKeys[i]), (long)i);
        }
    }

    private void pushToTableNonRandom(int messageCount, String valuePrefix) {
        for (int i = 0; i < messageCount; ++i) {
            this.inputTableTopic.pipeInput((Object)this.expectedKeys[i], (Object)(valuePrefix + this.expectedKeys[i]), 0L);
        }
    }

    private void pushToTable(int messageCount, String valuePrefix) {
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < messageCount; ++i) {
            this.inputTableTopic.pipeInput((Object)this.expectedKeys[i], (Object)(valuePrefix + this.expectedKeys[i]), (long)r.nextInt(Integer.MAX_VALUE));
        }
    }

    private void pushNullValueToTable() {
        for (int i = 0; i < 2; ++i) {
            this.inputTableTopic.pipeInput((Object)this.expectedKeys[i], null);
        }
    }

    private void makeJoin(Duration grace) {
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        this.builder = new StreamsBuilder();
        Consumed consumed = Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String());
        KStream stream = this.builder.stream("streamTopic", consumed);
        KTable table = this.builder.table("tableTopic2", consumed, Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"V-grace", (Duration)Duration.ofMinutes(5L))));
        stream.join(table, MockValueJoiner.TOSTRING_JOINER, Joined.with((Serde)Serdes.Integer(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"Grace", (Duration)grace)).process(supplier, new String[0]);
        Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());
        this.driver = new TopologyTestDriver(this.builder.build(), props);
        this.inputStreamTopic = this.driver.createInputTopic("streamTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
        this.inputTableTopic = this.driver.createInputTopic("tableTopic2", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
        this.processor = supplier.theCapturedProcessor();
    }

    @Test
    public void shouldFailIfTableIsNotVersioned() {
        StreamsBuilder builder = new StreamsBuilder();
        Properties props = new Properties();
        props.put("topology.optimization", "none");
        KStream streamA = builder.stream("topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable tableB = builder.table("topic2", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> streamA.join(tableB, (value1, value2) -> value1 + value2, Joined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"first-join", (Duration)Duration.ofMillis(6L))).to("out-one"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"KTable must be versioned to use a grace period in a stream table join."));
    }

    @Test
    public void shouldFailIfTableIsNotVersionedButMaterializationIsInherited() {
        StreamsBuilder builder = new StreamsBuilder();
        Properties props = new Properties();
        props.put("topology.optimization", "none");
        KStream streamA = builder.stream("topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable source = builder.table("topic2", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()), Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"tableB")));
        KTable tableB = source.filter((k, v) -> true);
        streamA.join(tableB, (value1, value2) -> value1 + value2, Joined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"first-join", (Duration)Duration.ofMillis(6L))).to("out-one");
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((StreamsBuilder)builder).build());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"KTable must be versioned to use a grace period in a stream table join."));
    }

    @Test
    public void shouldNotFailIfTableIsVersionedButMaterializationIsInherited() {
        StreamsBuilder builder = new StreamsBuilder();
        Properties props = new Properties();
        props.put("topology.optimization", "none");
        KStream streamA = builder.stream("topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable source = builder.table("topic2", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()), Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"tableB", (Duration)Duration.ofMinutes(5L))));
        KTable tableB = source.filter((k, v) -> true);
        streamA.join(tableB, (value1, value2) -> value1 + value2, Joined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"first-join", (Duration)Duration.ofMillis(6L))).to("out-one");
        builder.build();
    }

    @Test
    public void shouldFailIfGracePeriodIsLongerThanHistoryRetention() {
        StreamsBuilder builder = new StreamsBuilder();
        Properties props = new Properties();
        props.put("topology.optimization", "none");
        KStream streamA = builder.stream("topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable tableB = builder.table("topic2", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()), Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"tableB", (Duration)Duration.ofMinutes(5L))));
        streamA.join(tableB, (value1, value2) -> value1 + value2, Joined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"first-join", (Duration)Duration.ofMinutes(6L))).to("out-one");
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> builder.build(props));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"History retention must be at least grace period."));
    }

    @Test
    public void shouldFailIfGracePeriodIsLongerThanHistoryRetentionAndInheritedStore() {
        StreamsBuilder builder = new StreamsBuilder();
        Properties props = new Properties();
        props.put("topology.optimization", "none");
        KStream streamA = builder.stream("topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable source = builder.table("topic2", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()), Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"V-grace", (Duration)Duration.ofMinutes(0L))));
        KTable tableB = source.filter((k, v) -> true);
        streamA.join(tableB, (value1, value2) -> value1 + value2, Joined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"first-join", (Duration)Duration.ofMillis(6L))).to("out-one");
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> builder.build(props));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"History retention must be at least grace period."));
    }

    @Test
    public void shouldDelayJoinByGracePeriod() {
        this.makeJoin(Duration.ofMillis(2L));
        this.pushToTableNonRandom(4, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+Y1", 1L));
        this.pushToTableNonRandom(4, "YY");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+YY0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+YY1", 1L));
        this.inputStreamTopic.pipeInput((Object)5, (Object)"test", 7L);
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "X2+YY2", 2L), new KeyValueTimestamp<Integer, String>(2, "X2+YY2", 2L), new KeyValueTimestamp<Integer, String>(3, "X3+YY3", 3L), new KeyValueTimestamp<Integer, String>(3, "X3+YY3", 3L));
        this.pushToTableNonRandom(4, "YYY");
        this.processor.checkAndClearProcessResult(EMPTY);
    }

    @Test
    public void shouldHandleLateJoinsWithGracePeriod() {
        this.makeJoin(Duration.ofMillis(2L));
        this.pushToTableNonRandom(4, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+Y1", 1L));
        this.pushToStream(1, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L));
    }

    @Test
    public void shouldReuseRepartitionTopicWithGeneratedName() {
        StreamsBuilder builder = new StreamsBuilder();
        Properties props = new Properties();
        props.put("topology.optimization", "none");
        KStream streamA = builder.stream("topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable tableB = builder.table("topic2", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable tableC = builder.table("topic3", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KStream rekeyedStream = streamA.map((k, v) -> new KeyValue(v, k));
        rekeyedStream.join(tableB, (value1, value2) -> value1 + value2).to("out-one");
        rekeyedStream.join(tableC, (value1, value2) -> value1 + value2).to("out-two");
        Topology topology = builder.build(props);
        Assertions.assertEquals((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [topic])\n      --> KSTREAM-MAP-0000000007\n    Processor: KSTREAM-MAP-0000000007 (stores: [])\n      --> KSTREAM-FILTER-0000000009\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KSTREAM-FILTER-0000000009 (stores: [])\n      --> KSTREAM-SINK-0000000008\n      <-- KSTREAM-MAP-0000000007\n    Sink: KSTREAM-SINK-0000000008 (topic: KSTREAM-MAP-0000000007-repartition)\n      <-- KSTREAM-FILTER-0000000009\n\n  Sub-topology: 1\n    Source: KSTREAM-SOURCE-0000000010 (topics: [KSTREAM-MAP-0000000007-repartition])\n      --> KSTREAM-JOIN-0000000011, KSTREAM-JOIN-0000000016\n    Processor: KSTREAM-JOIN-0000000011 (stores: [topic2-STATE-STORE-0000000001])\n      --> KSTREAM-SINK-0000000012\n      <-- KSTREAM-SOURCE-0000000010\n    Processor: KSTREAM-JOIN-0000000016 (stores: [topic3-STATE-STORE-0000000004])\n      --> KSTREAM-SINK-0000000017\n      <-- KSTREAM-SOURCE-0000000010\n    Source: KSTREAM-SOURCE-0000000002 (topics: [topic2])\n      --> KTABLE-SOURCE-0000000003\n    Source: KSTREAM-SOURCE-0000000005 (topics: [topic3])\n      --> KTABLE-SOURCE-0000000006\n    Sink: KSTREAM-SINK-0000000012 (topic: out-one)\n      <-- KSTREAM-JOIN-0000000011\n    Sink: KSTREAM-SINK-0000000017 (topic: out-two)\n      <-- KSTREAM-JOIN-0000000016\n    Processor: KTABLE-SOURCE-0000000003 (stores: [topic2-STATE-STORE-0000000001])\n      --> none\n      <-- KSTREAM-SOURCE-0000000002\n    Processor: KTABLE-SOURCE-0000000006 (stores: [topic3-STATE-STORE-0000000004])\n      --> none\n      <-- KSTREAM-SOURCE-0000000005\n\n", (Object)topology.describe().toString());
    }

    @Test
    public void shouldCreateRepartitionTopicsWithUserProvidedName() {
        StreamsBuilder builder = new StreamsBuilder();
        Properties props = new Properties();
        props.put("topology.optimization", "none");
        KStream streamA = builder.stream("topic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable tableB = builder.table("topic2", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable tableC = builder.table("topic3", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KStream rekeyedStream = streamA.map((k, v) -> new KeyValue(v, k));
        rekeyedStream.join(tableB, (value1, value2) -> value1 + value2, Joined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"first-join")).to("out-one");
        rekeyedStream.join(tableC, (value1, value2) -> value1 + value2, Joined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"second-join")).to("out-two");
        Topology topology = builder.build(props);
        System.out.println(topology.describe().toString());
        Assertions.assertEquals((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [topic])\n      --> KSTREAM-MAP-0000000007\n    Processor: KSTREAM-MAP-0000000007 (stores: [])\n      --> first-join-repartition-filter, second-join-repartition-filter\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: first-join-repartition-filter (stores: [])\n      --> first-join-repartition-sink\n      <-- KSTREAM-MAP-0000000007\n    Processor: second-join-repartition-filter (stores: [])\n      --> second-join-repartition-sink\n      <-- KSTREAM-MAP-0000000007\n    Sink: first-join-repartition-sink (topic: first-join-repartition)\n      <-- first-join-repartition-filter\n    Sink: second-join-repartition-sink (topic: second-join-repartition)\n      <-- second-join-repartition-filter\n\n  Sub-topology: 1\n    Source: first-join-repartition-source (topics: [first-join-repartition])\n      --> first-join\n    Source: KSTREAM-SOURCE-0000000002 (topics: [topic2])\n      --> KTABLE-SOURCE-0000000003\n    Processor: first-join (stores: [topic2-STATE-STORE-0000000001])\n      --> KSTREAM-SINK-0000000012\n      <-- first-join-repartition-source\n    Sink: KSTREAM-SINK-0000000012 (topic: out-one)\n      <-- first-join\n    Processor: KTABLE-SOURCE-0000000003 (stores: [topic2-STATE-STORE-0000000001])\n      --> none\n      <-- KSTREAM-SOURCE-0000000002\n\n  Sub-topology: 2\n    Source: second-join-repartition-source (topics: [second-join-repartition])\n      --> second-join\n    Source: KSTREAM-SOURCE-0000000005 (topics: [topic3])\n      --> KTABLE-SOURCE-0000000006\n    Processor: second-join (stores: [topic3-STATE-STORE-0000000004])\n      --> KSTREAM-SINK-0000000017\n      <-- second-join-repartition-source\n    Sink: KSTREAM-SINK-0000000017 (topic: out-two)\n      <-- second-join\n    Processor: KTABLE-SOURCE-0000000006 (stores: [topic3-STATE-STORE-0000000004])\n      --> none\n      <-- KSTREAM-SOURCE-0000000005\n\n", (Object)topology.describe().toString());
    }

    @Test
    public void shouldRequireCopartitionedStreams() {
        Collection copartitionGroups = TopologyWrapper.getInternalTopologyBuilder(this.builder.build()).copartitionGroups();
        Assertions.assertEquals((int)1, (int)copartitionGroups.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("streamTopic", "tableTopic")), copartitionGroups.iterator().next());
    }

    @Test
    public void shouldNotJoinWithEmptyTableOnStreamUpdates() {
        this.pushToStream(2, "X");
        this.processor.checkAndClearProcessResult(EMPTY);
    }

    @Test
    public void shouldNotJoinOnTableUpdates() {
        this.pushToStream(2, "X");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToTable(2, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+Y1", 1L));
        this.pushToTable(4, "YY");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+YY0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+YY1", 1L), new KeyValueTimestamp<Integer, String>(2, "X2+YY2", 2L), new KeyValueTimestamp<Integer, String>(3, "X3+YY3", 3L));
        this.pushToTable(4, "YYY");
        this.processor.checkAndClearProcessResult(EMPTY);
    }

    @Test
    public void shouldJoinOnlyIfMatchFoundOnStreamUpdates() {
        this.pushToTable(2, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+Y1", 1L));
    }

    @Test
    public void shouldClearTableEntryOnNullValueUpdates() {
        this.pushToTable(4, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+Y1", 1L), new KeyValueTimestamp<Integer, String>(2, "X2+Y2", 2L), new KeyValueTimestamp<Integer, String>(3, "X3+Y3", 3L));
        this.pushNullValueToTable();
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "XX");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "XX2+Y2", 2L), new KeyValueTimestamp<Integer, String>(3, "XX3+Y3", 3L));
    }

    @Test
    public void shouldLogAndMeterWhenSkippingNullLeftKey() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(KStreamKTableJoin.class);){
            TestInputTopic inputTopic = this.driver.createInputTopic("streamTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            inputTopic.pipeInput(null, (Object)"A");
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Skipping record due to null join key or value. topic=[streamTopic] partition=[0] offset=[0]"));
        }
    }

    @Test
    public void shouldLogAndMeterWhenSkippingNullLeftValue() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(KStreamKTableJoin.class);){
            TestInputTopic inputTopic = this.driver.createInputTopic("streamTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            inputTopic.pipeInput((Object)1, null);
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Skipping record due to null join key or value. topic=[streamTopic] partition=[0] offset=[0]"));
        }
    }
}

