/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KStreamImplValueJoinerWithKeyTest {
    private KStream<String, Integer> leftStream;
    private KStream<String, Integer> rightStream;
    private KTable<String, Integer> ktable;
    private GlobalKTable<String, Integer> globalKTable;
    private StreamsBuilder builder;
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
    private final String leftTopic = "left";
    private final String rightTopic = "right";
    private final String ktableTopic = "ktableTopic";
    private final String globalTopic = "globalTopic";
    private final String outputTopic = "joined-result";
    private final ValueJoinerWithKey<String, Integer, Integer, String> valueJoinerWithKey = (key, lv, rv) -> key + ":" + (lv + (rv == null ? 0 : rv));
    private final JoinWindows joinWindows = JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(100L), (Duration)Duration.ofHours(24L));
    private final StreamJoined<String, Integer, Integer> streamJoined = StreamJoined.with((Serde)Serdes.String(), (Serde)Serdes.Integer(), (Serde)Serdes.Integer());
    private final Joined<String, Integer, Integer> joined = Joined.with((Serde)Serdes.String(), (Serde)Serdes.Integer(), (Serde)Serdes.Integer());
    private final KeyValueMapper<String, Integer, String> keyValueMapper = (k, v) -> k;

    @BeforeEach
    public void setup() {
        this.builder = new StreamsBuilder();
        this.leftStream = this.builder.stream("left", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Integer()));
        this.rightStream = this.builder.stream("right", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Integer()));
        this.ktable = this.builder.table("ktableTopic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Integer()));
        this.globalKTable = this.builder.globalTable("globalTopic", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Integer()));
    }

    @Test
    public void shouldIncludeKeyInStreamSteamJoinResults() {
        this.leftStream.join(this.rightStream, this.valueJoinerWithKey, this.joinWindows, this.streamJoined).to("joined-result", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.runJoinTopology(this.builder, Collections.singletonList(KeyValue.pair((Object)"A", (Object)"A:5")), false, "right");
    }

    @Test
    public void shouldIncludeKeyInStreamLeftJoinResults() {
        this.leftStream.leftJoin(this.rightStream, this.valueJoinerWithKey, this.joinWindows, this.streamJoined).to("joined-result", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        List<KeyValue<String, String>> expectedResults = Collections.singletonList(KeyValue.pair((Object)"A", (Object)"A:5"));
        this.runJoinTopology(this.builder, expectedResults, false, "right");
    }

    @Test
    public void shouldIncludeKeyInStreamOuterJoinResults() {
        this.leftStream.outerJoin(this.rightStream, this.valueJoinerWithKey, this.joinWindows, this.streamJoined).to("joined-result", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        List<KeyValue<String, String>> expectedResults = Collections.singletonList(KeyValue.pair((Object)"A", (Object)"A:5"));
        this.runJoinTopology(this.builder, expectedResults, false, "right");
    }

    @Test
    public void shouldIncludeKeyInStreamTableJoinResults() {
        this.leftStream.join(this.ktable, this.valueJoinerWithKey, this.joined).to("joined-result", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.runJoinTopology(this.builder, Collections.singletonList(KeyValue.pair((Object)"A", (Object)"A:5")), true, "ktableTopic");
    }

    @Test
    public void shouldIncludeKeyInStreamTableLeftJoinResults() {
        this.leftStream.leftJoin(this.ktable, this.valueJoinerWithKey, this.joined).to("joined-result", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.runJoinTopology(this.builder, Collections.singletonList(KeyValue.pair((Object)"A", (Object)"A:5")), true, "ktableTopic");
    }

    @Test
    public void shouldIncludeKeyInStreamGlobalTableJoinResults() {
        this.leftStream.join(this.globalKTable, this.keyValueMapper, this.valueJoinerWithKey).to("joined-result", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.runJoinTopology(this.builder, Collections.singletonList(KeyValue.pair((Object)"A", (Object)"A:5")), true, "globalTopic");
    }

    @Test
    public void shouldIncludeKeyInStreamGlobalTableLeftJoinResults() {
        this.leftStream.leftJoin(this.globalKTable, this.keyValueMapper, this.valueJoinerWithKey).to("joined-result", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.runJoinTopology(this.builder, Collections.singletonList(KeyValue.pair((Object)"A", (Object)"A:5")), true, "globalTopic");
    }

    private void runJoinTopology(StreamsBuilder builder, List<KeyValue<String, String>> expectedResults, boolean isTableJoin, String rightTopic) {
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic rightInputTopic = driver.createInputTopic(rightTopic, (Serializer)new StringSerializer(), (Serializer)new IntegerSerializer());
            TestInputTopic leftInputTopic = driver.createInputTopic("left", (Serializer)new StringSerializer(), (Serializer)new IntegerSerializer());
            TestOutputTopic joinResultTopic = driver.createOutputTopic("joined-result", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            if (isTableJoin) {
                rightInputTopic.pipeInput((Object)"A", (Object)2);
                leftInputTopic.pipeInput((Object)"A", (Object)3);
            } else {
                leftInputTopic.pipeInput((Object)"A", (Object)3);
                rightInputTopic.pipeInput((Object)"A", (Object)2);
            }
            List actualResult = joinResultTopic.readKeyValuesToList();
            Assertions.assertEquals(expectedResults, (Object)actualResult);
        }
    }
}

