/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamFlatTransform;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class KStreamFlatTransformTest {
    private Number inputKey;
    private Number inputValue;
    @Mock
    private Transformer<Number, Number, Iterable<KeyValue<Integer, Integer>>> transformer;
    @Mock
    private InternalProcessorContext<Integer, Integer> context;
    private InOrder inOrder;
    private KStreamFlatTransform.KStreamFlatTransformProcessor<Number, Number, Integer, Integer> processor;

    @BeforeEach
    public void setUp() {
        this.inputKey = 1;
        this.inputValue = 10;
        this.inOrder = Mockito.inOrder((Object[])new Object[]{this.context});
        this.processor = new KStreamFlatTransform.KStreamFlatTransformProcessor(this.transformer);
    }

    @Test
    public void shouldInitialiseFlatTransformProcessor() {
        this.processor.init(this.context);
        ((Transformer)Mockito.verify(this.transformer)).init(this.context);
    }

    @Test
    public void shouldTransformInputRecordToMultipleOutputRecords() {
        List<KeyValue> outputRecords = Arrays.asList(KeyValue.pair((Object)2, (Object)20), KeyValue.pair((Object)3, (Object)30), KeyValue.pair((Object)4, (Object)40));
        this.processor.init(this.context);
        Mockito.when((Object)this.transformer.transform((Object)this.inputKey, (Object)this.inputValue)).thenReturn(outputRecords);
        this.processor.process(new Record((Object)this.inputKey, (Object)this.inputValue, 0L));
        for (KeyValue outputRecord : outputRecords) {
            ((InternalProcessorContext)this.inOrder.verify(this.context)).forward(new Record(outputRecord.key, outputRecord.value, 0L));
        }
    }

    @Test
    public void shouldAllowEmptyListAsResultOfTransform() {
        this.processor.init(this.context);
        Mockito.when((Object)this.transformer.transform((Object)this.inputKey, (Object)this.inputValue)).thenReturn(Collections.emptyList());
        this.processor.process(new Record((Object)this.inputKey, (Object)this.inputValue, 0L));
        ((InternalProcessorContext)this.inOrder.verify(this.context, Mockito.never())).forward((Record)ArgumentMatchers.any());
    }

    @Test
    public void shouldAllowNullAsResultOfTransform() {
        this.processor.init(this.context);
        Mockito.when((Object)this.transformer.transform((Object)this.inputKey, (Object)this.inputValue)).thenReturn(null);
        this.processor.process(new Record((Object)this.inputKey, (Object)this.inputValue, 0L));
        ((InternalProcessorContext)this.inOrder.verify(this.context, Mockito.never())).forward((Record)ArgumentMatchers.any());
    }

    @Test
    public void shouldCloseFlatTransformProcessor() {
        this.processor.close();
        ((Transformer)Mockito.verify(this.transformer)).close();
    }

    @Test
    public void shouldGetFlatTransformProcessor() {
        TransformerSupplier transformerSupplier = (TransformerSupplier)Mockito.mock(TransformerSupplier.class);
        KStreamFlatTransform processorSupplier = new KStreamFlatTransform(transformerSupplier);
        Mockito.when((Object)transformerSupplier.get()).thenReturn(this.transformer);
        Processor processor = processorSupplier.get();
        Assertions.assertInstanceOf(KStreamFlatTransform.KStreamFlatTransformProcessor.class, (Object)processor);
    }
}

