/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.test.TestRecord;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
@Timeout(value=600L)
public class TableTableJoinIntegrationTest
extends AbstractJoinIntegrationTest {
    private static final String APP_ID = "table-table-join-integration-test";
    private static final String STORE_NAME = "table-table-join-integration-test-store";
    private final TestRecord<Long, String> expectedFinalJoinResultUnversioned = new TestRecord((Object)0L, (Object)"F-f", null, Long.valueOf(4L));
    private final TestRecord<Long, String> expectedFinalJoinResultLeftVersionedOnly = new TestRecord((Object)0L, (Object)"E-f", null, Long.valueOf(15L));
    private final TestRecord<Long, String> expectedFinalJoinResultRightVersionedOnly = new TestRecord((Object)0L, (Object)"F-e", null, Long.valueOf(14L));
    private final TestRecord<Long, String> expectedFinalMultiJoinResult = new TestRecord((Object)0L, (Object)"F-f-f", null, Long.valueOf(4L));
    private final Materialized<Long, String, KeyValueStore<Bytes, byte[]>> materialized = Materialized.as((String)"table-table-join-integration-test-store").withKeySerde(Serdes.Long()).withValueSerde(Serdes.String()).withCachingDisabled().withLoggingDisabled();

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInner(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner");
        leftTable.join(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultUnversioned, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(14L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-f", null, Long.valueOf(4L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeft(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-left");
        leftTable.leftJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultUnversioned, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(14L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-null", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"F-f", null, Long.valueOf(4L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuter(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-outer");
        leftTable.outerJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultUnversioned, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"F-null", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"F-f", null, Long.valueOf(4L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInnerWithVersionedStores(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner");
        leftTable.join(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, null, null);
        this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeftWithVersionedStores(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-left");
        leftTable.leftJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, null, null);
        this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuterWithVersionedStores(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-outer");
        leftTable.outerJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, null, null);
        this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInnerWithLeftVersionedOnly(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner");
        leftTable.join(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultLeftVersionedOnly, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-f", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeftWithLeftVersionedOnly(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-left");
        leftTable.leftJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultLeftVersionedOnly, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-null", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-f", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuterWithLeftVersionedOnly(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-outer");
        leftTable.outerJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultLeftVersionedOnly, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-null", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-f", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInnerWithRightVersionedOnly(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner");
        leftTable.join(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultRightVersionedOnly, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(14L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-e", null, Long.valueOf(14L))), null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeftWithRightVersionedOnly(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-left");
        leftTable.leftJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultRightVersionedOnly, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-null", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(2L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(14L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-e", null, Long.valueOf(14L))), null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuterWithRightVersionedOnly(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-outer");
        leftTable.outerJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultRightVersionedOnly, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-null", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(2L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-e", null, Long.valueOf(14L))), null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInnerInner(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-inner");
        leftTable.join(rightTable, this.valueJoiner).join(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInnerLeft(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-left");
        leftTable.join(rightTable, this.valueJoiner).leftJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInnerOuter(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-outer");
        leftTable.join(rightTable, this.valueJoiner).outerJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, null, null, Long.valueOf(11L)), new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeftInner(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-inner");
        leftTable.leftJoin(rightTable, this.valueJoiner).join(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeftLeft(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-left");
        leftTable.leftJoin(rightTable, this.valueJoiner).leftJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null-null", null, Long.valueOf(3L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L)), new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeftOuter(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-outer");
        leftTable.leftJoin(rightTable, this.valueJoiner).outerJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null-null", null, Long.valueOf(3L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L)), new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuterInner(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-inner");
        leftTable.outerJoin(rightTable, this.valueJoiner).join(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b-b", null, Long.valueOf(7L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuterLeft(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-left");
        leftTable.outerJoin(rightTable, this.valueJoiner).leftJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null-null", null, Long.valueOf(3L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L)), new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Arrays.asList(new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuterOuter(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable leftTable = builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "table-table-join-integration-test-inner-outer");
        leftTable.outerJoin(rightTable, this.valueJoiner).outerJoin(rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null-null", null, Long.valueOf(3L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b-b", null, Long.valueOf(7L))), Arrays.asList(new TestRecord((Object)0L, null, null, Long.valueOf(8L)), new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L)), new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Arrays.asList(new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, STORE_NAME, streamsConfig, builder.build(streamsConfig));
        }
    }
}

