/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.test.TestRecord;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
@Timeout(value=600L)
public class StreamTableJoinIntegrationTest
extends AbstractJoinIntegrationTest {
    private static final String STORE_NAME = "table-store";
    private static final String APP_ID = "stream-table-join-integration-test";

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInner(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KTable rightTable = builder.table("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-table-join-integration-test-inner");
        leftStream.join(rightTable, this.valueJoiner).to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), null, null, null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(6L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, null, null);
        this.runTestWithDriver(this.input, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeft(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KTable rightTable = builder.table("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-table-join-integration-test-left");
        leftStream.leftJoin(rightTable, this.valueJoiner).to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(6L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-null", null, Long.valueOf(4L))), null);
        this.runTestWithDriver(this.input, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInnerWithVersionedStore(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)STORE_NAME, (Duration)Duration.ofMinutes(5L))));
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-table-join-integration-test-inner");
        leftStream.join(rightTable, this.valueJoiner).to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), null, null, null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(6L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-a", null, Long.valueOf(4L))), null);
        this.runTestWithDriver(this.input, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeftWithVersionedStore(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KTable rightTable = builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)STORE_NAME, (Duration)Duration.ofMinutes(5L))));
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-table-join-integration-test-left");
        leftStream.leftJoin(rightTable, this.valueJoiner).to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(6L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-a", null, Long.valueOf(4L))), null);
        this.runTestWithDriver(this.input, expectedResult, streamsConfig, builder.build(streamsConfig));
    }
}

