/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.streams.integration.AbstractResetIntegrationTest;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;

@Tag(value="integration")
public class ResetIntegrationWithSslTest
extends AbstractResetIntegrationTest {
    public static final EmbeddedKafkaCluster CLUSTER;
    private static final Map<String, Object> SSL_CONFIG;

    @BeforeAll
    public static void startCluster() throws IOException {
        CLUSTER.start();
    }

    @AfterAll
    public static void closeCluster() {
        CLUSTER.stop();
    }

    @Override
    Map<String, Object> getClientSslConfig() {
        return SSL_CONFIG;
    }

    @BeforeEach
    public void before(TestInfo testInfo) throws Exception {
        cluster = CLUSTER;
        this.prepareTest(testInfo);
    }

    @AfterEach
    public void after() throws Exception {
        this.cleanupTest();
    }

    static {
        Properties brokerProps = new Properties();
        brokerProps.put("connections.max.idle.ms", (Object)-1L);
        try {
            SSL_CONFIG = TestSslUtils.createSslConfig((boolean)false, (boolean)true, (ConnectionMode)ConnectionMode.SERVER, (File)TestUtils.tempFile(), (String)"testCert");
            brokerProps.put("listeners", "SSL://localhost:0");
            brokerProps.put("inter.broker.listener.name", "SSL");
            brokerProps.putAll(SSL_CONFIG);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CLUSTER = new EmbeddedKafkaCluster(1, brokerProps);
    }
}

