/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Tag(value="integration")
@Timeout(value=600L)
public class KStreamTransformIntegrationTest {
    private StreamsBuilder builder;
    private final String topic = "stream";
    private final String stateStoreName = "myTransformState";
    private final List<KeyValue<Integer, Integer>> results = new ArrayList<KeyValue<Integer, Integer>>();
    private final ForeachAction<Integer, Integer> accumulateExpected = (key, value) -> this.results.add((KeyValue<Integer, Integer>)KeyValue.pair((Object)key, (Object)value));
    private KStream<Integer, Integer> stream;

    @BeforeEach
    public void before() {
        this.builder = new StreamsBuilder();
        this.stream = this.builder.stream("stream", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
    }

    private StoreBuilder<KeyValueStore<Integer, Integer>> storeBuilder() {
        return Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)"myTransformState"), (Serde)Serdes.Integer(), (Serde)Serdes.Integer());
    }

    private void verifyResult(List<KeyValue<Integer, Integer>> expected) {
        Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.Integer());
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), props);){
            TestInputTopic inputTopic = driver.createInputTopic("stream", (Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer());
            inputTopic.pipeKeyValueList(Arrays.asList(new KeyValue((Object)1, (Object)1), new KeyValue((Object)2, (Object)2), new KeyValue((Object)3, (Object)3), new KeyValue((Object)2, (Object)1), new KeyValue((Object)2, (Object)3), new KeyValue((Object)1, (Object)3)));
        }
        MatcherAssert.assertThat(this.results, (Matcher)IsEqual.equalTo(expected));
    }

    @Test
    public void shouldTransform() {
        this.builder.addStateStore(this.storeBuilder());
        this.stream.transform(() -> new TestTransformer(), new String[]{"myTransformState"}).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)2, (Object)1), KeyValue.pair((Object)3, (Object)2), KeyValue.pair((Object)4, (Object)3), KeyValue.pair((Object)3, (Object)2), KeyValue.pair((Object)3, (Object)5), KeyValue.pair((Object)2, (Object)4));
        this.verifyResult(expected);
    }

    @Test
    public void shouldTransformWithConnectedStoreProvider() {
        this.stream.transform((TransformerSupplier)new TransformerSupplier<Integer, Integer, KeyValue<Integer, Integer>>(){

            public Transformer<Integer, Integer, KeyValue<Integer, Integer>> get() {
                return new TestTransformer();
            }

            public Set<StoreBuilder<?>> stores() {
                return Collections.singleton(KStreamTransformIntegrationTest.this.storeBuilder());
            }
        }, new String[0]).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)2, (Object)1), KeyValue.pair((Object)3, (Object)2), KeyValue.pair((Object)4, (Object)3), KeyValue.pair((Object)3, (Object)2), KeyValue.pair((Object)3, (Object)5), KeyValue.pair((Object)2, (Object)4));
        this.verifyResult(expected);
    }

    @Test
    public void shouldFlatTransform() {
        this.builder.addStateStore(this.storeBuilder());
        this.stream.flatTransform(() -> new TestFlatTransformer(), new String[]{"myTransformState"}).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)4, (Object)4), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)4, (Object)4), KeyValue.pair((Object)5, (Object)5), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)3, (Object)5), KeyValue.pair((Object)4, (Object)6), KeyValue.pair((Object)2, (Object)9), KeyValue.pair((Object)3, (Object)10), KeyValue.pair((Object)4, (Object)11), KeyValue.pair((Object)1, (Object)6), KeyValue.pair((Object)2, (Object)7), KeyValue.pair((Object)3, (Object)8));
        this.verifyResult(expected);
    }

    @Test
    public void shouldFlatTransformWithConnectedStoreProvider() {
        this.stream.flatTransform((TransformerSupplier)new TransformerSupplier<Integer, Integer, Iterable<KeyValue<Integer, Integer>>>(){

            public Transformer<Integer, Integer, Iterable<KeyValue<Integer, Integer>>> get() {
                return new TestFlatTransformer();
            }

            public Set<StoreBuilder<?>> stores() {
                return Collections.singleton(KStreamTransformIntegrationTest.this.storeBuilder());
            }
        }, new String[0]).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)4, (Object)4), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)4, (Object)4), KeyValue.pair((Object)5, (Object)5), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)3, (Object)5), KeyValue.pair((Object)4, (Object)6), KeyValue.pair((Object)2, (Object)9), KeyValue.pair((Object)3, (Object)10), KeyValue.pair((Object)4, (Object)11), KeyValue.pair((Object)1, (Object)6), KeyValue.pair((Object)2, (Object)7), KeyValue.pair((Object)3, (Object)8));
        this.verifyResult(expected);
    }

    @Test
    public void shouldTransformValuesWithValueTransformerWithKey() {
        this.builder.addStateStore(this.storeBuilder());
        this.stream.transformValues(() -> new TestValueTransformerWithKey(), new String[]{"myTransformState"}).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)2, (Object)5), KeyValue.pair((Object)1, (Object)4));
        this.verifyResult(expected);
    }

    @Test
    public void shouldTransformValuesWithValueTransformerWithKeyWithConnectedStoreProvider() {
        this.stream.transformValues((ValueTransformerWithKeySupplier)new ValueTransformerWithKeySupplier<Integer, Integer, Integer>(){

            public ValueTransformerWithKey<Integer, Integer, Integer> get() {
                return new TestValueTransformerWithKey();
            }

            public Set<StoreBuilder<?>> stores() {
                return Collections.singleton(KStreamTransformIntegrationTest.this.storeBuilder());
            }
        }, new String[0]).foreach(this.accumulateExpected);
    }

    @Test
    public void shouldTransformValuesWithValueTransformerWithoutKey() {
        this.builder.addStateStore(this.storeBuilder());
        this.stream.transformValues(() -> new TestValueTransformer(), new String[]{"myTransformState"}).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)2, (Object)1), KeyValue.pair((Object)3, (Object)1), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)1, (Object)3));
        this.verifyResult(expected);
    }

    @Test
    public void shouldTransformValuesWithValueTransformerWithoutKeyWithConnectedStoreProvider() {
        this.stream.transformValues((ValueTransformerSupplier)new ValueTransformerSupplier<Integer, Integer>(){

            public ValueTransformer<Integer, Integer> get() {
                return new TestValueTransformer();
            }

            public Set<StoreBuilder<?>> stores() {
                return Collections.singleton(KStreamTransformIntegrationTest.this.storeBuilder());
            }
        }, new String[0]).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)2, (Object)1), KeyValue.pair((Object)3, (Object)1), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)1, (Object)3));
        this.verifyResult(expected);
    }

    @Test
    public void shouldFlatTransformValuesWithKey() {
        this.builder.addStateStore(this.storeBuilder());
        this.stream.flatTransformValues(() -> new TestValueTransformerWithoutKey(), new String[]{"myTransformState"}).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)1, (Object)2), KeyValue.pair((Object)1, (Object)3), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)2, (Object)3), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)3, (Object)4), KeyValue.pair((Object)3, (Object)5), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)2, (Object)5), KeyValue.pair((Object)2, (Object)6), KeyValue.pair((Object)2, (Object)9), KeyValue.pair((Object)2, (Object)10), KeyValue.pair((Object)2, (Object)11), KeyValue.pair((Object)1, (Object)6), KeyValue.pair((Object)1, (Object)7), KeyValue.pair((Object)1, (Object)8));
        this.verifyResult(expected);
    }

    @Test
    public void shouldFlatTransformValuesWithKeyWithConnectedStoreProvider() {
        this.stream.flatTransformValues((ValueTransformerWithKeySupplier)new ValueTransformerWithKeySupplier<Integer, Integer, Iterable<Integer>>(){

            public ValueTransformerWithKey<Integer, Integer, Iterable<Integer>> get() {
                return new TestValueTransformerWithoutKey();
            }

            public Set<StoreBuilder<?>> stores() {
                return Collections.singleton(KStreamTransformIntegrationTest.this.storeBuilder());
            }
        }, new String[0]).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)1, (Object)2), KeyValue.pair((Object)1, (Object)3), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)2, (Object)3), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)3, (Object)4), KeyValue.pair((Object)3, (Object)5), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)2, (Object)5), KeyValue.pair((Object)2, (Object)6), KeyValue.pair((Object)2, (Object)9), KeyValue.pair((Object)2, (Object)10), KeyValue.pair((Object)2, (Object)11), KeyValue.pair((Object)1, (Object)6), KeyValue.pair((Object)1, (Object)7), KeyValue.pair((Object)1, (Object)8));
        this.verifyResult(expected);
    }

    @Test
    public void shouldFlatTransformValuesWithValueTransformerWithoutKey() {
        this.builder.addStateStore(this.storeBuilder());
        this.stream.flatTransformValues(() -> new TestFlatValueTransformer(), new String[]{"myTransformState"}).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)1, (Object)2), KeyValue.pair((Object)1, (Object)3), KeyValue.pair((Object)2, (Object)1), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)2, (Object)3), KeyValue.pair((Object)3, (Object)1), KeyValue.pair((Object)3, (Object)2), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)2, (Object)5), KeyValue.pair((Object)2, (Object)6), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)2, (Object)5), KeyValue.pair((Object)2, (Object)6), KeyValue.pair((Object)1, (Object)7), KeyValue.pair((Object)1, (Object)8), KeyValue.pair((Object)1, (Object)9));
        this.verifyResult(expected);
    }

    @Test
    public void shouldFlatTransformValuesWithValueTransformerWithoutKeyWithConnectedStoreProvider() {
        this.stream.flatTransformValues((ValueTransformerSupplier)new ValueTransformerSupplier<Integer, Iterable<Integer>>(){

            public ValueTransformer<Integer, Iterable<Integer>> get() {
                return new TestFlatValueTransformer();
            }

            public Set<StoreBuilder<?>> stores() {
                return Collections.singleton(KStreamTransformIntegrationTest.this.storeBuilder());
            }
        }, new String[0]).foreach(this.accumulateExpected);
        List<KeyValue<Integer, Integer>> expected = Arrays.asList(KeyValue.pair((Object)1, (Object)1), KeyValue.pair((Object)1, (Object)2), KeyValue.pair((Object)1, (Object)3), KeyValue.pair((Object)2, (Object)1), KeyValue.pair((Object)2, (Object)2), KeyValue.pair((Object)2, (Object)3), KeyValue.pair((Object)3, (Object)1), KeyValue.pair((Object)3, (Object)2), KeyValue.pair((Object)3, (Object)3), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)2, (Object)5), KeyValue.pair((Object)2, (Object)6), KeyValue.pair((Object)2, (Object)4), KeyValue.pair((Object)2, (Object)5), KeyValue.pair((Object)2, (Object)6), KeyValue.pair((Object)1, (Object)7), KeyValue.pair((Object)1, (Object)8), KeyValue.pair((Object)1, (Object)9));
        this.verifyResult(expected);
    }

    private class TestFlatValueTransformer
    implements ValueTransformer<Integer, Iterable<Integer>> {
        private KeyValueStore<Integer, Integer> state;

        private TestFlatValueTransformer() {
        }

        public void init(ProcessorContext context) {
            this.state = (KeyValueStore)context.getStateStore("myTransformState");
        }

        public Iterable<Integer> transform(Integer value) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            this.state.putIfAbsent((Object)value, (Object)0);
            Integer counter = (Integer)this.state.get((Object)value);
            for (int i = 0; i < 3; ++i) {
                counter = counter + 1;
                result.add(counter);
            }
            this.state.put((Object)value, (Object)counter);
            return result;
        }

        public void close() {
        }
    }

    private class TestValueTransformerWithoutKey
    implements ValueTransformerWithKey<Integer, Integer, Iterable<Integer>> {
        private KeyValueStore<Integer, Integer> state;

        private TestValueTransformerWithoutKey() {
        }

        public void init(ProcessorContext context) {
            this.state = (KeyValueStore)context.getStateStore("myTransformState");
        }

        public Iterable<Integer> transform(Integer key, Integer value) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            this.state.putIfAbsent((Object)key, (Object)0);
            Integer storedValue = (Integer)this.state.get((Object)key);
            for (int i = 0; i < 3; ++i) {
                Integer n = storedValue;
                Integer n2 = storedValue = Integer.valueOf(storedValue + 1);
                result.add(value + n);
            }
            this.state.put((Object)key, (Object)storedValue);
            return result;
        }

        public void close() {
        }
    }

    private class TestValueTransformer
    implements ValueTransformer<Integer, Integer> {
        private KeyValueStore<Integer, Integer> state;

        private TestValueTransformer() {
        }

        public void init(ProcessorContext context) {
            this.state = (KeyValueStore)context.getStateStore("myTransformState");
        }

        public Integer transform(Integer value) {
            this.state.putIfAbsent((Object)value, (Object)0);
            Integer counter = (Integer)this.state.get((Object)value);
            counter = counter + 1;
            this.state.put((Object)value, (Object)counter);
            return counter;
        }

        public void close() {
        }
    }

    private class TestValueTransformerWithKey
    implements ValueTransformerWithKey<Integer, Integer, Integer> {
        private KeyValueStore<Integer, Integer> state;

        private TestValueTransformerWithKey() {
        }

        public void init(ProcessorContext context) {
            this.state = (KeyValueStore)context.getStateStore("myTransformState");
        }

        public Integer transform(Integer key, Integer value) {
            Integer storedValue;
            this.state.putIfAbsent((Object)key, (Object)0);
            Integer n = storedValue = (Integer)this.state.get((Object)key);
            Integer n2 = storedValue = Integer.valueOf(storedValue + 1);
            Integer result = value + n;
            this.state.put((Object)key, (Object)storedValue);
            return result;
        }

        public void close() {
        }
    }

    private class TestFlatTransformer
    implements Transformer<Integer, Integer, Iterable<KeyValue<Integer, Integer>>> {
        private KeyValueStore<Integer, Integer> state;

        private TestFlatTransformer() {
        }

        public void init(ProcessorContext context) {
            this.state = (KeyValueStore)context.getStateStore("myTransformState");
        }

        public Iterable<KeyValue<Integer, Integer>> transform(Integer key, Integer value) {
            ArrayList<KeyValue<Integer, Integer>> result = new ArrayList<KeyValue<Integer, Integer>>();
            this.state.putIfAbsent((Object)key, (Object)0);
            Integer storedValue = (Integer)this.state.get((Object)key);
            for (int i = 0; i < 3; ++i) {
                Integer n = storedValue;
                Integer n2 = storedValue = Integer.valueOf(storedValue + 1);
                result.add((KeyValue<Integer, Integer>)new KeyValue((Object)(key + i), (Object)(value + n)));
            }
            this.state.put((Object)key, (Object)storedValue);
            return result;
        }

        public void close() {
        }
    }

    private class TestTransformer
    implements Transformer<Integer, Integer, KeyValue<Integer, Integer>> {
        private KeyValueStore<Integer, Integer> state;

        private TestTransformer() {
        }

        public void init(ProcessorContext context) {
            this.state = (KeyValueStore)context.getStateStore("myTransformState");
        }

        public KeyValue<Integer, Integer> transform(Integer key, Integer value) {
            Integer storedValue;
            this.state.putIfAbsent((Object)key, (Object)0);
            Integer n = storedValue = (Integer)this.state.get((Object)key);
            Integer n2 = storedValue = Integer.valueOf(storedValue + 1);
            KeyValue result = new KeyValue((Object)(key + 1), (Object)(value + n));
            this.state.put((Object)key, (Object)storedValue);
            return result;
        }

        public void close() {
        }
    }
}

